<?php

namespace Modules\Hr\Entities;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;
class EmployeeOtherEarningDeduction extends Model
{
    protected $table = 'hr_employee_other_earning_deductions';
    use HasFactory,LogsActivity;
    protected static $logAttributes = [
        'id',
        'employee_id',
        'earn_deduct_id',
        'amount',
    ];
    protected static $logOnlyDirty = true;
    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->log_name = "hr_employee_other_earning_deductions";
        $activity->description = $eventName;
        $activity->causer_id = Auth::user()->id;
    }
}
