<?php

namespace Modules\Hr\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;
class Leave extends Model
{
    protected $table = 'hr_leaves';
    protected $primaryKey = 'leave_id';
    public $incrementing = false;
    protected $keyType = 'string';
    use HasFactory,LogsActivity;
    protected static $logAttributes = [
        'leave_id',
        'employee_id',
        'employee_name',
        'date',
        'from',
        'to',
        'day_count',
        'reason',
        'leave_type_id',
        'status',
        'approved_by',
    ];
    protected static $logOnlyDirty = true;
    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->log_name = "hr_leaves";
        $activity->description = $eventName;
        $activity->causer_id = Auth::user()->id;
    }
}
