<?php

namespace Modules\Hr\Entities;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;
class SalaryData extends Model
{
    protected $table = 'hr_salary_data';
    use HasFactory,LogsActivity;
    protected static $logAttributes = [
        'id',
        'employee_id',
        'category_id',
        'site_id',
        'department_id',
        'section_id',
        'subsection_id',
        'company_id',
        'basic_salary',

        'ot_hours1',
        'ot_rate1',
        'ot_rate1_amount',
        'ot_amount1',
        'ot_hours2',
        'ot_rate2',
        'ot_rate2_amount',
        'ot_amount2',
        'ot_hours3',
        'ot_rate3',
        'ot_rate3_amount',
        'ot_amount3',

        'advance',
        'loan',
        'loan_interest',
        'debtor_loan',
        'debtor_loan_interest',
        'worked_days',

        'nopay_days',
        'nopay_amount',
        'budget1',
        'budget2',
        'employer_epf',
        'employee_epf',
        'employee_etf',
        'tax1',
        'tax2',
        'fine_hours',
        'fine_amount',

        'earn_trans_id_01',
        'earn_01',
        'earn_trans_id_02',
        'earn_02',
        'earn_trans_id_03',
        'earn_03',
        'earn_trans_id_04',
        'earn_04',
        'earn_trans_id_05',
        'earn_05',
        'earn_trans_id_06',
        'earn_06',
        'earn_trans_id_07', 
        'earn_07',
        'earn_trans_id_08',
        'earn_08',
        'earn_trans_id_09',
        'earn_09',
        'earn_trans_id_10',
        'earn_10',

        'deduct_trans_id_01',
        'deduct_01',
        'deduct_trans_id_02',
        'deduct_02',
        'deduct_trans_id_03',
        'deduct_03',
        'deduct_trans_id_04',
        'deduct_04',
        'deduct_trans_id_05',
        'deduct_05',
        'deduct_trans_id_06',
        'deduct_06',
        'deduct_trans_id_07',
        'deduct_07',
        'deduct_trans_id_08',
        'deduct_08',
        'deduct_trans_id_09',
        'deduct_09',
        'deduct_trans_id_10',
        'deduct_10',

        'last_adjustment',
        'this_adjustment',
        'gross_salary',
        'total_deduction',
        'net_salary',
        'salary_month',
        'salary_year',

    ];
    protected static $logOnlyDirty = true;
    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->log_name = "hr_salary_data";
        $activity->description = $eventName;
        $activity->causer_id = Auth::user()->id;
    }
}
