<?php

namespace Modules\Hr\Entities;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;
class Team extends Model
{
    protected $table = 'hr_teams';
    protected $primaryKey = 'team_id'; 
    use HasFactory,LogsActivity;
    protected static $logAttributes = [
        'team_id',
        'leader_id',
        'team_name',
        'status',
    ];
    protected static $logOnlyDirty = true;
    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->log_name = "hr_teams";
        $activity->description = $eventName;
        $activity->causer_id = Auth::user()->id;
    }
}
