<?php

namespace Modules\Hr\Entities;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;
class TransactionItemSetup extends Model
{
    protected $table = 'hr_transaction_item_setups';
    protected $primaryKey = 'setup_id'; 
    public $incrementing = false;
    protected $keyType = 'string';
    use HasFactory,LogsActivity;
    protected static $logAttributes = [
        'setup_id',
        'item_id',
        'narration',
        'status',
    ];
    protected static $logOnlyDirty = true;
    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->log_name = "hr_transaction_item_setups";
        $activity->description = $eventName;
        $activity->causer_id = Auth::user()->id;
    }
}
