<?php

namespace Modules\Hr\Http\Controllers;


use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;


use Exception;
use Illuminate\Support\Facades\DB;
use Modules\Hr\Entities\AtdHoliday;
use Modules\Hr\Entities\AtdHolidayType;
use Modules\Hr\Entities\EmployeeSite;

class AtdHolidayController extends Controller
{
    //

    public function allSite()
    {
        try {
            $sites = EmployeeSite::all();
            $responseBody = $this->responseBody(true, "Holiday", "Sites", $sites);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Holiday", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }

    public function allHolidayType()
    {
        try {
            $holidayTypes = AtdHolidayType::all();
            $responseBody = $this->responseBody(true, "Holiday", "Holiday", $holidayTypes);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Holiday", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }





    public function save(Request $request)
    {

        try {
            $remarks = $request->get('txtRemark');
            if(!$remarks){
                $remarks = "";
            }
            $holiday = new AtdHoliday();
            $holiday->holyday_date = $request->get('dteDate');
            $holiday->holyday_type_id = $request->get('selcHolidayType');
            $holiday->site_id = $request->get('selcSite');
            $holiday->remarks = $remarks;
            $save = $holiday->save();
            if ($save) {
                $responseBody = $this->responseBody(true, "Holiday", "saved", null);
            } else {
                $responseBody = $this->responseBody(true, "Holiday", "saved", $save);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Holiday", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }




    public function allHoliday()
    {

        try {
            $holiday = DB::select('SELECT 
            atd_holidays.`id` AS id,
            atd_holiday_types.`holyday_type_id` AS holyday_type_id,
            atd_holiday_types.`holyday_type` AS holyday_type,
            atd_holidays.`holyday_date` AS holyday_date,
            atd_holidays.`remarks` AS remarks
       FROM
            `hr_atd_holiday_types` atd_holiday_types INNER JOIN `hr_atd_holidays` atd_holidays ON atd_holiday_types.`holyday_type_id` = atd_holidays.`holyday_type_id`');

            $responseBody = $this->responseBody(true, "Holiday", "allHoliday", $holiday);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Holiday", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }







    function getHoliday($id)
    {
        try {
            $holiday = AtdHoliday::find($id);
            $responseBody = $this->responseBody(true, "Holiday", "Holiday", $holiday);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Holiday", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }






    function update(Request $request, $id)
    {
        try {
            $holiday = AtdHoliday::find($id);
            $holiday->holyday_date = $request->get('dteDate');
            $holiday->holyday_type_id = $request->get('selcHolidayType');
            $holiday->site_id = $request->get('selcSite');
            $holiday->remarks = $request->get('txtRemark');
            $update = $holiday->save();
            if ($update) {
                $responseBody = $this->responseBody(true, "Holiday", "updated", null);
            } else {
                $responseBody = $this->responseBody(true, "Holiday", "not Updated", null);
            }
            $responseBody = $this->responseBody(true, "Holiday", "updated", null);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Holiday", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }







    public function delete($id)
    {
        try {
            $holiday = AtdHoliday::find($id);
            $delete = $holiday->delete();
            if ($delete) {
                $responseBody = $this->responseBody(true, "Holiday", "deleted", null);
            } else {
                $responseBody = $this->responseBody(false, "Holiday", "not deleted", $delete);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Holiday", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    public function isHoliday($date)
    {
        try {
            $holiday = AtdHoliday::where('holyday_date', '=', $date)->first();
            if ($holiday) {
                $responseBody = $this->responseBody(true, "Holiday", "isHoliday", true);
            } else {
                $responseBody = $this->responseBody(false, "Holiday", "isHoliday", false);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Holiday", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
