<?php

namespace Modules\Hr\Http\Controllers;


use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Modules\Hr\Entities\AttEmployeeLeave;
use Modules\Hr\Entities\AttLeaveType;
use Modules\Hr\Entities\Company;
use Modules\Hr\Entities\Employee;
use Modules\Hr\Entities\EmployeeCategory;
use Modules\Hr\Entities\EmployeeDepartment;
use Modules\Hr\Entities\EmployeeSection;
use Modules\Hr\Entities\EmployeeSite;
use Modules\Hr\Entities\EmployeeSubsection;
use Modules\Hr\Entities\Leave;
use Modules\Hr\Entities\LeaveType;

class AttEmployeeLeaveController extends Controller
{
    //
    public function allSettings()
    {

        try {
            $settings = [
                "leaveType" => $this->leaveType(),
                "category" => $this->category(),
                "site" => $this->site(),
                "section" => $this->section(),
                "department" => $this->department(),
                "company" => $this->company(),
                "employee" => $this->allEmployee(),
            ];
            $responseBody = $this->responseBody(true, "AllSettings", "all", ["settings" => $settings]);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "AllSettings", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }






    public function leaveType()
    {

        try {
            $leaveType = AttLeaveType::all();
            $collection = [];
            for ($i = 0; $i < count($leaveType); $i++) {
                array_push($collection, ["id" => $leaveType[$i]['leave_type_id'], "value" => $leaveType[$i]['leave_type']]);
            }
            return $collection;
        } catch (\Exception $exception) {
            return $exception;
        }
    }




    private function category()
    {

        try {
            $category = EmployeeCategory::all();
            $collection = [];
            for ($i = 0; $i < count($category); $i++) {
                array_push($collection, ["id" => $category[$i]['category_id'], "value" => $category[$i]['category']]);
            }
            return $collection;
        } catch (\Exception $exception) {
            return $exception;
        }
    }


    private function site()
    {

        try {
            $site = EmployeeSite::all();
            $collection = [];
            for ($i = 0; $i < count($site); $i++) {
                array_push($collection, ["id" => $site[$i]['site_id'], "value" => $site[$i]['site']]);
            }
            return $collection;
        } catch (\Exception $exception) {
            return $exception;
        }
    }



    private function department()
    {

        try {
            $section = EmployeeDepartment::all();
            $collection = [];
            for ($i = 0; $i < count($section); $i++) {
                array_push($collection, ["id" => $section[$i]['department_id'], "value" => $section[$i]['department']]);
            }
            return $collection;
        } catch (\Exception $exception) {
            return $exception;
        }
    }


    private function section()
    {

        try {
            $section = EmployeeSection::all();
            $collection = [];
            for ($i = 0; $i < count($section); $i++) {
                array_push($collection, ["id" => $section[$i]['section_id'], "value" => $section[$i]['section']]);
            }
            return $collection;
        } catch (\Exception $exception) {
            return $exception;
        }
    }


    public function subSection($section_id)
    {
        try {
            $subsection = EmployeeSubsection::where('section_id', '=', $section_id)->get();
            $collection = [];
            for ($i = 0; $i < count($subsection); $i++) {
                array_push($collection, ["id" => $subsection[$i]['subsection_id'], "value" => $subsection[$i]['subsection']]);
            }
            $responseBody = $this->responseBody(true, "Subsection", "all", $collection);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Subsection", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    private function company()
    {

        try {
            $section = Company::all();
            $collection = [];
            for ($i = 0; $i < count($section); $i++) {
                array_push($collection, ["id" => $section[$i]['company_id'], "value" => $section[$i]['company']]);
            }
            return $collection;
        } catch (\Exception $exception) {
            return $exception;
        }
    }








    private function allEmployee()
    {
        try {
            $employees = Employee::all();

            $collection = [];
            for ($i = 0; $i < count($employees); $i++) {
                array_push($collection, ["img" => $employees[$i]['photo_parth'], "id" => $employees[$i]['employee_id'], "value" => $employees[$i]['employee_id']]);
            }
            return $collection;
        } catch (\Exception $exception) {
            return $exception;
        }
    }





    public function applyCategory(Request $request)
    {
        try {
            $leave_id = $request->get('leave_id');
            $id = $request->get('id');
            $employeeCategory = $this->employeeCategory($id);

            if (count($employeeCategory) == 0) {
                return;
            }

            $hashMap = [];
            for ($i = 0; $i < count($employeeCategory); $i++) {

                $isLeave =  $this->isAssignedLeaveType($employeeCategory[$i]->employee_id, $leave_id);
                if (!$isLeave) {
                    $status = $this->save($employeeCategory[$i]->employee_id, $leave_id);
                    if (!$status['save']) {
                        $responseBody = $this->responseBody(false, "CategoryLeave", "error", $status['error']);
                        return response()->json(["data" => $responseBody]);
                    }
                }
            }

            $responseBody = $this->responseBody(true, "CategoryLeave", "saved", null);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "CategoryLeave", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }





    public function applySite(Request $request)
    {
        try {
            $leave_id = $request->get('leave_id');
            $id = $request->get('id');
            $employeeSite = $this->employeeSite($id);

            if (count($employeeSite) == 0) {
                return;
            }

            $hashMap = [];
            for ($i = 0; $i < count($employeeSite); $i++) {

                $isLeave =  $this->isAssignedLeaveType($employeeSite[$i]->employee_id, $leave_id);
                if (!$isLeave) {
                    $status = $this->save($employeeSite[$i]->employee_id, $leave_id);
                    if (!$status['save']) {
                        $responseBody = $this->responseBody(false, "siteLeave", "error", $status['error']);
                        return response()->json(["data" => $responseBody]);
                    }
                }
            }

            $responseBody = $this->responseBody(true, "siteLeave", "saved", null);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "siteLeave", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }






    public function applyDepartment(Request $request)
    {
        try {
            $leave_id = $request->get('leave_id');
            $id = $request->get('id');
            $employeeDepartment = $this->employeeDepartment($id);

            if (count($employeeDepartment) == 0) {
                return;
            }

            $hashMap = [];
            for ($i = 0; $i < count($employeeDepartment); $i++) {

                $isLeave =  $this->isAssignedLeaveType($employeeDepartment[$i]->employee_id, $leave_id);
                if (!$isLeave) {
                    $status = $this->save($employeeDepartment[$i]->employee_id, $leave_id);
                    if (!$status['save']) {
                        $responseBody = $this->responseBody(false, "departmentLeave", "error", $status['error']);
                        return response()->json(["data" => $responseBody]);
                    }
                }
            }

            $responseBody = $this->responseBody(true, "departmentLeave", "saved", null);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "departmentLeave", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }




    public function applySection(Request $request)
    {
        try {
            $leave_id = $request->get('leave_id');
            $id = $request->get('id');
            $employeeSection = $this->employeeSection($id);

            if (count($employeeSection) == 0) {
                return;
            }

            $hashMap = [];
            for ($i = 0; $i < count($employeeSection); $i++) {

                $isLeave =  $this->isAssignedLeaveType($employeeSection[$i]->employee_id, $leave_id);
                if (!$isLeave) {
                    $status = $this->save($employeeSection[$i]->employee_id, $leave_id);
                    if (!$status['save']) {
                        $responseBody = $this->responseBody(false, "sectionLeave", "error", $status['error']);
                        return response()->json(["data" => $responseBody]);
                    }
                }
            }

            $responseBody = $this->responseBody(true, "sectionLeave", "saved", null);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "sectionLeave", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }





    public function applySubsection(Request $request)
    {
        try {
            $leave_id = $request->get('leave_id');
            $id = $request->get('id');
            $employeeSubsection = $this->employeeSubsection($id);

            if (count($employeeSubsection) == 0) {
                return;
            }

            $hashMap = [];
            for ($i = 0; $i < count($employeeSubsection); $i++) {

                $isLeave =  $this->isAssignedLeaveType($employeeSubsection[$i]->employee_id, $leave_id);
                if (!$isLeave) {
                    $status = $this->save($employeeSubsection[$i]->employee_id, $leave_id);
                    if (!$status['save']) {
                        $responseBody = $this->responseBody(false, "subSectionAllowance", "error", $status['error']);
                        return response()->json(["data" => $responseBody]);
                    }
                }
            }

            $responseBody = $this->responseBody(true, "subSectionAllowance", "saved", null);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "subSectionAllowance", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }




    public function applyCompany(Request $request)
    {
        try {
            $leave_id = $request->get('leave_id');
            $id = $request->get('id');
            $employeeCompany = $this->employeeCompany($id);

            if (count($employeeCompany) == 0) {
                return;
            }

            $hashMap = [];
            for ($i = 0; $i < count($employeeCompany); $i++) {

                $isLeave =  $this->isAssignedLeaveType($employeeCompany[$i]->employee_id, $leave_id);
                if (!$isLeave) {
                    $status = $this->save($employeeCompany[$i]->employee_id, $leave_id);
                    if (!$status['save']) {
                        $responseBody = $this->responseBody(false, "companyLeave", "error", $status['error']);
                        return response()->json(["data" => $responseBody]);
                    }
                }
            }

            $responseBody = $this->responseBody(true, "companyLeave", "saved", null);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "companyLeave", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }






    public function applyByEmployeeId(Request $request)
    {

        try {
            $leave_id = $request->get('leave_id');
            $employee_id = $request->get('id');
            $isLeave =  $this->isAssignedLeaveType($employee_id, $leave_id);
            if (!$isLeave) {
                $status = $this->save($employee_id, $leave_id);
                if (!$status['save']) {
                    $responseBody = $this->responseBody(false, "employeeLeave", "error", $status['error']);
                    return response()->json(["data" => $responseBody]);
                }
            }

            $responseBody = $this->responseBody(true, "employeeLeave", "saved", null);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "employeeLeave", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }







    public function applyAllEmployee(Request $request)
    {

        try {
            $leave_id = $request->get('leave_id');
            $employees = Employee::all();
            for ($i = 0; $i < count($employees); $i++) {
                $isLeave =  $this->isAssignedLeaveType($employees[$i]->employee_id, $leave_id);
                if (!$isLeave) {
                    $status = $this->save($employees[$i]->employee_id, $leave_id);
                    if (!$status['save']) {
                        $responseBody = $this->responseBody(false, "allEmployeeLeave", "error", $status['error']);
                        return response()->json(["data" => $responseBody]);
                    }
                }
            }

            $responseBody = $this->responseBody(true, "allEmployeeLeave", "saved", null);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "allEmployeeLeave", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }




    public function updateLeaveCount(Request $request)
    {

        try {
            $id = $request->get('id');
            $count = $request->get('count');
            $leave = AttEmployeeLeave::find($id);
            $leave->count = $count;
            $leave->update();

            $responseBody = $this->responseBody(true, "allEmployeeLeave", "saved", null);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "allEmployeeLeave", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }








    private function isAssignedLeaveType($employee, $leave)
    {
        $isLeave = AttEmployeeLeave::where('employee_id', '=', $employee)->where('leave_type_id', '=', $leave)->first();

        if ($isLeave) {
            return true;
        }
        return false;
    }




    private function employeeCategory($id)
    {
        return Employee::where([['category_id', '=', $id], ['employeestatus_id', '!=', '4'], ['employeestatus_id', '!=', '5']])->get();
    }


    private function employeeSite($id)
    {
        return Employee::where([['site_id', '=', $id], ['employeestatus_id', '!=', '4'], ['employeestatus_id', '!=', '5']])->get();
    }


    private function employeeDepartment($id)
    {
        return Employee::where([['department_id', '=', $id], ['employeestatus_id', '!=', '4'], ['employeestatus_id', '!=', '5']])->get();
    }


    private function employeeSection($id)
    {
        return Employee::where([['section_id', '=', $id], ['employeestatus_id', '!=', '4'], ['employeestatus_id', '!=', '5']])->get();
    }


    private function employeeSubsection($id)
    {
        return Employee::where([['subsection_id', '=', $id], ['employeestatus_id', '!=', '4'], ['employeestatus_id', '!=', '5']])->get();
    }



    private function employeeCompany($id)
    {
        return Employee::where([['company_id', '=', $id], ['employeestatus_id', '!=', '4'], ['employeestatus_id', '!=', '5']])->get();
    }



    private function save($employee_id, $leave_id)
    {
        try {
            $employee = Employee::find($employee_id);
            $year = explode('-', $employee->date_join)[0];
            $month = explode('-', $employee->date_join)[1];
            $leave_type = LeaveType::find($leave_id);

            $leave_count = 0;
            if ($leave_type) {
                $leave_count = $leave_type->days_per_year;
            }
            $leave = new AttEmployeeLeave();
            $leave->employee_id = $employee_id;
            $leave->leave_type_id = $leave_id;
            $leave->count = $leave_count;
            $leave->year = $year;
            $leave->month = $month;
            $leave->save();
        } catch (\Exception $exception) {
            return ["save" => false, "error" => $exception];
        }
        return ["save" => true];
    }







    public function employeeLeave(Request $request, $settings)
    {

        try {
            $settings_id = $request->get('settings_id');
            $leave_id = $request->get('leave_type_id');
            $employees = $this->employeeBySettings($settings, $settings_id, $leave_id);
            $responseBody = $this->responseBody(true, "EmployeeLeave", "all", $employees);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "EmployeeLeave", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }





    public function isExcededCount($id, $count)
    {

        try {
            $bool = false;
            $leave = LeaveType::find($id);
            if ($leave) {
                $bool = ($leave->days_per_year < $count);
            }
            $responseBody = $this->responseBody(true, "EmployeeLeave", "isExcededCount", $bool);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "EmployeeLeave", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }







    private function employeeBySettings($settings, $settings_id, $leave_id)
    {
        if ($settings == "category") {
            $column = "employees.`category_id` = '" . $settings_id . "'AND att_leave_types.`leave_type_id` = '" . $leave_id . "'";
        } else if ($settings == "site") {
            $column = "employees.`site_id` = '" . $settings_id . "'AND att_leave_types.`leave_type_id` = '" . $leave_id . "'";
        } else if ($settings == "department") {
            $column = "employees.`department_id` = '" . $settings_id . "'AND att_leave_types.`leave_type_id` = '" . $leave_id . "'";
        } else if ($settings == "section") {
            $column = "employees.`section_id` = '" . $settings_id . "'AND att_leave_types.`leave_type_id` = '" . $leave_id . "'";
        } else if ($settings == "subsection") {
            $column = "employees.`subsection_id` = '" . $settings_id . "'AND att_leave_types.`leave_type_id` = '" . $leave_id . "'";
        } else if ($settings == "company") {
            $column = "employees.`company_id` = '" . $settings_id . "'AND att_leave_types.`leave_type_id` = '" . $leave_id . "'";
        } else if ($settings == "employee") {
            $column = "employees.`employee_id` = '" . $settings_id . "'AND att_leave_types.`leave_type_id` = '" . $leave_id . "'";
        } else if ($settings == "allemployee") {
            $column = "att_leave_types.`leave_type_id` = '" . $leave_id . "'";
        }

        $query = "SELECT
        att_employee_leaves.id,
        employees.`employee_id` AS employee_id,
        employees.`name_withinitial` AS name_withinitial,
        att_leave_types.`leave_type` AS leave_type,
        att_employee_leaves.`count` AS days_per_year,
        att_employee_leaves.`leave_type_id` AS leave_type_id
   FROM
        `hr_att_leave_types` att_leave_types INNER JOIN `hr_att_employee_leaves` att_employee_leaves ON att_leave_types.`leave_type_id` = att_employee_leaves.`leave_type_id`
        INNER JOIN `hr_employees` employees ON att_employee_leaves.`employee_id` = employees.`employee_id` WHERE " . $column;
        return DB::select($query);
        //return $query;
    }






    public function deleteLeave(Request $request)
    {
        $employee_id =  $request->get('employee_id');
        $leave_id =  $request->get('leave_id');
        $delete =  $this->deny($employee_id, $leave_id);
        return response()->json(["data" => $delete]);
    }






    public function removeCategory(Request $request)
    {
        try {
            $id = $request->get('settings_id');
            $leave_id = $request->get('leave_id');
            $employees = $this->employeeCategory($id);

            if (count($employees) == 0) {
                return "empty";
            }


            for ($i = 0; $i < count($employees); $i++) {
                $deny = $this->deny($employees[$i]->employee_id, $leave_id);
                if (!$deny['success']) {
                    return response()->json(["data" => $deny]);
                }
            }

            $responseBody = $this->responseBody(true, "CategoryLeave", "deleted", null);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "CategoryLeave", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }




    public function removeSite(Request $request)
    {
        try {
            $id = $request->get('settings_id');
            $leave_id = $request->get('leave_id');
            $employees = $this->employeeSite($id);

            if (count($employees) == 0) {
                return "empty";
            }


            for ($i = 0; $i < count($employees); $i++) {
                $deny = $this->deny($employees[$i]->employee_id, $leave_id);
                if (!$deny['success']) {
                    return response()->json(["data" => $deny]);
                }
            }

            $responseBody = $this->responseBody(true, "SiteLeave", "deleted", null);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "SiteLeave", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }




    public function removeDepartment(Request $request)
    {
        try {
            $id = $request->get('settings_id');
            $leave_id = $request->get('leave_id');
            $employees = $this->employeeDepartment($id);

            if (count($employees) == 0) {
                return "empty";
            }


            for ($i = 0; $i < count($employees); $i++) {
                $deny = $this->deny($employees[$i]->employee_id, $leave_id);
                if (!$deny['success']) {
                    return response()->json(["data" => $deny]);
                }
            }

            $responseBody = $this->responseBody(true, "DepartmentLeave", "deleted", null);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "DepartmentLeave", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }




    public function removeSection(Request $request)
    {
        try {
            $id = $request->get('settings_id');
            $leave_id = $request->get('leave_id');
            $employees = $this->employeeSection($id);

            if (count($employees) == 0) {
                return "empty";
            }


            for ($i = 0; $i < count($employees); $i++) {
                $deny = $this->deny($employees[$i]->employee_id, $leave_id);
                if (!$deny['success']) {
                    return response()->json(["data" => $deny]);
                }
            }

            $responseBody = $this->responseBody(true, "SectionLeave", "deleted", null);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "SectionLeave", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }




    public function removeSubsection(Request $request)
    {
        try {
            $id = $request->get('settings_id');
            $leave_id = $request->get('leave_id');
            $employees = $this->employeeSubsection($id);

            if (count($employees) == 0) {
                return "empty";
            }


            for ($i = 0; $i < count($employees); $i++) {
                $deny = $this->deny($employees[$i]->employee_id, $leave_id);
                if (!$deny['success']) {
                    return response()->json(["data" => $deny]);
                }
            }

            $responseBody = $this->responseBody(true, "SubsectionLeave", "deleted", null);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "SubsectionLeave", "error", "sampath");
        }
        return response()->json(["data" => $responseBody]);
    }




    public function removeCompany(Request $request)
    {
        try {
            $id = $request->get('settings_id');
            $leave_id = $request->get('leave_id');
            $employees = $this->employeeCompany($id);

            if (count($employees) == 0) {
                return "empty";
            }


            for ($i = 0; $i < count($employees); $i++) {
                $deny = $this->deny($employees[$i]->employee_id, $leave_id);
                if (!$deny['success']) {
                    return response()->json(["data" => $deny]);
                }
            }

            $responseBody = $this->responseBody(true, "CompanyLeave", "deleted", null);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "CompanyLeave", "error", "sampath");
        }
        return response()->json(["data" => $responseBody]);
    }





    public function removeEmployee(Request $request)
    {
        try {
            $employee_id = $request->get('settings_id');
            $leave_id = $request->get('leave_id');

            $deny = $this->deny($employee_id, $leave_id);
            if (!$deny['success']) {
                return response()->json(["data" => $deny]);
            }


            $responseBody = $this->responseBody(true, "EmployeeLeave", "deleted", null);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "EmployeeLeave", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }







    public function removeAllEmployee(Request $request)
    {
        try {
            $leave_id = $request->get('leave_id');
            $leaves =  AttEmployeeLeave::all();
            for ($i = 0; $i < count($leaves); $i++) {
                $deny = $this->deny($leaves[$i]->employee_id, $leave_id);
                if (!$deny['success']) {
                    return response()->json(["data" => $deny]);
                }
            }
            $responseBody = $this->responseBody(true, "EmployeeLeave", "deleted", null);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "EmployeeLeave", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    private function deny($employee_id, $leave_id)
    {

        try {
            $allowance = AttEmployeeLeave::where('employee_id', '=', $employee_id)->where('leave_type_id', '=', $leave_id);
            $delete = $allowance->delete();
            //if ($delete) {
            return $this->responseBody(true, "Leave", "deleted", null);
            //} else {
            //return $this->responseBody(false, "Leave", "error", $delete);
            //}
        } catch (\Exception $exception) {
            return $this->responseBody(false, "Leave", "error", $exception);
        }
    }












    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
