<?php

namespace Modules\Hr\Http\Controllers;


use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Modules\Hr\Entities\AtdHoliday;
use Modules\Hr\Entities\AttSchedule;
use Modules\Hr\Entities\AttShift;
use Modules\Hr\Entities\Employee;

class AttEmployeeScheduleSupervisorController extends Controller
{
    //

    public function allEmployeeId()
    {

        try {
            $employees = Employee::all();

            $employee_arr = [];
            for ($i = 0; $i < count($employees); $i++) {
                array_push($employee_arr, ["img" => $employees[$i]['photo_parth'], "id" => $employees[$i]['employee_id'], "value" => $employees[$i]['employee_id']]);
            }
            $responseBody = $this->responseBody(true, "Employee", "all", $employee_arr);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Employee", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }

    public function allEmployeeName()
    {

        try {
            $employees = Employee::all();

            $employee_arr = [];
            for ($i = 0; $i < count($employees); $i++) {
                array_push($employee_arr, ["img" => $employees[$i]['photo_parth'], "id" => $employees[$i]['employee_id'], "value" => $employees[$i]['name_withinitial']]);
            }
            $responseBody = $this->responseBody(true, "Employee", "all", $employee_arr);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Employee", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }




    public function getEmployeeByID($id)
    {
        try {
            $employee = Employee::find($id);
            $responseBody = $this->responseBody(true, "Employee", "all", $employee);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Employee", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }






    public function allShift()
    {

        try {
            $shift = $this->shift();

            $responseBody = $this->responseBody(true, "AllShift", "all", $shift);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "AllShift", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }




    public function shift()
    {

        try {
            $shift = AttShift::all();
            $collection = [];
            for ($i = 0; $i < count($shift); $i++) {
                array_push($collection, ["id" => $shift[$i]['shift_id'], "value" => $shift[$i]['shift_name']]);
            }
            return $collection;
        } catch (\Exception $exception) {
            return $exception;
        }
    }



    public function getShiftIntimeOutTime($id)
    {

        try {
            $shift = AttShift::find($id);
            $time = $shift->start_time;
            $duration = $shift->duration;
            $array = explode(':', $time);

            $H = 0.0;
            $M = 0.0;
            $S = 0.0;

            if (count($array) == 3) {
                $H = $array[0];
                $M = $array[1];
                $S = $array[2];
            }

            $H = $H + ($M + ($S / 60.0)) / 60.0;
            $H = ($H + $duration);

            $h = floor($H);
            $m = floor(($H - $h) * 60.0);
            $s = ((($H - $h) * 60.0) - $m) * 60.0;

            $outtime = floor($H) . ":" . $m . ":" . $s;
            $shift = ["intime" => $time, "outtime" => $outtime];


            $responseBody = $this->responseBody(true, "Shift", "InTime OutTime", $shift);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Shift", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }







    public function applySchedule(Request $request)
    {

        try {
            ini_set('max_execution_time', '0'); // for infinite time of execution 
            
            $shift_id = $request->get('shift_id');
            $shift = AttShift::find($shift_id);

            $intime = $shift->start_time;
            $H = explode(":", $intime)[0];
            $M = explode(":", $intime)[1];
            $S = explode(":", $intime)[2];
            $time_day1 = $this->getLocalMeanDate_from_Time($H, $M, $S);

            $duration = $shift->duration;
            $DH = floor($duration);
            $DM = floor(($duration - $DH) * 60.0);
            $DS = floor(((($duration - $DH) * 60.0) - $DM) * 60.0);
            $time_day2 = $this->getLocalMeanDate_from_Time($DH, $DM, $DS);


            $fromDate = $request->get('start_date');
            $year = explode("-", $fromDate)[0];
            $month = explode("-", $fromDate)[1];
            $day = explode("-", $fromDate)[2];
            $from_jde = $this->getJulianDay($year, $month, $day);

            $out_jdt = ($from_jde + ($time_day1 + $time_day2));
            $shift_out_date = $this->getLocalDate($out_jdt)['fullDate'];
            $out_time = $this->getLocalMeanTime($out_jdt)['fullTime'];


            $toDate = $request->get('end_date');
            $year_to = explode("-", $toDate)[0];
            $month_to = explode("-", $toDate)[1];
            $day_to = explode("-", $toDate)[2];
            $to_jde = $this->getJulianDay($year_to, $month_to, $day_to);


            $employee_id = $request->get('employee_id');
            $remark = $request->get('remark');
            if ($remark == null) {
                $remark = "";
            }
            $employee = Employee::find($employee_id);

            $day_count =  ($to_jde - $from_jde);




            if ($employee) {
                if ($day_count == 0) {
                    $date = $this->getLocalDate($from_jde)['fullDate'];
                    $isDuplicate = $this->isDuplicateSchedule($employee->employee_id, $date);
                    $isHoliday = $this->isHoliday($date);

                    if (!$isDuplicate && !$isHoliday) {
                        $schedule = new AttSchedule();
                        $schedule->employee_id = $employee->employee_id;
                        $schedule->shift_id = $shift->shift_id;
                        $schedule->schedule_date_from = $date;
                        $schedule->in_time = $date . ' ' . $intime;
                        $schedule->out_time = $shift_out_date . ' ' . $out_time;
                        $schedule->remark = $remark;
                        $schedule->status = 1;
                        $schedule->save();
                    }
                } else if ($day_count > 0) {

                    for ($i = 0; $i <= $day_count; $i++) {
                        $date = $this->getLocalDate(($from_jde + $i))['fullDate'];
                        $isDuplicate = $this->isDuplicateSchedule($employee->employee_id, $date);
                        $isHoliday = $this->isHoliday($date);

                        $out_jdt = (($from_jde + $i) + ($time_day1 + $time_day2));
                        $shift_out_date = $this->getLocalDate($out_jdt)['fullDate'];

                        if (!$isDuplicate && !$isHoliday) {
                            $schedule = new AttSchedule();
                            $schedule->employee_id = $employee->employee_id;
                            $schedule->shift_id = $shift->shift_id;
                            $schedule->schedule_date_from = $date;
                            $schedule->in_time = $date . ' ' . $intime;
                            $schedule->out_time = $shift_out_date . ' ' . $out_time;
                            $schedule->remark = $remark;
                            $schedule->status = 1;
                            $schedule->save();
                        }
                    }
                }
            }

            $responseBody = $this->responseBody(true, "Employee Schedule by supervisor", "all", null);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Employee Schedule by supervisor", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }






    public function updateShift(Request $request, $id)
    {


        try {
            $shift = $request->get('shift');
            $intime = $request->get('intime');
            $outtime = $request->get('outtime');
            $fromDate = $request->get('fromDate');
            $remark = $request->get('remark');
            //$toDate = $request->get('toDate');
            $employee_id = $request->get('employee');


            $schedule = AttSchedule::find($id);
            $schedule->employee_id = $employee_id;
            $schedule->shift_id = $shift;
            $schedule->schedule_date_from = $fromDate;
            $schedule->in_time = $intime;
            $schedule->out_time = $outtime;
            $schedule->remark = $remark;
            $schedule->status = true;
            $schedule->save();


            $responseBody = $this->responseBody(true, "Shift", "updated", null);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Shift", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }







    public function getLocalMeanDate_from_Time($H, $M, $S)
    {

        $Hours = $H + ($M + ($S / 60.0)) / 60.0;
        $Days = $Hours / 24.0;

        return $Days;
    }


    public function getJulianDay($year, $month, $day)
    {

        $jd = 0.0;
        $gregorian = true;
        if ($year < 1582) {
            $gregorian = false;
        } else if ($year == 1582) {
            if (($month < 10) || (($month == 10) && ($day < 15))) {
                $gregorian = false;
            }
        }

        $y = 0.0;
        $m = 0.0;
        if ($month > 2) {
            $y = $year;
            $m = $month;
        } else {
            $y = $year - 1;
            $m = $month + 12;
        }

        $a = floor($y / 100);
        $b = 0.0;

        if ($gregorian) {
            $b = 2 - $a + floor($a / 4);
        } else {
            $b = 0.0;
        }
        $jd = floor(365.25 * ($y + 4716)) + floor(30.6001 * ($m + 1)) + $day + $b - 1524.5;

        return $jd;
    }




    public function getLocalDate($julianDay)
    {


        $jd0 = $julianDay + 0.5;
        $z = floor($jd0);
        $f = $jd0 - $z;

        $a = 0.0;
        $alp = 0.0;
        if ($z < 2299161) {
            $a = $z;
        } else {
            $alp = floor(($z - 1867216.25) / 36524.25);
            $a = $z + 1.0 + $alp - floor($alp / 4.0);
        }

        $b = $a + 1524;
        $c = floor(($b - 122.1) / 365.25);
        $d = floor(365.25 * $c);
        $e = floor(($b - $d) / 30.6001);

        $dayt = $b - $d - floor(30.6001 * $e) + $f;

        $mon = 0;
        if ($e < 13.5) {
            $mon = $e - 1;
        } else {
            $mon = $e - 13;
        }

        $yr = 0;
        if ($mon > 2.5) {
            $yr = $c - 4716;
        } else {
            $yr = $c - 4715;
        }

        $year = (int) floor($yr);
        $month = (int) floor($mon);
        if (strlen($month) == 1)
            $month = '0' . $month;
        $day = (int) floor($dayt);
        if (strlen($day) == 1)
            $day = '0' . $day;


        return ["year" => $year, "month" => $month, "day" => $day, "fullDate" => $year . '-' . $month . '-' . $day];
    }

    public function getLocalMeanTime($julianDayTime)
    {



        $localDate = $this->getLocalDate($julianDayTime);
        $julianDay = $this->getJulianDay($localDate['year'], $localDate['month'], $localDate['day']);

        $time = ($julianDayTime - $julianDay) * 24.0;

        $H = (int) floor($time);
        $M = (int) floor(($time - $H) * 60.0);
        $S = floor(((($time - $H) * 60.0) - $M) * 60.0);

        return ["h" => $H, "m" => $M, "s" => $S, "fullTime" => $H . ":" . $M . ":" . $S];
    }







    





    function isDuplicateSchedule($employee_id, $date)
    {

        $schedule = AttSchedule::where('employee_id', '=', $employee_id)->where('schedule_date_from', '=', $date)->first();
        if ($schedule) {
            return true;
        }
        return false;
    }



    private function is_schedule($employee_id, $date)
    {
        $query = "SELECT
        hr_employees.`employee_id` AS hr_employees_employee_id FROM
        `hr_employees` hr_employees INNER JOIN `hr_att_schedules` hr_att_schedules ON hr_employees.`employee_id` = hr_att_schedules.`employee_id` WHERE hr_employees.`employee_id` = '" . $employee_id . "' AND hr_att_schedules.`schedule_date_from` = '" . $date . "'";

        $employee = DB::select($query);
        if (count($employee) > 0) {
            return true;
        }
        return false;
    }





    function isHoliday($date)
    {

        $holiday = AtdHoliday::where('holyday_date', '=', $date)->first();
        if ($holiday) {
            return true;
        }
        return false;
    }




    public function getAllEmployee(Request $request, $id)
    {
        $date = $request->get('date');

        $query = "SELECT
        hr_employees.`employee_id` AS employee_id,
        hr_employees.`name_withinitial` AS name_withinitial,
        hr_employee_categories.`category` AS category,
        hr_employee_sites.`site` AS site,
        hr_employee_departments.`department` AS department,
        hr_employee_sections.`section` AS section,
        hr_employee_subsections.`subsection` AS subsection
   FROM
        `hr_employee_categories` hr_employee_categories INNER JOIN `hr_employees` hr_employees ON hr_employee_categories.`category_id` = hr_employees.`category_id`
        INNER JOIN `hr_employee_sites` hr_employee_sites ON hr_employees.`site_id` = hr_employee_sites.`site_id`
        INNER JOIN `hr_employee_departments` hr_employee_departments ON hr_employees.`department_id` = hr_employee_departments.`department_id`
        INNER JOIN `hr_employee_sections` hr_employee_sections ON hr_employees.`section_id` = hr_employee_sections.`section_id`
        INNER JOIN `hr_employee_subsections` hr_employee_subsections ON hr_employees.`subsection_id` = hr_employee_subsections.`subsection_id`
        AND hr_employee_sections.`section_id` = hr_employee_subsections.`section_id`
   WHERE
        hr_employees.`supervisor_id` = '" . $id . "'";

        try {
            $employee = DB::select($query);
            $array = [];
            for ($i = 0; $i < count($employee); $i++) {
                $employee_id = $employee[$i]->employee_id;
                $bool = $this->is_schedule($employee_id, $date);
                if (!$bool) {
                    array_push($array, $employee[$i]);
                }
            }
            $responseBody = $this->responseBody(true, "Employee Supervisor", "all", $array);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Employee", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }



    public function getAllEmployeeSchedule($id)
    {

        $date = date('Y-m-d');
        $query = "SELECT
        hr_employees.`employee_id` AS employee_id,
        hr_employees.`name_withinitial` AS name_withinitial,
        hr_att_shifts.`shift_name` AS shift_name,
        hr_att_schedules.`schedule_id` AS schedule_id,
        hr_att_schedules.`shift_id` AS shift_id,
        hr_att_schedules.`schedule_date_from` AS schedule_date_from,
        hr_att_schedules.`in_time` AS in_time,
        hr_att_schedules.`out_time` AS out_time
   FROM
        `hr_employees` hr_employees INNER JOIN `hr_att_schedules` hr_att_schedules ON hr_employees.`employee_id` = hr_att_schedules.`employee_id`
        INNER JOIN `hr_att_shifts` hr_att_shifts ON hr_att_schedules.`shift_id` = hr_att_shifts.`shift_id` WHERE hr_employees.supervisor_id = '" . $id . "'  AND hr_att_schedules.`schedule_date_from` = '" . $date . "'";

        try {
            $employee = DB::select($query);
            $responseBody = $this->responseBody(true, "Employee Category", "all", $employee);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Employee", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }





    public function removeShift($id)
    {

        try {
            $schedule =  AttSchedule::find($id);
            if ($schedule) {
                $schedule->delete();
            }
            $responseBody = $this->responseBody(true, "Shift", "remove", null);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Shift", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }







    public function getEmployeeShift(Request $request, $id)
    {
        try {
            $shift = AttSchedule::where('employee_id', '=', $id)->where('schedule_date_from', '=', $request->get('date'))->first();
            $responseBody = $this->responseBody(true, "Shift", "shift", $shift);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Shift", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }




    public function serverDate()
    {
        return date('Y-m-d');
    }




    public function getSupervisorSchedule($id)
    {

        try {
            $query = "SELECT DISTINCT
            hr_att_shifts.`shift_name` AS shift_name,
            hr_att_schedules.`shift_id` AS shift_id,
            hr_att_schedules.`schedule_date_from` AS schedule_date_from
       FROM
            `hr_employees` hr_employees INNER JOIN `hr_att_schedules` hr_att_schedules ON hr_employees.`employee_id` = hr_att_schedules.`employee_id`
            INNER JOIN `hr_att_shifts` hr_att_shifts ON hr_att_schedules.`shift_id` = hr_att_shifts.`shift_id` where hr_employees.supervisor_id = '" . $id . "'";

            $employees = DB::select($query);
            $responseBody = $this->responseBody(true, "SupervisorSchedul", "all", $employees);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "SupervisorSchedul", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }





    public function getSupervisorDateRange(Request $request, $id)
    {

        try {
            $start = $request->get('start');
            $end = $request->get('end');

            $employees = DB::select("SELECT DISTINCT
            hr_att_shifts.`shift_name` AS shift_name,
            hr_att_schedules.`shift_id` AS shift_id,
            hr_att_schedules.`schedule_date_from` AS schedule_date_from
       FROM
            `hr_employees` hr_employees INNER JOIN `hr_att_schedules` hr_att_schedules ON hr_employees.`employee_id` = hr_att_schedules.`employee_id`
            INNER JOIN `hr_att_shifts` hr_att_shifts ON hr_att_schedules.`shift_id` = hr_att_shifts.`shift_id`  where hr_employees.supervisor_id = '" . $id . "' AND hr_att_schedules.`schedule_date_from` BETWEEN '" . $start . "' AND '" . $end . "' ORDER BY schedule_date_from");
            $responseBody = $this->responseBody(true, "TeamSchedul", "all", $employees);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "TeamSchedul", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }









    public function getEmplyeeHolidays()
    {

        try {
            $holidays = DB::select("SELECT
            hr_atd_holiday_types.`holyday_type_id` AS holyday_type_id,
            hr_atd_holidays.`holyday_date` AS holyday_date,
            hr_atd_holiday_types.`holyday_type` AS holyday_type
       FROM
            `hr_atd_holiday_types` hr_atd_holiday_types INNER JOIN `hr_atd_holidays` hr_atd_holidays ON hr_atd_holiday_types.`holyday_type_id` = hr_atd_holidays.`holyday_type_id`");
            $responseBody = $this->responseBody(true, "Holidays", "all", $holidays);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Holidays", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }



    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
