<?php

namespace Modules\Hr\Http\Controllers;


use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Modules\Hr\Entities\Company;
use Modules\Hr\Entities\EmployeeCategory;
use Modules\Hr\Entities\EmployeeDepartment;
use Modules\Hr\Entities\EmployeeSection;
use Modules\Hr\Entities\EmployeeSite;
use Modules\Hr\Entities\EmployeeSubsection;

class ReportEmployeeListController extends Controller
{
    //
    public function allSettings()
    {

        try {
            $settings = [
                "category" => $this->category(),
                "site" => $this->site(),
                "section" => $this->section(),
                "department" => $this->department(),
                "company" => $this->company(),
            ];
            $responseBody = $this->responseBody(true, "AllSettings", "all", ["settings" => $settings]);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "AllSettings", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }





    private function category()
    {

        try {
            $category = EmployeeCategory::all();
            $collection = [];
            for ($i = 0; $i < count($category); $i++) {
                array_push($collection, ["id" => $category[$i]['category_id'], "value" => $category[$i]['category']]);
            }
            return $collection;
        } catch (\Exception $exception) {
            return $exception;
        }
    }


    private function site()
    {

        try {
            $site = EmployeeSite::all();
            $collection = [];
            for ($i = 0; $i < count($site); $i++) {
                array_push($collection, ["id" => $site[$i]['site_id'], "value" => $site[$i]['site']]);
            }
            return $collection;
        } catch (\Exception $exception) {
            return $exception;
        }
    }



    private function department()
    {

        try {
            $section = EmployeeDepartment::all();
            $collection = [];
            for ($i = 0; $i < count($section); $i++) {
                array_push($collection, ["id" => $section[$i]['department_id'], "value" => $section[$i]['department']]);
            }
            return $collection;
        } catch (\Exception $exception) {
            return $exception;
        }
    }


    private function section()
    {

        try {
            $section = EmployeeSection::all();
            $collection = [];
            for ($i = 0; $i < count($section); $i++) {
                array_push($collection, ["id" => $section[$i]['section_id'], "value" => $section[$i]['section']]);
            }
            return $collection;
        } catch (\Exception $exception) {
            return $exception;
        }
    }


    public function subSection($section_id)
    {
        try {
            $subsection = EmployeeSubsection::where('section_id', '=', $section_id)->get();
            $collection = [];
            for ($i = 0; $i < count($subsection); $i++) {
                array_push($collection, ["id" => $subsection[$i]['subsection_id'], "value" => $subsection[$i]['subsection']]);
            }
            $responseBody = $this->responseBody(true, "Subsection", "all", $collection);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Subsection", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    private function company()
    {

        try {
            $section = Company::all();
            $collection = [];
            for ($i = 0; $i < count($section); $i++) {
                array_push($collection, ["id" => $section[$i]['company_id'], "value" => $section[$i]['company']]);
            }
            return $collection;
        } catch (\Exception $exception) {
            return $exception;
        }
    }






    /**
     * search
     * This function is used to get all saved salary sheet from settings.
     */
    public function search(Request $request)
    {

        try {

            $is_category = $request->get('is_category');
            $category = $request->get('category');

            $is_site = $request->get('is_site');
            $site = $request->get('site');

            $is_department = $request->get('is_department');
            $department = $request->get('department');

            $is_section = $request->get('is_section');
            $section = $request->get('section');

            $is_subsection = $request->get('is_subsection');
            $subsection = $request->get('subsection');

            $is_company = $request->get('is_company');
            $company = $request->get('company');


            $query = "SELECT
            hr_employees.`employee_id` AS employee_id,
            hr_employees.`name_withinitial` AS name_withinitial,
            hr_employees.`name_full` AS name_full,
            hr_employees.`address` AS address,
            hr_employees.`nic` AS nic,
            hr_employees.`passport` AS passport,
            hr_employees.`drvl` AS drvl,
            hr_employees.`birthday` AS birthday,
            hr_employees.`date_join` AS date_join,
            hr_employees.`id_issue_date` AS issue_date,
            hr_employees.`id_expire_date` AS expire_date,
            hr_employees.`gender_id` AS gender_id,
            hr_employees.`bank_account` AS bank_account,
            hr_employees.`email` AS email,
            hr_employees.`mobile` AS mobile,
            hr_employees.`fixed` AS fixed,
            hr_employees.`gmap` AS gmap,
            hr_employees.`emegency_contact` AS emegency_contact,
            hr_employees.`emegency_contactno1` AS emegency_contactno1,
            hr_employees.`emegency_contactno2` AS emegency_contactno2,
            hr_employees.`attendance_id` AS attendance_id,
            hr_employees.`epf_no` AS epf_no,
            hr_employees.`contract` AS contract,
            hr_employee_categories.`category` AS category,
            hr_employee_sections.`section` AS section,
            hr_employee_sites.`site` AS site,
            hr_employee_subsections.`subsection` AS subsection,
            hr_employee_departments.`department` AS department,
            hr_towns.`town` AS town,
            hr_employee_designations.`designation` AS designation,
            hr_employee_civilstatuses.`civilstatus` AS civilstatus,
            hr_employee_statuses.`employeestatus` AS employeestatus,
            hr_employees.`supervisor_id` AS supervisor_id
       FROM
            `hr_employee_categories` hr_employee_categories INNER JOIN `hr_employees` hr_employees ON hr_employee_categories.`category_id` = hr_employees.`category_id`
            INNER JOIN `hr_employee_sections` hr_employee_sections ON hr_employees.`section_id` = hr_employee_sections.`section_id`
            INNER JOIN `hr_employee_sites` hr_employee_sites ON hr_employees.`site_id` = hr_employee_sites.`site_id`
            INNER JOIN `hr_employee_subsections` hr_employee_subsections ON hr_employees.`subsection_id` = hr_employee_subsections.`subsection_id`
            INNER JOIN `hr_employee_departments` hr_employee_departments ON hr_employees.`department_id` = hr_employee_departments.`department_id`
            INNER JOIN `hr_towns` hr_towns ON hr_employees.`town_id` = hr_towns.`town_id`
            INNER JOIN `hr_employee_designations` hr_employee_designations ON hr_employees.`designation_id` = hr_employee_designations.`designation_id`
            INNER JOIN `hr_employee_civilstatuses` hr_employee_civilstatuses ON hr_employees.`civilstatus_id` = hr_employee_civilstatuses.`civilstatus_id`
            INNER JOIN `hr_employee_statuses` hr_employee_statuses ON hr_employees.`employeestatus_id` = hr_employee_statuses.`employeestatus_id`
            AND hr_employee_sections.`section_id` = hr_employee_subsections.`section_id` WHERE";


            if ($is_category == 'true') {
                $query .= " hr_employees.category_id = '" . $category . "' ";
            }
            if ($is_site == 'true') {

                $pieces = explode(' ', $query);
                if (array_pop($pieces) == "WHERE") {
                    $query .= " hr_employees.site_id = '" . $site . "' ";
                } else {
                    $query .= " OR hr_employees.site_id = '" . $site . "' ";
                }
            }
            if ($is_department == 'true') {

                $pieces = explode(' ', $query);
                if (array_pop($pieces) == "WHERE") {
                    $query .= " hr_employees.department_id = '" . $department . "' ";
                } else {
                    $query .= " OR hr_employees.department_id = '" . $department . "' ";
                }
            }
            if ($is_section == 'true') {

                $pieces = explode(' ', $query);
                if (array_pop($pieces) == "WHERE") {
                    $query .= " hr_employees.section_id = '" . $section . "' ";
                } else {
                    $query .= " OR hr_employees.section_id = '" . $section . "' ";
                }
            }
            if ($is_subsection == 'true') {

                $pieces = explode(' ', $query);
                if (array_pop($pieces) == "WHERE") {
                    $query .= " hr_employees.subsection_id = '" . $subsection . "' ";
                } else {
                    $query .= " OR hr_employees.subsection_id = '" . $subsection . "' ";
                }
            }
            if ($is_company == 'true') {

                $pieces = explode(' ', $query);
                if (array_pop($pieces) == "WHERE") {
                    $query .= " hr_employees.company_id = '" . $company . "' ";
                } else {
                    $query .= " OR hr_employees.company_id = '" . $company . "' ";
                }
            }

            $employees = DB::select($query);
            $responseBody = $this->responseBody(true, "EmployeeSearch", "all", $employees);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "EmployeeSearch", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }




    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
