<?php

namespace Modules\Hr\Http\Controllers;


use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Modules\Hr\Entities\EmployeeCategory;
use Modules\Hr\Entities\EmployeeCivilstatus;
use Modules\Hr\Entities\EmployeeDepartment;
use Modules\Hr\Entities\EmployeeDesignation;
use Modules\Hr\Entities\EmployeeSection;
use Modules\Hr\Entities\EmployeeSite;
use Modules\Hr\Entities\EmployeeStatus;
use Modules\Hr\Entities\EmployeeSubsection;
use Modules\Hr\Entities\EmployeeType;
use Modules\Hr\Entities\GsDivision;
use Modules\Hr\Entities\MohDivision;
use Modules\Hr\Entities\Police;
use Modules\Hr\Entities\Team;
use Modules\Hr\Entities\Town;

class SettingsController extends Controller
{


    /**
     * saveTown
     * This function is used to save new town to database.
     * @param request This is the paramter to saveTown function
     * @return Json This returns as response.
     */
    public function saveTown(Request $request)
    {

        try {
            $value = $request->get('value');
            $object = new Town();
            $object->town = $value;
            $object->status = true;
            $save = $object->save();

            if ($save) {
                $responseBody = $this->responseBody(true, "Town", "saved", null);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Town", $exception, null);
        }
        return response()->json(["data" => $responseBody]);
    }


    /**
     * saveCivilStatus
     * This function is used to save new civilstatus to database.
     * @param request This is the paramter to saveCivilStatus function
     * @return Json This returns as response.
     */
    public function saveCivilStatus(Request $request)
    {
        try {
            $value = $request->get('value');
            $object = new EmployeeCivilstatus();
            $object->civilstatus = $value;
            $object->status = true;
            $save = $object->save();

            if ($save) {
                $result = $this->allSettings('CivilStatus');
                $responseBody = $this->responseBody(true, "CivilStatus", "saved", null);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "CivilStatus", "error", null);
        }
        return response()->json(["data" => $responseBody]);
    }


    /**
     * saveDesignation
     * This function is used to save new designation to database.
     * @param request This is the paramter to saveDesignation function
     * @return Json This returns as response.
     */
    public function saveDesignation(Request $request)
    {
        try {
            $value = $request->get('designation');
            $value_sinhala = $request->get('designation_sinhala');
            $object = new EmployeeDesignation();
            $object->designation = $value;
            $object->designation_sinhala = $value_sinhala;
            $object->status = true;
            $save = $object->save();

            if ($save) {
                $responseBody = $this->responseBody(true, "Designation", "saved", null);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Designation", "error", null);
        }
        return response()->json(["data" => $responseBody]);
    }

    /**
     * saveEmployeeType
     * This function is used to save new employee type to database.
     * @param request This is the paramter to saveEmployeeType function
     * @return Json This returns as response.
     */
    public function saveEmployeeType(Request $request)
    {
        try {
            $value = $request->get('value');
            $object = new EmployeeType();
            $object->employeetype = $value;
            $object->status = true;
            $save = $object->save();

            if ($save) {
                $responseBody = $this->responseBody(true, "EmployeeType", "saved", null);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "EmployeeType", "error", null);
        }
        return response()->json(["data" => $responseBody]);
    }


    /**
     * saveEmployeeStatus
     * This function is used to save new employee status to database.
     * @param request This is the paramter to saveEmployeeStatus function
     * @return Json This returns as response.
     */
    public function saveEmployeeStatus(Request $request)
    {
        try {
            $value = $request->get('value');
            $object = new EmployeeStatus();
            $object->employeestatus = $value;
            $object->status = true;
            $save = $object->save();

            if ($save) {
                $responseBody = $this->responseBody(true, "EmployeeStatus", "saved", null);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "EmployeeStatus", "error", null);
        }
        return response()->json(["data" => $responseBody]);
    }


    /**
     * saveCategory
     * This function is used to save new category to database.
     * @param request This is the paramter to saveCategory function
     * @return Json This returns as response.
     */
    public function saveCategory(Request $request)
    {
        try {
            $value = $request->get('value');
            $object = new EmployeeCategory();
            $object->category = $value;
            $object->status = true;
            $save = $object->save();

            if ($save) {
                $responseBody = $this->responseBody(true, "Category", "saved", null);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Category", "error", null);
        }
        return response()->json(["data" => $responseBody]);
    }


    /**
     * saveSite
     * This function is used to save new site to database.
     * @param request This is the paramter to saveSite function
     * @return Json This returns as response.
     */
    public function saveSite(Request $request)
    {
        try {
            $value = $request->get('value');
            $object = new EmployeeSite();
            $object->site = $value;
            $object->status = true;
            $save = $object->save();

            if ($save) {
                $responseBody = $this->responseBody(true, "Site", "saved", null);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Site", "error", null);
        }
        return response()->json(["data" => $responseBody]);
    }

    /**
     * saveDepartment
     * This function is used to save new department to database.
     * @param request This is the paramter to saveDepartment function
     * @return Json This returns as response.
     */
    public function saveDepartment(Request $request)
    {
        try {
            $value = $request->get('value');
            $object = new EmployeeDepartment();
            $object->department = $value;
            $object->status = true;
            $save = $object->save();

            if ($save) {
                $responseBody = $this->responseBody(true, "Department", "saved", null);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Department", "error", null);
        }
        return response()->json(["data" => $responseBody]);
    }


    /**
     * saveSection
     * This function is used to save new section to database.
     * @param request This is the paramter to saveSection function
     * @return Json This returns as response.
     */
    public function saveSection(Request $request)
    {
        try {
            $value = $request->get('value');
            $object = new EmployeeSection();
            $object->section = $value;
            $object->status = true;
            $save = $object->save();

            if ($save) {
                $responseBody = $this->responseBody(true, "Section", "saved", null);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Section", "error", null);
        }
        return response()->json(["data" => $responseBody]);
    }


    /**
     * saveSubsection
     * This function is used to save new subsection to database.
     * @param request This is the paramter to saveSubsection function
     * @return Json This returns as response.
     */
    public function saveSubsection(Request $request)
    {
        try {
            $section_id = $request->get('section_id');
            $value = $request->get('value');
            $object = new EmployeeSubsection();
            $object->subsection = $value;
            $object->section_id = $section_id;
            $object->status = true;
            $save = $object->save();

            if ($save) {
                $responseBody = $this->responseBody(true, "SubSection", "saved", null);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "SubSection", "error", null);
        }
        return response()->json(["data" => $responseBody]);
    }

    /**
     * saveMhoDivision
     * This function is used to save new mho division to database.
     * @param request This is the paramter to saveMhoDivision function
     * @return Json This returns as response.
     */
    public function saveMohDivision(Request $request)
    {
        try {
            $moh_division = $request->get('moh_division');
            $moh_mobile = $request->get('moh_mobile');
            $office_phone = $request->get('office_phone');
            $contact_person = $request->get('contact_person');

            if ($moh_mobile == NULL) {
                $moh_mobile = '';
            }

            if ($office_phone == NULL) {
                $office_phone = '';
            }

            if ($contact_person == NULL) {
                $contact_person = '';
            }

            $object = new MohDivision();
            $object->moh_division = $moh_division;
            $object->moh_mobile = $moh_mobile;
            $object->office_phone = $office_phone;
            $object->contact_person = $contact_person;
            $object->status = true;
            $save = $object->save();

            if ($save) {
                $responseBody = $this->responseBody(true, "MohDivision", "saved", null);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "MohDivision", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }


    /**
     * savePolice
     * This function is used to save new police to database.
     * @param request This is the paramter to savePolice function
     * @return Json This returns as response.
     */
    public function savePolice(Request $request)
    {
        try {
            $police_station = $request->get('police_station');
            $oic_mobile = $request->get('oic_mobile');
            $office_phone = $request->get('office_phone');
            $contact_person = $request->get('contact_person');

            if ($oic_mobile == NULL) {
                $oic_mobile = '';
            }

            if ($office_phone == NULL) {
                $office_phone = '';
            }

            if ($contact_person == NULL) {
                $contact_person = '';
            }

            $object = new Police();
            $object->police_station = $police_station;
            $object->oic_mobile = $oic_mobile;
            $object->office_phone = $office_phone;
            $object->contact_person = $contact_person;
            $object->status = true;
            $save = $object->save();

            if ($save) {
                $responseBody = $this->responseBody(true, "Police", "saved", null);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Police", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }


    /**
     * saveGsDivision
     * This function is used to save gs division to database.
     * @param request This is the paramter to saveGsDivision function
     * @return Json This returns as response.
     */
    public function saveGsDivision(Request $request)
    {
        try {
            $gs_division = $request->get('gs_division');
            $gs_mobile = $request->get('gs_mobile');
            $office_phone = $request->get('office_phone');
            $contact_person = $request->get('contact_person');

            if ($gs_mobile == NULL) {
                $gs_mobile = '';
            }

            if ($office_phone == NULL) {
                $office_phone = '';
            }

            if ($contact_person == NULL) {
                $contact_person = '';
            }

            $object = new GsDivision();
            $object->gs_division = $gs_division;
            $object->gs_mobile = $gs_mobile;
            $object->office_phone = $office_phone;
            $object->contact_person = $contact_person;
            $object->status = true;
            $save = $object->save();

            if ($save) {
                $responseBody = $this->responseBody(true, "GsDivision", "saved", null);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "GsDivision", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }


    /**
     * allTown
     * This function is used to search all town records from the database.
     * @return Json This returns as response.
     */
    public function allTown()
    {
        try {
            $result = SettingsController::allSettings('Town');
            $responseBody = $this->responseBody(true, "Town", "all", $result);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Town", "error", null);
        }
        return response()->json(["data" => $responseBody]);
    }


    /**
     * allCivilStatus
     * This function is used to search all civilstatus records from the database.
     * @return Json This returns as response.
     */
    public function allCivilStatus()
    {
        try {
            $result = SettingsController::allSettings('CivilStatus');
            $responseBody = $this->responseBody(true, "CivilStatus", "all", $result);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "CivilStatus", "error", null);
        }
        return response()->json(["data" => $responseBody]);
    }


    /**
     * allDesignation
     * This function is used to search all designation records from the database.
     * @return Json This returns as response.
     */
    public function allDesignation()
    {
        try {
            $result = SettingsController::allSettings('Designation');
            $responseBody = $this->responseBody(true, "Designation", "all", $result);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Designation", "error", null);
        }
        return response()->json(["data" => $responseBody]);
    }


    /**
     * allEmployeeType
     * This function is used to search all employee type records from the database.
     * @return Json This returns as response.
     */
    public function allEmployeeType()
    {
        try {
            $result = SettingsController::allSettings('EmployeeType');
            $responseBody = $this->responseBody(true, "EmployeeType", "all", $result);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "EmployeeType", "error", null);
        }
        return response()->json(["data" => $responseBody]);
    }


    /**
     * allEmployeeStatus
     * This function is used to search all employee status records from the database.
     * @return Json This returns as response.
     */
    public function allEmployeeStatus()
    {
        try {
            $result = SettingsController::allSettings('EmployeeStatus');
            $responseBody = $this->responseBody(true, "EmployeeStatus", "all", $result);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "EmployeeStatus", "error", null);
        }
        return response()->json(["data" => $responseBody]);
    }


    /**
     * allCategory
     * This function is used to search all catergory records from the database.
     * @return Json This returns as response.
     */
    public function allCategory()
    {
        try {
            $result = SettingsController::allSettings('Category');
            $responseBody = $this->responseBody(true, "Category", "all", $result);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Category", "error", null);
        }
        return response()->json(["data" => $responseBody]);
    }


    /**
     * allSite
     * This function is used to search all site records from the database.
     * @return Json This returns as response.
     */
    public function allSite()
    {
        try {
            $result = SettingsController::allSettings('Site');
            $responseBody = $this->responseBody(true, "Site", "all", $result);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Site", "error", null);
        }
        return response()->json(["data" => $responseBody]);
    }


    /**
     * allDepartment
     * This function is used to search all department records from the database.
     * @return Json This returns as response.
     */
    public function allDepartment()
    {
        try {
            $result = SettingsController::allSettings('Department');
            $responseBody = $this->responseBody(true, "Department", "all", $result);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Department", "error", null);
        }
        return response()->json(["data" => $responseBody]);
    }


    /**
     * allSection
     * This function is used to search all section records from the database.
     * @return Json This returns as response.
     */
    public function allSection()
    {
        try {
            $result = SettingsController::allSettings('Section');
            $responseBody = $this->responseBody(true, "Section", "all", $result);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Section", "error", null);
        }
        return response()->json(["data" => $responseBody]);
    }


    /**
     * allSubsection
     * This function is used to search all subsection records from the database.
     * @return Json This returns as response.
     */
    public function allSubsection()
    {
        try {
            $result = SettingsController::allSettings('SubSection');
            $responseBody = $this->responseBody(true, "SubSection", "all", $result);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "SubSection", "error", null);
        }
        return response()->json(["data" => $responseBody]);
    }


    /**
     * allMohDivision
     * This function is used to search all mohdivision records from the database.
     * @return Json This returns as response.
     */
    public function allMohDivision()
    {
        try {
            $result = SettingsController::allSettings('MohDivision');
            $responseBody = $this->responseBody(true, "MohDivision", "all", $result);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "MohDivision", "error", null);
        }
        return response()->json(["data" => $responseBody]);
    }



    /**
     * allPolice
     * This function is used to search all police records from the database.
     * @return Json This returns as response.
     */
    public function allPolice()
    {
        try {
            $result = SettingsController::allSettings('Police');
            $responseBody = $this->responseBody(true, "Police", "all", $result);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Police", "error", null);
        }
        return response()->json(["data" => $responseBody]);
    }

    /**
     * allGsDivision
     * This function is used to search all gsdivision records from the database.
     * @return Json This returns as response.
     */
    public function allGsDivision()
    {
        try {
            $result = SettingsController::allSettings('GsDivision');
            $responseBody = $this->responseBody(true, "GsDivision", "all", $result);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "GsDivision", "error", null);
        }
        return response()->json(["data" => $responseBody]);
    }


    /**
     * updateTown
     * This function is used to update town records.
     * @param request This is the paramter to updateTown function
     * @return Json This returns as response.
     */
    public function updateTown(Request $request, $id)
    {


        try {
            $value = $request->get('Town');

            $object = Town::find($id);
            $object->town = $value;
            $update = $object->save();
            if ($update) {
                $responseBody = $this->responseBody(true, "Town", "updated", null);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Town", "error", null);
        }
        return response()->json(["data" => $responseBody]);
    }


    /**
     * updateCivilStatus
     * This function is used to update civilstatus records.
     * @param request This is the paramter to updateCivilStatus function
     * @return Json This returns as response.
     */
    public function updateCivilStatus(Request $request, $id)
    {

        try {
            $value = $request->get('CivilStatus');

            $object = EmployeeCivilstatus::find($id);
            $object->civilstatus = $value;
            $update = $object->save();
            if ($update) {
                $responseBody = $this->responseBody(true, "CivilStatus", "updated", null);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "CivilStatus", "error", null);
        }
        return response()->json(["data" => $responseBody]);
    }


    /**
     * updateDesignation
     * This function is used to update designation records.
     * @param request This is the paramter to updateDesignation function
     * @return Json This returns as response.
     */
    public function updateDesignation(Request $request, $id)
    {

        try {
            $value = $request->get('Designation');
            $value_sinhala = $request->get('designationSinhala');
            $object = EmployeeDesignation::find($id);
            $object->designation = $value;
            $object->designation_sinhala = $value_sinhala;
            $update = $object->save();
            if ($update) {
                $responseBody = $this->responseBody(true, "Designation", "updated", null);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Designation", "error", null);
        }
        return response()->json(["data" => $responseBody]);
    }


    /**
     * updateEmployeeType
     * This function is used to update employee type records.
     * @param request This is the paramter to updateEmployeeType function
     * @return Json This returns as response.
     */
    public function updateEmployeeType(Request $request, $id)
    {

        try {
            $value = $request->get('EmployeeType');

            $object = EmployeeType::find($id);
            $object->employeetype = $value;
            $update = $object->save();
            if ($update) {
                $responseBody = $this->responseBody(true, "EmployeeType", "updated", null);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "EmployeeType", "error", null);
        }
        return response()->json(["data" => $responseBody]);
    }


    /**
     * updateEmployeeStatus
     * This function is used to update employee status records.
     * @param request This is the paramter to updateEmployeeStatus function
     * @return Json This returns as response.
     */
    public function updateEmployeeStatus(Request $request, $id)
    {

        try {
            $value = $request->get('EmployeeStatus');

            $object = EmployeeStatus::find($id);
            $object->employeestatus = $value;
            $update = $object->save();
            if ($update) {
                $responseBody = $this->responseBody(true, "EmployeeStatus", "updated", null);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "EmployeeStatus", "error", null);
        }
        return response()->json(["data" => $responseBody]);
    }


    /**
     * updateCategory
     * This function is used to update category records.
     * @param request This is the paramter to updateCategory function
     * @return Json This returns as response.
     */
    public function updateCategory(Request $request, $id)
    {

        try {
            $value = $request->get('Category');

            $object = EmployeeCategory::find($id);
            $object->category = $value;
            $update = $object->save();
            if ($update) {
                $responseBody = $this->responseBody(true, "Category", "updated", null);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Category", "error", null);
        }
        return response()->json(["data" => $responseBody]);
    }



    /**
     * updateSite
     * This function is used to update site records.
     * @param request This is the paramter to updateSite function
     * @return Json This returns as response.
     */
    public function updateSite(Request $request, $id)
    {

        try {
            $value = $request->get('Site');

            $object = EmployeeSite::find($id);
            $object->site = $value;
            $update = $object->save();
            if ($update) {
                $responseBody = $this->responseBody(true, "Site", "updated", null);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Site", "error", null);
        }
        return response()->json(["data" => $responseBody]);
    }


    /**
     * updateDepartment
     * This function is used to update department records.
     * @param request This is the paramter to updateDepartment function
     * @return Json This returns as response.
     */
    public function updateDepartment(Request $request, $id)
    {

        try {
            $value = $request->get('Department');

            $object = EmployeeDepartment::find($id);
            $object->department = $value;
            $update = $object->save();
            if ($update) {
                $responseBody = $this->responseBody(true, "Department", "updated", null);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Department", "error", null);
        }
        return response()->json(["data" => $responseBody]);
    }


    /**
     * updateSection
     * This function is used to update section records.
     * @param request This is the paramter to updateSection function
     * @return Json This returns as response.
     */
    public function updateSection(Request $request, $id)
    {

        try {
            $value = $request->get('Section');

            $object = EmployeeSection::find($id);
            $object->section = $value;
            $update = $object->save();
            if ($update) {
                $responseBody = $this->responseBody(true, "Section", "updated", null);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Section", "error", null);
        }
        return response()->json(["data" => $responseBody]);
    }


    /**
     * updateSubsection
     * This function is used to update subsection records.
     * @param request This is the paramter to updateSubsection function
     * @return Json This returns as response.
     */
    public function updateSubsection(Request $request, $id)
    {

        try {
            $section_id = $request->get('selcSection');
            $value = $request->get('SubSection');

            $object = EmployeeSubSection::find($id);
            $object->subsection = $value;
            $object->section_id = $section_id;
            $update = $object->save();
            if ($update) {
                $responseBody = $this->responseBody(true, "SubSection", "updated", null);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "SubSection", "error", null);
        }
        return response()->json(["data" => $responseBody]);
    }


    /**
     * updateMohDivision
     * This function is used to update moh division records.
     * @param request This is the paramter to updateMohDivision function
     * @return Json This returns as response.
     */
    public function updateMohDivision(Request $request, $id)
    {

        try {
            $moh_division = $request->get('MohDivision');
            $moh_mobile = $request->get('txtMohMobile');
            $office_phone = $request->get('txtMohOfficePhone');
            $contact_person = $request->get('txtMohContactPerson');

            if ($moh_mobile == NULL) {
                $moh_mobile = '';
            }

            if ($office_phone == NULL) {
                $office_phone = '';
            }

            if ($contact_person == NULL) {
                $contact_person = '';
            }

            $object = MohDivision::find($id);
            $object->moh_division = $moh_division;
            $object->moh_mobile = $moh_mobile;
            $object->office_phone = $office_phone;
            $object->contact_person = $contact_person;
            $update = $object->save();
            if ($update) {
                $responseBody = $this->responseBody(true, "MohDivision", "updated", null);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "MohDivision", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    /**
     * updatePolice
     * This function is used to update police records.
     * @param request This is the paramter to updatePolice function
     * @return Json This returns as response.
     */
    public function updatePolice(Request $request, $id)
    {

        try {
            $police_station = $request->get('Police');
            $oic_mobile = $request->get('txtOicMobil');
            $office_phone = $request->get('txtPoliceOfficePhone');
            $contact_person = $request->get('txtPoliceContactPerson');

            if ($oic_mobile == NULL) {
                $oic_mobile = '';
            }

            if ($office_phone == NULL) {
                $office_phone = '';
            }

            if ($contact_person == NULL) {
                $contact_person = '';
            }

            $object = Police::find($id);
            $object->police_station = $police_station;
            $object->oic_mobile = $oic_mobile;
            $object->office_phone = $office_phone;
            $object->contact_person = $contact_person;
            $update = $object->save();
            if ($update) {
                $responseBody = $this->responseBody(true, "Police", "updated", null);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Police", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    /**
     * updateGsDivision
     * This function is used to updategs division records.
     * @param request This is the paramter to updateGsDivision function
     * @return Json This returns as response.
     */
    public function updateGsDivision(Request $request, $id)
    {

        try {
            $gs_division = $request->get('GsDivision');
            $gs_mobile = $request->get('txtGsMobil');
            $office_phone = $request->get('txtGsOfficePhone');
            $contact_person = $request->get('txtGsContactPerson');

            if ($gs_mobile == NULL) {
                $gs_mobile = '';
            }

            if ($office_phone == NULL) {
                $office_phone = '';
            }

            if ($contact_person == NULL) {
                $contact_person = '';
            }

            $object =  GsDivision::find($id);
            $object->gs_division = $gs_division;
            $object->gs_mobile = $gs_mobile;
            $object->office_phone = $office_phone;
            $object->contact_person = $contact_person;
            $update = $object->save();
            if ($update) {
                $responseBody = $this->responseBody(true, "GsDivision", "updated", null);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "GsDivision", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }


    /**
     * allSettings
     * This is the main function of search all records from the database.
     * @param name This is the paramter,This is used to specifi table name
     * @return Json This returns as response.
     */
    public static function allSettings($name)
    {

        if ($name == 'Town') {
            return Town::all();
        } else if ($name == 'CivilStatus') {
            return EmployeeCivilstatus::all();
        } else if ($name == 'Designation') {
            return EmployeeDesignation::all();
        } else if ($name == 'EmployeeType') {
            return EmployeeType::all();
        } else if ($name == 'EmployeeStatus') {
            return EmployeeStatus::all();
        } else if ($name == 'Category') {
            return EmployeeCategory::all();
        } else if ($name == 'Site') {
            return EmployeeSite::all();
        } else if ($name == 'Department') {
            return EmployeeDepartment::all();
        } else if ($name == 'Section') {
            return EmployeeSection::all();
        } else if ($name == 'SubSection') {
            $subSection =  EmployeeSubsection::all();
            for ($i = 0; $i < count($subSection); $i++) {
                $section = EmployeeSection::find($subSection[$i]->section_id);
                $subSection[$i]->section = $section->section;
            }
            return $subSection;
        } else if ($name == 'MohDivision') {
            return MohDivision::all();
        } else if ($name == 'Police') {
            return Police::all();
        } else if ($name == 'GsDivision') {
            return GsDivision::all();
        }
    }





    public static function allEnableSettings($name)
    {

        if ($name == 'Town') {
            return Town::where('status', '=', '1')->get();
        } else if ($name == 'CivilStatus') {
            return EmployeeCivilstatus::where('status', '=', '1')->get();
        } else if ($name == 'Designation') {
            return EmployeeDesignation::where('status', '=', '1')->get();
        }else if ($name == 'Team') {
            return Team::where('status', '=', '1')->get();
        } else if ($name == 'EmployeeType') {
            return EmployeeType::where('status', '=', '1')->get();
        } else if ($name == 'EmployeeStatus') {
            return EmployeeStatus::where('status', '=', '1')->get();
        } else if ($name == 'Category') {
            return EmployeeCategory::where('status', '=', '1')->get();
        } else if ($name == 'Site') {
            return EmployeeSite::where('status', '=', '1')->get();
        } else if ($name == 'Department') {
            return EmployeeDepartment::where('status', '=', '1')->get();
        } else if ($name == 'Section') {
            return EmployeeSection::where('status', '=', '1')->get();
        } else if ($name == 'SubSection') {
            return EmployeeSubsection::where('status', '=', '1')->get();
        } else if ($name == 'MohDivision') {
            return MohDivision::where('status', '=', '1')->get();
        } else if ($name == 'Police') {
            return Police::where('status', '=', '1')->get();
        } else if ($name == 'GsDivision') {
            return GsDivision::where('status', '=', '1')->get();
        }
    }


    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }


    /**
     * disableTown
     * This function is used to disable town records.
     * @param request This is the paramter to disableTown function
     * @param id This is the paramter for identify update record.
     */
    public function disableTown(Request $request, $id)
    {
        try {
            $assigned = $this->isAssigned("town_id", $id);
            if ($assigned) {
                $responseBody = $this->responseBody(false, "Town", "assigned", $assigned);
                return response()->json(["data" => $responseBody]); //if allready assigned settings, terminate this function
            }

            $value = $request->get('status');

            $object = Town::find($id);
            $object->status = $value;
            $update = $object->save();
            if ($update) {
                $responseBody = $this->responseBody(true, "Town", "updated", null);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Town", "error", null);
        }
        return response()->json(["data" => $responseBody]);
    }



    /**
     * desableCivilStatus
     * This function is used to disable civilstatus records.
     * @param request This is the paramter to desableCivilStatus function
     * @param id This is the paramter for identify update record.
     */
    public function disableCivilStatus(Request $request, $id)
    {
        try {
            $assigned = $this->isAssigned("civilstatus_id", $id);
            if ($assigned) {
                $responseBody = $this->responseBody(false, "CivilStatus", "assigned", $assigned);
                return response()->json(["data" => $responseBody]); //if allready assigned settings, terminate this function
            }
            $value = $request->get('status');

            $object = EmployeeCivilstatus::find($id);
            $object->status = $value;
            $update = $object->save();
            if ($update) {
                $responseBody = $this->responseBody(true, "CivilStatus", "updated", null);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "CivilStatus", "error", null);
        }
        return response()->json(["data" => $responseBody]);
    }



    /**
     * disableDesignation
     * This function is used to disable designation records.
     * @param request This is the paramter to disableDesignation function
     * @param id This is the paramter for identify update record.
     */
    public function disableDesignation(Request $request, $id)
    {
        try {
            $assigned = $this->isAssigned("designation_id", $id);
            if ($assigned) {
                $responseBody = $this->responseBody(false, "Designation", "assigned", $assigned);
                return response()->json(["data" => $responseBody]); //if allready assigned settings, terminate this function
            }
            $value = $request->get('status');

            $object = EmployeeDesignation::find($id);
            $object->status = $value;
            $update = $object->save();
            if ($update) {
                $responseBody = $this->responseBody(true, "Designation", "updated", null);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Designation", "error", null);
        }
        return response()->json(["data" => $responseBody]);
    }




    /**
     * desableEmployeeType
     * This function is used to disable employee type records.
     * @param request This is the paramter to desableEmployeeType function
     * @param id This is the paramter for identify update record.
     */
    public function desableEmployeeType(Request $request, $id)
    {
        try {
            $assigned = $this->isAssigned("employeetype_id", $id);
            if ($assigned) {
                $responseBody = $this->responseBody(false, "EmployeeType", "assigned", $assigned);
                return response()->json(["data" => $responseBody]); //if allready assigned settings, terminate this function
            }
            $value = $request->get('status');

            $object = EmployeeType::find($id);
            $object->status = $value;
            $update = $object->save();
            if ($update) {
                $responseBody = $this->responseBody(true, "EmployeeType", "updated", null);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "EmployeeType", "error", null);
        }
        return response()->json(["data" => $responseBody]);
    }


    /**
     * disableEmployeeStatus
     * This function is used to disable employee status records.
     * @param request This is the paramter to disableEmployeeStatus function
     * @param id This is the paramter for identify update record.
     */
    public function disableEmployeeStatus(Request $request, $id)
    {
        try {
            $assigned = $this->isAssigned("employeestatus_id", $id);
            if ($assigned) {
                $responseBody = $this->responseBody(false, "EmployeeStatus", "assigned", $assigned);
                return response()->json(["data" => $responseBody]); //if allready assigned settings, terminate this function
            }
            $value = $request->get('status');

            $object = EmployeeStatus::find($id);
            $object->status = $value;
            $update = $object->save();
            if ($update) {
                $responseBody = $this->responseBody(true, "EmployeeStatus", "updated", null);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "EmployeeStatus", "error", null);
        }
        return response()->json(["data" => $responseBody]);
    }



    /**
     * disableCategory
     * This function is used to disable category records.
     * @param request This is the paramter to disableCategory function
     * @param id This is the paramter for identify update record.
     */
    public function disableCategory(Request $request, $id)
    {
        try {
            $assigned = $this->isAssigned("category_id", $id);
            if ($assigned) {
                $responseBody = $this->responseBody(false, "Category", "assigned", $assigned);
                return response()->json(["data" => $responseBody]); //if allready assigned settings, terminate this function
            }
            $value = $request->get('status');

            $object = EmployeeCategory::find($id);
            $object->status = $value;
            $update = $object->save();
            if ($update) {
                $responseBody = $this->responseBody(true, "Category", "updated", null);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Category", "error", null);
        }
        return response()->json(["data" => $responseBody]);
    }



    /**
     * disableSite
     * This function is used to disable site records.
     * @param request This is the paramter to disableSite function
     * @param id This is the paramter for identify update record.
     */
    public function disableSite(Request $request, $id)
    {
        try {
            $assigned = $this->isAssigned("site_id", $id);
            if ($assigned) {
                $responseBody = $this->responseBody(false, "Site", "assigned", $assigned);
                return response()->json(["data" => $responseBody]); //if allready assigned settings, terminate this function
            }
            $value = $request->get('status');

            $object = EmployeeSite::find($id);
            $object->status = $value;
            $update = $object->save();
            if ($update) {
                $responseBody = $this->responseBody(true, "Site", "updated", null);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Site", "error", null);
        }
        return response()->json(["data" => $responseBody]);
    }



    /**
     * disableDepartment
     * This function is used to disable department records.
     * @param request This is the paramter to disableDepartment function
     * @param id This is the paramter for identify update record.
     */
    public function disableDepartment(Request $request, $id)
    {
        try {
            $assigned = $this->isAssigned("department_id", $id);
            if ($assigned) {
                $responseBody = $this->responseBody(false, "Department", "assigned", $assigned);
                return response()->json(["data" => $responseBody]); //if allready assigned settings, terminate this function
            }
            $value = $request->get('status');

            $object = EmployeeDepartment::find($id);
            $object->status = $value;
            $update = $object->save();
            if ($update) {
                $responseBody = $this->responseBody(true, "Department", "updated", null);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Department", "error", null);
        }
        return response()->json(["data" => $responseBody]);
    }



    /**
     * disableSection
     * This function is used to disable section records.
     * @param request This is the paramter to disableSection function
     * @param id This is the paramter for identify update record.
     */
    public function disableSection(Request $request, $id)
    {
        try {
            $assigned = $this->isAssigned("section_id", $id);
            if ($assigned) {
                $responseBody = $this->responseBody(false, "Section", "assigned", $assigned);
                return response()->json(["data" => $responseBody]); //if allready assigned settings, terminate this function
            }
            $value = $request->get('status');

            $object = EmployeeSection::find($id);
            $object->status = $value;
            $update = $object->save();
            if ($update) {
                $responseBody = $this->responseBody(true, "Section", "updated", null);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Section", "error", null);
        }
        return response()->json(["data" => $responseBody]);
    }



    /**
     * disableSubsection
     * This function is used to disable subsection records.
     * @param request This is the paramter to disableSubsection function
     * @param id This is the paramter for identify update record.
     */
    public function disableSubsection(Request $request, $id)
    {
        try {
            $assigned = $this->isAssigned("subsection_id", $id);
            if ($assigned) {
                $responseBody = $this->responseBody(false, "SubSection", "assigned", $assigned);
                return response()->json(["data" => $responseBody]); //if allready assigned settings, terminate this function
            }
            $value = $request->get('status');

            $object = EmployeeSubsection::find($id);
            $object->status = $value;
            $update = $object->save();
            if ($update) {
                $responseBody = $this->responseBody(true, "SubSection", "updated", null);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "SubSection", "error", null);
        }
        return response()->json(["data" => $responseBody]);
    }




    /**
     * disableMohDivision
     * This function is used to disable mohdivision records.
     * @param request This is the paramter to disableMohDivision function
     * @param id This is the paramter for identify update record.
     */
    public function disableMohDivision(Request $request, $id)
    {
        try {
            $assigned = $this->isAssigned("moh_division_id", $id);
            if ($assigned) {
                $responseBody = $this->responseBody(false, "MohDivision", "assigned", $assigned);
                return response()->json(["data" => $responseBody]); //if allready assigned settings, terminate this function
            }
            $value = $request->get('status');

            $object = MohDivision::find($id);
            $object->status = $value;
            $update = $object->save();
            if ($update) {
                $responseBody = $this->responseBody(true, "MohDivision", "updated", null);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "MohDivision", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    /**
     * disablePolice
     * This function is used to disable police records.
     * @param request This is the paramter to disablePolice function
     * @param id This is the paramter for identify update record.
     */
    public function disablePolice(Request $request, $id)
    {
        try {
            $assigned = $this->isAssigned("police_station_id", $id);
            if ($assigned) {
                $responseBody = $this->responseBody(false, "Police", "assigned", $assigned);
                return response()->json(["data" => $responseBody]); //if allready assigned settings, terminate this function
            }
            $value = $request->get('status');

            $object = Police::find($id);
            $object->status = $value;
            $update = $object->save();
            if ($update) {
                $responseBody = $this->responseBody(true, "Police", "updated", null);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Police", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }


    /**
     * disableGsDivision
     * This function is used to disable gsdivision records.
     * @param request This is the paramter to disableGsDivision function
     * @param id This is the paramter for identify update record.
     */
    public function disableGsDivision(Request $request, $id)
    {
        try {
            $assigned = $this->isAssigned("gs_division_id", $id);
            if ($assigned) {
                $responseBody = $this->responseBody(false, "GsDivision", "assigned", $assigned);
                return response()->json(["data" => $responseBody]); //if allready assigned settings, terminate this function
            }
            $value = $request->get('status');

            $object = GsDivision::find($id);
            $object->status = $value;
            $update = $object->save();
            if ($update) {
                $responseBody = $this->responseBody(true, "GsDivision", "updated", null);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "GsDivision", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    public static function getSettingsFromID($name, $id)
    {

        if ($name == 'Town') {
            return Town::find($id);
        } else if ($name == 'CivilStatus') {
            return EmployeeCivilstatus::find($id);
        } else if ($name == 'Designation') {
            return EmployeeDesignation::find($id);
        } else if ($name == 'EmployeeType') {
            return EmployeeType::find($id);
        } else if ($name == 'EmployeeStatus') {
            return EmployeeStatus::find($id);
        } else if ($name == 'Category') {
            return EmployeeCategory::find($id);
        } else if ($name == 'Site') {
            return EmployeeSite::find($id);
        } else if ($name == 'Department') {
            return EmployeeDepartment::find($id);
        } else if ($name == 'Section') {
            return EmployeeSection::find($id);
        } else if ($name == 'SubSection') {
            return EmployeeSubsection::find($id);
        }
    }



    private function isAssigned($setting_column, $setting_id)
    {

        $setting = DB::table('hr_employees')->where($setting_column, $setting_id)->first();
        if ($setting) {
            return true;
        }
        return false;
    }
}
