<?php

namespace Modules\Hr\Http\Controllers;


use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Hr\Entities\OtherEarningDeduction;
use Modules\Hr\Entities\SalaryData;
use Modules\Hr\Entities\TransactionItem;
use Modules\Hr\Entities\TransactionItemSetup;

class TransactionItemController extends Controller
{
    //


    public function save(Request $request)
    {

        try {
            $narration = $request->get('narration');
            $narration_sinhala = $request->get('narration_sinhala');
            $type = $request->get('type');

            $transaction_item = new TransactionItem();
            $transaction_item->narration = $narration;
            $transaction_item->narration_sinhala = $narration_sinhala;
            $transaction_item->type = $type;
            $transaction_item->status = true;
            $save = $transaction_item->save();
            if ($save) {
                $responseBody = $this->responseBody(true, "TransactionItem", "saved", null);
            } else {
                $responseBody = $this->responseBody(true, "TransactionItem", "error", $save);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "TransactionItem", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }


    public function update(Request $request)
    {
        try {
            $item_id = $request->get('hidItem_Id');
            $narration = $request->get('txtNarration');
            $narration_sinhala = $request->get('txtNarrationSinhala');
            $type = $request->get('selcType');

            $transaction_item = TransactionItem::find($item_id);
            $transaction_item->narration = $narration;
            $transaction_item->narration_sinhala = $narration_sinhala;
            $transaction_item->type = $type;
            $update = $transaction_item->save();

            if ($update) {
                $responseBody = $this->responseBody(true, "TransactionItem", "updated", null);
            } else {
                $responseBody = $this->responseBody(true, "TransactionItem", "error", $update);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "TransactionItem", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }


    public function allTransactionItems()
    {
        try {
            $transaction_items = TransactionItem::all();
            $responseBody = $this->responseBody(true, "TransactionItem", "all", $transaction_items);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "TransactionItem", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }


    public function disableTransactionItem(Request $request, $id)
    {
        try {
            $status = $request->get('status');
            $transaction_item = TransactionItem::find($id);
            $transaction_item->status = $status;
            $is_transaction_setup = $this->is_transactionItemSetup($id);
            $is_otherEarningDeduction = $this->is_otherEarningDeduction($id);
            $is_salarySheetEarning = $this->is_salarySheetEarning($id);
            $is_salarySheetDeduct = $this->is_salarySheetDeduction($id);
            $status = false;
            if (!$is_transaction_setup && !$is_otherEarningDeduction && !$is_salarySheetEarning && !$is_salarySheetDeduct) {
                $status = $transaction_item->save();
            } else {
                $status = false;
            }
            $responseBody = $this->responseBody(true, "TransactionItem", "disabled", $status);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "TransactionItem", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }






    public function delete($id)
    {
        try {
            $transaction_item = TransactionItem::find($id);
            $is_transaction_setup = $this->is_transactionItemSetup($id);
            $is_otherEarningDeduction = $this->is_otherEarningDeduction($id);
            $is_salarySheetEarning = $this->is_salarySheetEarning($id);
            $is_salarySheetDeduct = $this->is_salarySheetDeduction($id);
            $status = false;
            if (!$is_transaction_setup && !$is_otherEarningDeduction && !$is_salarySheetEarning && !$is_salarySheetDeduct) {
                $status = $transaction_item->delete();
            } else {
                $status = false;
            }
            $responseBody = $this->responseBody(true, "TransactionItem", "deleted", $status);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "TransactionItem", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    private function is_transactionItemSetup($id)
    {
        $transaction_item_setup = TransactionItemSetup::where('item_id', '=', $id)->get();
        if (count($transaction_item_setup) > 0) {
            return true;
        }
        return false;
    }





    private function is_otherEarningDeduction($id)
    {
        $earning_deduction = OtherEarningDeduction::where('item_id', '=', $id)->get();
        if (count($earning_deduction) > 0) {
            return true;
        }
        return false;
    }




    private function is_salarySheetEarning($id)
    {
        for ($i = 1; $i <= 10; $i++) {
            if ($i < 10) {
                $column = 'earn_trans_id_0' . $i;
            } else {
                $column = 'earn_trans_id_' . $i;
            }

            $transaction_item = SalaryData::where($column,'=',$id)->get();
            if(count($transaction_item) > 0){
                return true;
            }
        }
        return false;
    }



    private function is_salarySheetDeduction($id)
    {
        for ($i = 1; $i <= 10; $i++) {
            if ($i < 10) {
                $column = 'deduct_trans_id_0' . $i;
            } else {
                $column = 'deduct_trans_id_' . $i;
            }

            $transaction_item = SalaryData::where($column,'=',$id)->get();
            if(count($transaction_item) > 0){
                return true;
            }
        }
        return false;
    }



    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
