
function checkRoster(date) {
    var employee_id = $('#cmbEmployeeID').val();
    var result = isAllocateRoster(employee_id, date);
    var designation = result['designation'];
    var schedule = result['schedule'];
  

    IS_ROSTER = true;
    if (!schedule && designation.designation == 'Driver') {
        IS_ROSTER = false;
    }

    if (!schedule && designation.designation == 'Lorry Helper') {
        IS_ROSTER = false;
    }

}


function isAllocateRoster(id, date) {

    var result = undefined;
    $.ajax({
        type: "GET",
        url: '/hr/driverRosterSchedule/isRoster/' + id + '/' + date,
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            result = response.data.result;
        },
        error: function (error) {
            console.log(error);

        },
        complete: function () {

        }

    });

    return result;
}



function createDriverRoster(id) {

    

    var schedule_in = $('#txtInTime_' + id).val();
    var schedule_out = $('#txtOutTime_' + id).val();
    //$('#txt_in_' + id).val(schedule_in);
    //$('#txt_out_' + id).val(schedule_out);
    //alert($('#txtOutTime_' + id).val());

    $.ajax({
        type: 'PUT',
        url: '/hr/driverRosterSchedule/createRoster/' + id,
        data: {
            _token: $('input[name=_token]').val(),
            "schedule_id":$('#txt_in_' + id).attr('data-id'),
            "employee_id": $('#cmbEmployeeID').val(),
            "schedule_date_from": schedule_in.split(' ')[0],
            "shift": 2,
            "schedule_in": schedule_in,
            "schedule_out": schedule_out,
            "attendance_in": $('#txtInTime_' + id).val(),
            "attendance_out": $('#txtOutTime_' + id).val(),
        },
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            showSuccessMessage("Attendance has been updated successfully...");
            var employee_id = $('#cmbEmployeeID').val();
            var startDate = new Date($('#txtDateFrom').val()).toISOString().slice(0, 10);
            var endDate = new Date($('#txtDateTo').val()).toISOString().slice(0, 10);
            loadAttendance(employee_id, startDate, endDate);



        },
        error: function (error) {
            console.log(error.message);
            showErrorMessage();
        },
        complete: function () {

        }

    });


}


function checkFormat(input) {


    input.focus();
    var date = input.val().split(' ')[0];
    var time = input.val().split(' ')[1];
    if (!date || !time || date.split('-')[0].length != 4 || date.split('-')[1].length != 2 || date.split('-')[2].length != 2 || time.split(':')[0].length != 2 || time.split(':')[1].length != 2 || time.split(':')[2].length != 2) {
        input.css({ "background-color": "yellow" });
        showWarningMessage("Format error (yyyy-MM-dd hh:mm:ss)")
        return false;
    }
    input.css({ "background-color": "white" });
    return true;



}


