

var processEmployees = undefined;
var processIndex = 0;
$(document).ready(function () {

    getProcessEmployeesRawData();

    $('input[name="fromDate_RawData"]').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        locale: {
            format: 'YYYY-MM-DD',
        }

    });

    $('input[name="toDate_RawData"]').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        locale: {
            format: 'YYYY-MM-DD',
        }

    });

    $('#employeeDiv_RawData').hide();
    $('#siteDiv_RawData').hide();
    allEmployees_RawData();
    allEmployees_Site();
    isMonthEndPeocess_RawData();


    $('#cmbProcessType_RawData').on('change', function () {

        var args = $(this).val();
        processType_RawData(args);
    });


    $('#txtFromDate_RawData').on('change', function () {
        isMonthEndPeocess_RawData();
    });

    $('#txtToDate_RawData').on('change', function () {
        isMonthEndPeocess_RawData();
    });


   
    $('#btnProccess_RawData').on('click', function () {
        if ($('#cmbProcessType_RawData').val() == "All") {
            proccess_RawData(100);
        } else if ($('#cmbProcessType_RawData').val() == "Employee") {
            proccess_RawData_Individual(100);
        } else if ($('#cmbProcessType_RawData').val() == "Site"){
            proccess_RawData_site(100);
        }

    });

});





function allEmployees_RawData() {

    $.ajax({
        type: "GET",
        url: "/hr/attendanceProcess/allEmployees",
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {
                var employees = response.data.result;
                $('#txtEmployee_RawData').setData(employees);

            } else {
                showErrorMessage();
            }
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {

        }

    });
}



function allEmployees_Site() {

    $.ajax({
        type: "GET",
        url: "/hr/attendanceProcess/allEmployeesSite",
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {
                var sites = response.data.result;
                $('#cmbSite_RawData').empty()
                for (var i = 0; i < sites.length; i++) {
                    $('#cmbSite_RawData').append("<option value='" + sites[i].site_id + "'>" + sites[i].site + "</option>");
                }

            } else {
                showErrorMessage();
            }
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {

        }

    });
}



function getProcessEmployeesRawData() {
    $.ajax({
        type: "GET",
        url: "/hr/attendanceProcess/getProcessEmployees",
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {
                processEmployees = response.data.result;
                $('#att_raw_process').attr('max', response.data.result.length);
            }
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {

        }

    });

}




function processType_RawData(args) {

    if (args == "All") {
        $('#employeeDiv_RawData').hide();
        $('#siteDiv_RawData').hide();
        $('#att_raw_process').show();
        $('#lbl_att_raw_process').show();
    } else if (args == "Employee") {
        $('#employeeDiv_RawData').show();
        $('#siteDiv_RawData').hide();
        $('#att_raw_process').hide();
        $('#lbl_att_raw_process').hide();
    } else if (args == "Site") {
        $('#siteDiv_RawData').show();
        $('#employeeDiv_RawData').hide();
        $('#att_raw_process').show();
        $('#lbl_att_raw_process').show();
    }
}



function setSelectedOption_RawData(id, valueToSelect) {
    let element = document.getElementById(id);
    element.value = valueToSelect;
}


function proccess_RawData(status) {


    $('#att_raw_process').val(0);
    var employee = processEmployees[processIndex]['employee_id'];
    if (employee != undefined) {
        /*var fromDate = new Date($('#txtFromDate_RawData').val()).toISOString().slice(0, 10);
        var toDate = new Date($('#txtToDate_RawData').val()).toISOString().slice(0, 10);
        var url = "/hr/attendanceRawDataProcessAll/" + fromDate + "/" + toDate;

        var process = $('#cmbProcessType_RawData').val();
        if (process == "All") {
            url = "/hr/attendanceRawDataProcessAll/" + employee + "/" + fromDate + "/" + toDate;
        } else if (process == "Employee") {
            var id = $('#txtEmployee_RawData').optionID();
            url = "/hr/attendanceRawDataProcessEmployee/" + id + "/" + fromDate + "/" + toDate;
        }*/

        var fromDate = new Date($('#txtFromDate_RawData').val()).toISOString().slice(0, 10);
        var toDate = new Date($('#txtToDate_RawData').val()).toISOString().slice(0, 10);
        var url = "/hr/attendanceRawDataProcessAll/" + employee + "/" + fromDate + "/" + toDate;

        if (status == 100) {

            var emp_id = "";
            var name = "";
            $.ajax({
                type: "GET",
                url: url,
                processData: false,
                contentType: false,
                cache: false,
                timeout: 0,
                beforeSend: function () {
                    $('#lbl_att_raw_process').text("Employee : " + emp_id + " - " + name + "(processing..)");
                    $('#btnProccess_RawData').prop("disabled", true);
                    document.getElementById('btnProccess_RawData').innerHTML = '<i class="fa fa-circle-o-notch fa-spin"></i>';
                },
                success: function (response) {
                    console.log(response);
                    emp_id = response.employee.id;
                    name = response.employee.name;
                    proccess_RawData(response.status);
                    $('#att_raw_process').val(processIndex++);
                    var presentage = parseFloat((100 / processEmployees.length) * processIndex).toFixed(2);
                    $('#lbl_att_raw_process').text("Employee : " + emp_id + " - " + name + "(" + presentage + "%)");
                    if (presentage == 100) {
                        processIndex = 0;
                        $('#btnProccess_RawData').text('Process');
                        $('#btnProccess_RawData').prop("disabled", false);
                        $('#lbl_att_raw_process').text("Attendance Process : " + presentage + "%");
                        showSuccessMessage('Attendance Process completed successfully...!');
                        processEmployees = undefined;
                    }

                },
                error: function (error) {
                    console.log(error);
                    showErrorMessage();
                },
                complete: function () {
                    //$('#btnProccess_RawData').text('Process');
                    //$('#btnProccess_RawData').prop("disabled", false);
                }

            });
        }
    }
}





function proccess_RawData_Individual(status) {


    var fromDate = new Date($('#txtFromDate_RawData').val()).toISOString().slice(0, 10);
    var toDate = new Date($('#txtToDate_RawData').val()).toISOString().slice(0, 10);
    var id = $('#txtEmployee_RawData').optionID();
    url = "/hr/attendanceRawDataProcessEmployee/" + id + "/" + fromDate + "/" + toDate;
    if (status == 100) {

        var emp_id = "";
        var name = "";
        $.ajax({
            type: "GET",
            url: url,
            processData: false,
            contentType: false,
            cache: false,
            timeout: 0,
            beforeSend: function () {
                $('#lbl_att_raw_process').text("Employee : " + emp_id + " - " + name + "(processing..)");
                $('#btnProccess_RawData').prop("disabled", true);
                document.getElementById('btnProccess_RawData').innerHTML = '<i class="fa fa-circle-o-notch fa-spin"></i>';
            },
            success: function (response) {
                console.log(response);
                showSuccessMessage('Attendance Process completed successfully...!');

            },
            error: function (error) {
                console.log(error);
                showErrorMessage();
            },
            complete: function () {
                $('#btnProccess_RawData').text('Process');
                $('#btnProccess_RawData').prop("disabled", false);
            }

        });
    }

}




function proccess_RawData_site(status) {




    $('#att_raw_process').val(0);
    var employee = processEmployees[processIndex]['employee_id'];
    if (employee != undefined) {
        var fromDate = new Date($('#txtFromDate_RawData').val()).toISOString().slice(0, 10);
        var toDate = new Date($('#txtToDate_RawData').val()).toISOString().slice(0, 10);
        var url = "/hr/attendanceRawDataProcessAllSite/" + employee + "/" + fromDate + "/" + toDate + "/" + $('#cmbSite_RawData').val();
	//alert(url);
        if (status == 100) {

            var emp_id = "";
            var name = "";
            $.ajax({
                type: "GET",
                url: url,
                processData: false,
                contentType: false,
                cache: false,
                timeout: 0,
                beforeSend: function () {
                    $('#lbl_att_raw_process').text("Employee : " + emp_id + " - " + name + "(processing..)");
                    $('#btnProccess_RawData').prop("disabled", true);
                    document.getElementById('btnProccess_RawData').innerHTML = '<i class="fa fa-circle-o-notch fa-spin"></i>';
                },
                success: function (response) {

                    emp_id = response.employee.id;
                    name = response.employee.name;
                    if (emp_id != '') {
                        console.log(response);
                    }
                    proccess_RawData_site(response.status);
                    $('#att_raw_process').val(processIndex++);
                    var presentage = parseFloat((100 / processEmployees.length) * processIndex).toFixed(2);
                    $('#lbl_att_raw_process').text("Employee : " + emp_id + " - " + name + "(" + presentage + "%)");
                    if (presentage == 100) {
                        processIndex = 0;
                        $('#btnProccess_RawData').text('Process');
                        $('#btnProccess_RawData').prop("disabled", false);
                        $('#lbl_att_raw_process').text("Attendance Process : " + presentage + "%");
                        showSuccessMessage('Attendance Process completed successfully...!');
                        processEmployees = undefined;
                    }

                },
                error: function (error) {
                    console.log(error);
                    showErrorMessage();
                },
                complete: function () {
                    //$('#btnProccess_RawData').text('Process');
                    //$('#btnProccess_RawData').prop("disabled", false);
                }

            });
        }
    }

}


function isMonthEndPeocess_RawData() {
    $.ajax({
        type: "GET",
        url: '/hr/salaryData/isMonthEndProcess',
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                var month_end_year = response.data.result.year;
                var month_end_month = response.data.result.month;

                var from_year = $('#txtFromDate_RawData').val().split('-')[0];
                var from_month = $('#txtFromDate_RawData').val().split('-')[1];

                var to_year = $('#txtToDate_RawData').val().split('-')[0];
                var to_month = $('#txtToDate_RawData').val().split('-')[1];

                if ((parseInt(from_year) >= parseInt(month_end_year) && parseInt(from_month) >= parseInt(month_end_month)) && (parseInt(to_year) >= parseInt(month_end_year) && parseInt(to_month) >= parseInt(month_end_month))) {
                    $('#btnProccess_RawData').prop("disabled", false);
                } else {
                    $('#btnProccess_RawData').prop("disabled", true);
                }



            }

        },
        error: function (error) {
            console.log(error);
            //showErrorMessage();
        },
        complete: function () {

        }

    });
}



/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {
    toastr.success(message);
}


/**
* showWarningMessage
* This function is used to show warning message.
* @param message This is the paramter to require message content
*/
function showWarningMessage(message) {
    toastr.warning(message);
}



/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}