
$(document).ready(function () {
    

    $('input[name="fromDate_PostPayroll"]').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        locale: {
            format: 'YYYY-MM-DD',
        }

    });

    $('input[name="toDate_PostPayroll"]').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        locale: {
            format: 'YYYY-MM-DD',
        }

    });

    $('#employeeDiv_PostPayroll').hide();
    allEmployees_PostPayroll();
    isMonthEndPeocess_PostPayroll();


    $('#cmbProcessType_PostPayroll').on('change', function () {

        var args = $(this).val();
        processType_PostPayroll(args);
    });


    $('#txtFromDate_PostPayroll').on('change', function () {
        isMonthEndPeocess_PostPayroll();
    });

    $('#txtToDate_PostPayroll').on('change', function () {
        isMonthEndPeocess_PostPayroll();
    });


});





function allEmployees_PostPayroll() {

    $.ajax({
        type: "GET",
        url: "/hr/attendanceProcess/allEmployees",
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {
                var employees = response.data.result;
                $('#txtEmployee_PostPayroll').setData(employees);

            } else {
                showErrorMessage();
            }
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {

        }

    });
}



function processType_PostPayroll(args) {

    if (args == "All") {
        $('#employeeDiv_PostPayroll').hide();
    } else if (args == "Employee") {
        $('#employeeDiv_PostPayroll').show();
    }
}



function setSelectedOption_PostPayroll(id, valueToSelect) {
    let element = document.getElementById(id);
    element.value = valueToSelect;
}


function proccess_PostPayroll() {

    var fromDate = new Date($('#txtFromDate_PostPayroll').val()).toISOString().slice(0, 10);
    var toDate = new Date($('#txtToDate_PostPayroll').val()).toISOString().slice(0, 10);
    var url = "/hr/attendancePostPayrollAll/" + fromDate + "/" + toDate;

    var process = $('#cmbProcessType_PostPayroll').val();
    if (process == "All") {
        url = "/hr/attendancePostPayrollAll/" + fromDate + "/" + toDate;
    } else if (process == "Employee") {
        var id = $('#txtEmployee_PostPayroll').optionID();
        url = "/hr/attendancePostPayrollEmployee/" + id + "/" + fromDate + "/" + toDate;
    }


    $.ajax({
        type: "GET",
        url: url,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 0,
        beforeSend: function () {
            $('#btnProccess_PostPayroll').prop("disabled", true);
            document.getElementById('btnProccess_PostPayroll').innerHTML = '<i class="fa fa-circle-o-notch fa-spin"></i>';
        },
        success: function (response) {
            console.log(response);
            showSuccessMessage('Attendance Process completed successfully...!');

        },
        error: function (error) {
            console.log(error);
            //showErrorMessage();
	    showSuccessMessage('Attendance Process completed successfully...!');

        },
        complete: function () {
            $('#btnProccess_PostPayroll').text('Process');
            $('#btnProccess_PostPayroll').prop("disabled", false);
        }

    });
}




function isMonthEndPeocess_PostPayroll() {
    $.ajax({
        type: "GET",
        url: '/hr/salaryData/isMonthEndProcess',
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                var month_end_year = response.data.result.year;
                var month_end_month = response.data.result.month;

                var from_year = $('#txtFromDate_PostPayroll').val().split('-')[0];
                var from_month = $('#txtFromDate_PostPayroll').val().split('-')[1];

                var to_year = $('#txtToDate_PostPayroll').val().split('-')[0];
                var to_month = $('#txtToDate_PostPayroll').val().split('-')[1];

                if ((parseInt(from_year) == parseInt(month_end_year) && parseInt(from_month) == parseInt(month_end_month)) && (parseInt(to_year) == parseInt(month_end_year) && parseInt(to_month) == parseInt(month_end_month))) {
                    $('#btnProccess_PostPayroll').prop("disabled", false);
                } else {
                    $('#btnProccess_PostPayroll').prop("disabled", true);
                }



            }

        },
        error: function (error) {
            console.log(error);
            //showErrorMessage();
        },
        complete: function () {

        }

    });
}


/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {
    toastr.success(message);
}


/**
* showWarningMessage
* This function is used to show warning message.
* @param message This is the paramter to require message content
*/
function showWarningMessage(message) {
    toastr.warning(message);
}



/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}