/**
* showModal
* This function is used to open modal.
* @param event This is the paramter to identify save/update
* @param name This is the paramter to identify settings name
*/

var settingName = "";
const URL_MAP = {
    'Holiday': '/hr/attSettings/attHolidayType',
    'UpdateHoliday': '/hr/attSettings/attHolidayType/updateHolidayType/',
    'AllHoliday': '/hr/attSettings/attHolidayType/allHolidayType',
    'DisableHoliday': '/hr/attSettings/attHolidayType/disableHolidayType/',

    'WorkDay': '/hr/attSettings/attSpecialWorkDayType',
    'UpdateWorkDay': '/hr/attSettings/attHolidayType/updateWorkdayType/',
    'AllWorkDay': '/hr/attSettings/attWorkDayType/allWorkDayType',
    'DisableWorkDay': '/hr/attSettings/attWorkDayType/disableWorkDayType/',

    'Leave': '/hr/attSettings/attLeaveType',
    'UpdateLeave': '/hr/attSettings/attLeaveType/updateLeaveType/',
    'AllLeave': '/hr/attSettings/attLeaveType/allLeaveType',
    'DisableLeave': '/hr/attSettings/attLeaveType/disableLeaveType/',

};

function saveHoliday() {
    settingName = 'Holiday';
    $('#btnAction').text('Save');
    holidaySettingsModal(null);
}

function saveWorkDay() {
    settingName = 'WorkDay';
    $('#btnAction').text('Save');
    specialWorkDaysSettingsModal(null);
}

function saveLeave() {
    settingName = 'Leave';
    $('#btnAction').text('Save');
    leaveTypeSettingsModal(null);
}

function editHoliday(id) {
    settingName = 'UpdateHoliday';
    $('#btnAction').text('Update');
    getHoliday(id);
}

function editWorkDay(id) {
    settingName = 'UpdateWorkDay';
    $('#btnAction').text('Update');
    getWorkDay(id);
}



function editLeave(id) {
    settingName = 'UpdateLeave';
    $('#btnAction').text('Update');
    getLeave(id);
}



function disableHoliday(event, id) {
    var url = URL_MAP['DisableHoliday'];
    var status = event.target.checked;
    disable(url, id, status);
}



function disableWorkDay(event, id) {
    var url = URL_MAP['DisableWorkDay'];
    var status = event.target.checked;
    disable(url, id, status);
}



function disableLeave(event, id) {
    var url = URL_MAP['DisableLeave'];
    var status = event.target.checked;
    disable(url, id, status);
}


$(document).ready(function () {
    $('#btnAction').click(function () {
        var event = $('#btnAction').text();
        var url = URL_MAP[settingName];

        if (event == 'Save') {
            save(url);
        } else if (event == 'Update') {
            update(url);
        }
    });
});





function holidaySettingsModal(args) {

    var header = document.getElementById('settingsAddModalTitle');
    header.innerHTML = 'Holiday Settings';
    var modalContent = document.getElementById('settingsAddModalBody');
    modalContent.innerHTML = '';

    var hiddenInput = document.createElement("INPUT");
    hiddenInput.setAttribute("type", "hidden");
    hiddenInput.setAttribute("id", "txtID");
    hiddenInput.setAttribute("name", "txtID");
    modalContent.appendChild(hiddenInput);


    var parent_div = document.createElement("DIV");
    parent_div.setAttribute("class", "form-row");
    modalContent.appendChild(parent_div);

    var child_div1 = document.createElement("DIV");
    child_div1.setAttribute("class", "col-md-12 mb-3");
    parent_div.appendChild(child_div1);


    var child_div2 = document.createElement("DIV");
    child_div2.setAttribute("class", "col-md-12 mb-3");
    parent_div.appendChild(child_div2);


    var label2 = document.createElement("LABEL");
    label2.innerHTML = 'Holiday Type';
    child_div2.appendChild(label2);

    var text = document.createElement("INPUT");
    text.setAttribute("type", "text");
    text.setAttribute("id", "txtHolidayType");
    text.setAttribute("name", "txtHolidayType");
    text.setAttribute("class", "form-control");
    child_div2.appendChild(text);

    if (args != null) {
        text.setAttribute("value", args.holyday_type);
        hiddenInput.setAttribute("value", args.holyday_type_id);
    }


    $("#settingsAddModal").modal('toggle');
}






function specialWorkDaysSettingsModal(args) {

    var header = document.getElementById('settingsAddModalTitle');
    header.innerHTML = 'Special Work Day Settings';
    var modalContent = document.getElementById('settingsAddModalBody');
    modalContent.innerHTML = '';

    var hiddenInput = document.createElement("INPUT");
    hiddenInput.setAttribute("type", "hidden");
    hiddenInput.setAttribute("id", "txtID");
    hiddenInput.setAttribute("name", "txtID");
    modalContent.appendChild(hiddenInput);


    var parent_div = document.createElement("DIV");
    parent_div.setAttribute("class", "form-row");
    modalContent.appendChild(parent_div);

    var child_div1 = document.createElement("DIV");
    child_div1.setAttribute("class", "col-md-12 mb-3");
    parent_div.appendChild(child_div1);


    var child_div2 = document.createElement("DIV");
    child_div2.setAttribute("class", "col-md-12 mb-3");
    parent_div.appendChild(child_div2);


    var label2 = document.createElement("LABEL");
    label2.innerHTML = ' Special Work type';
    child_div2.appendChild(label2);

    var text = document.createElement("INPUT");
    text.setAttribute("type", "text");
    text.setAttribute("id", "txtSpWorkType");
    text.setAttribute("name", "txtSpWorkType");
    text.setAttribute("class", "form-control");
    child_div2.appendChild(text);

    if (args != null) {
        text.setAttribute("value", args.sp_work_type);
        hiddenInput.setAttribute("value", args.sp_work_type_id);
    }


    $("#settingsAddModal").modal('toggle');
}









function leaveTypeSettingsModal(args) {

    var header = document.getElementById('settingsAddModalTitle');
    header.innerHTML = 'Leave Settings';
    var modalContent = document.getElementById('settingsAddModalBody');
    modalContent.innerHTML = '';

    var hiddenInput = document.createElement("INPUT");
    hiddenInput.setAttribute("type", "hidden");
    hiddenInput.setAttribute("id", "txtID");
    hiddenInput.setAttribute("name", "txtID");
    modalContent.appendChild(hiddenInput);


    var parent_div = document.createElement("DIV");
    parent_div.setAttribute("class", "form-row");
    modalContent.appendChild(parent_div);

    var child_div1 = document.createElement("DIV");
    child_div1.setAttribute("class", "col-md-12 mb-3");
    parent_div.appendChild(child_div1);


    var child_div2 = document.createElement("DIV");
    child_div2.setAttribute("class", "col-md-12 mb-3");
    parent_div.appendChild(child_div2);


    var label2 = document.createElement("LABEL");
    label2.innerHTML = 'Leave Type';
    child_div2.appendChild(label2);

    var text = document.createElement("INPUT");
    text.setAttribute("type", "text");
    text.setAttribute("id", "txtLeaveType");
    text.setAttribute("name", "txtLeaveType");
    text.setAttribute("class", "form-control");
    child_div2.appendChild(text);



    var parent_div2 = document.createElement("DIV");
    parent_div2.setAttribute("class", "form-row");
    modalContent.appendChild(parent_div2);

    var child_div3 = document.createElement("DIV");
    child_div3.setAttribute("class", "col-md-12 mb-3");
    parent_div2.appendChild(child_div3);


    var child_div4 = document.createElement("DIV");
    child_div4.setAttribute("class", "col-md-12 mb-3");
    parent_div.appendChild(child_div3);


    var label3 = document.createElement("LABEL");
    label3.innerHTML = 'Days Per Year';
    child_div3.appendChild(label3);

    var text2 = document.createElement("INPUT");
    text2.setAttribute("type", "text");
    text2.setAttribute("id", "txtDaysPerYear");
    text2.setAttribute("name", "txtDaysPerYear");
    text2.setAttribute("class", "form-control");
    child_div3.appendChild(text2);



    if (args != null) {
        text.setAttribute("value", args.leave_type);
        hiddenInput.setAttribute("value", args.leave_type_id);
        text2.setAttribute("value", args.days_per_year);
    }


    $("#settingsAddModal").modal('toggle');
}




function save(url) {

    var form = $('#attSettingsForm').get(0);
    var data = new FormData(form);
    data.append("name", settingName);

    $.ajax({
        type: "POST",
        url: url,
        data: data,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {
            $("#settingsAddModal").modal('hide');
        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {


                if (settingName == 'Holiday') {

                    showSuccessMessage("Holiday type has been saved successfully...");
                    getAll('AllHoliday');

                } else if (settingName == 'WorkDay') {

                    showSuccessMessage("Workday type has been saved successfully...");
                    getAll('AllWorkDay');

                } else if (settingName == 'Leave') {

                    showSuccessMessage("Leave has been saved successfully...");
                    getAll('AllLeave');
                }

            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }

    });
}





function allHolidayType() {
    $.ajax({
        type: "GET",
        url: '/hr/attHolidayType/allHolidayType',
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {

                var name = response.data.name;
                var result = response.data.result;
                loadTable(name, result);

            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }

    });
}






function getAll(args) {

    var url = URL_MAP[args];

    $.ajax({
        type: "GET",
        url: url,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {

                var name = response.data.name;
                var result = response.data.result;
                loadTable(name, result);

            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }

    });
}




function getHoliday(id) {

    $.ajax({
        type: "GET",
        url: '/hr/attSettings/attHolidayType/holidayType/' + id,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {

                holidaySettingsModal(response.data.result);

            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }

    });

}




function getWorkDay(id) {

    $.ajax({
        type: "GET",
        url: '/hr/attSettings/attWorkDayType/workdayType/' + id,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {

                specialWorkDaysSettingsModal(response.data.result);

            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }

    });

}






function getLeave(id) {

    $.ajax({
        type: "GET",
        url: '/hr/attSettings/attLeaveType/leaveType/' + id,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {

                leaveTypeSettingsModal(response.data.result);

            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }

    });

}





function update(url) {

    var id = $('#txtID').val();
    var type = null;
    var daysPerYear = null;

    if (settingName == 'UpdateHoliday') {

        type = $('#txtHolidayType').val();

    } else if (settingName == 'UpdateWorkDay') {

        type = $('#txtSpWorkType').val();

    } else if (settingName == 'UpdateLeave') {

        type = $('#txtLeaveType').val();
        daysPerYear = $('#txtDaysPerYear').val();

    }


    $.ajax({
        type: 'PUT',
        url: url + id,
        data: {
            _token: $('input[name=_token]').val(),
            "type": type,
            "daysPerYear": daysPerYear,
        },
        timeout: 800000,
        beforeSend: function () {
            $("#settingsAddModal").modal('hide');
        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {


                if (response.data.name == 'Holiday') {
                    showSuccessMessage("Holiday type has been updated successfully...");
                    getAll('AllHoliday');
                } else if (response.data.name == 'WorkDay') {
                    showSuccessMessage("Workday type has been updated successfully...");
                    getAll('AllWorkDay');
                } else if (response.data.name == 'LeaveType') {
                    showSuccessMessage("Leave has been updated successfully...");
                    getAll('AllLeave');
                }

            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }

    });
}








function disable(url, id, status) {

    var bool = 0;
    if (status) bool = 1;

    $.ajax({
        type: 'PUT',
        url: url + id,
        data: {
            _token: $('input[name=_token]').val(),
            "status": bool,
        },
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {


                if (response.data.name == 'Holiday') {
                    showSuccessMessage("Holiday type has been disabled successfully...");
                    getAll('AllHoliday');
                } else if (response.data.name == 'WorkDay') {
                    showSuccessMessage("Workday type has been disabled successfully...");
                    getAll('AllWorkDay');
                } else if (response.data.name == 'LeaveType') {
                    showSuccessMessage("Leave has been disabled successfully...");
                    getAll('AllLeave');
                }

            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }

    });
}





/**
* loadTable
* This function is used to data set on the tables.
* @param name This is the paramter to identifi table name
* @param name This is the paramter to require table content
*/
function loadTable(name, result) {

    var disable = { 0: "", 1: "checked" }
    var tbody = "";
    var tableName = "#tbl" + name;

    for (i = 0; i < result.length; i++) {

        var editable = "";
        if (!result[i].editable) {
            editable = "disabled";
        }
        var row = "<tr>";
        if (name == 'Holiday') {
            var string_id = "'" + result[i].holyday_type_id + "'";

            row += '<td class="id" id="' + result[i].holyday_type_id + '">' + generateID(result[i].holyday_type_id) + '</td>';
            row += '<td>' + result[i].holyday_type + '</td>';
            row += '<td class="edit edit_holiday">';
            row += '<button type="button" class="btn btn-primary setting-edit-btn" onclick="editHoliday(' + string_id + ')" ' + editable + '>';
            row += '<i class="fa fa-pencil-square-o" aria-hidden="true"></button>';

            row += '</td>';
            row += '<td class="disable disable_holiday">';
            row += '<label class="switch">';
            row += '<input type="checkbox" id="' + result[i].holyday_type_id + '" onchange="disableHoliday(event,' + string_id + ')" ' + disable[result[i].status] + ' ' + editable + ' >';

        } else if (name == 'WorkDay') {
            var string_id = "'" + result[i].sp_work_type_id + "'";

            row += '<td class="id" id="' + result[i].sp_work_type_id + '">' + generateID(result[i].sp_work_type_id) + '</td>';
            row += '<td>' + result[i].sp_work_type + '</td>';
            row += '<td class="edit edit_workday">';
            row += '<button type="button" class="btn btn-primary setting-edit-btn" onclick="editWorkDay(' + string_id + ')">';
            row += '<i class="fa fa-pencil-square-o" aria-hidden="true"></button>';

            row += '</td>';
            row += '<td class="disable disable_workday">';
            row += '<label class="switch">';
            row += '<input type="checkbox" id="' + result[i].sp_work_type_id + '" onchange="disableWorkDay(event,' + string_id + ')" ' + disable[result[i].status] + '>';

        } else if (name == 'Leave') {
            var string_id = "'" + result[i].leave_type_id + "'";

            row += '<td class="id" id="' + result[i].leave_type_id + '">' + generateID(result[i].leave_type_id) + '</td>';
            row += '<td>' + result[i].leave_type + '</td>';
            row += '<td class="edit edit_leave">';
            row += '<button type="button" class="btn btn-primary setting-edit-btn" onclick="editLeave(' + string_id + ')">';
            row += '<i class="fa fa-pencil-square-o" aria-hidden="true"></button>';

            row += '</td>';
            row += '<td class="disable disable_leave">';
            row += '<label class="switch">';
            row += '<input type="checkbox" id="' + result[i].leave_type_id + '" onchange="disableLeave(event,' + string_id + ')" ' + disable[result[i].status] + '>';

        }

        row += '<span class="slider round"></span>';
        row += '</label>';
        row += '</td>';
        row += '</tr>';
        tbody += row;
    }
    $(tableName).empty();
    $(tableName).append(tbody);

    if (!holiday_edit_permission) {
        $('.edit_holiday').hide();
    }

    if (!holiday_disable_permission) {
        $('.disable_holiday').hide();
    }

    if (!workday_edit_permission) {
        $('.edit_workday').hide();
    }

    if (!workday_disable_permission) {
        $('.disable_workday').hide();
    }

    if (!leave_edit_permission) {
        $('.edit_leave').hide();
    }

    if (!leave_disable_permission) {
        $('.disable_leave').hide();
    }

}




/**
* generateID
* This function is used to generate id
* @param id This is the paramter to require id
*/
function generateID(id) {

    let pattern = {
        1: "000",
        2: "00",
        3: "0",
    };
    var length = Math.ceil(Math.log(id + 1) / Math.LN10);
    return pattern[length] + id;
}





/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {

    toastr.success(message);
}



/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}


/**
* showWarrningMessage
* This function is used to show warning message.
* @param message This is the paramter to require message content
*/
function showWarningMessage(message) {

    toastr.warning(message);
}