
$(document).ready(function () {

    $.ajax({
        type: "GET",
        url: "/registerd",
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {

                appendTableRow(response.data.result);
            }
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });

});





function appendTableRow(result) {
    var tbody = [];

    for (i = 0; i < result.length; i++) {
        var today = 0;
        if (result[i].scheduled > 0) {
            today = (result[i].attend / result[i].scheduled) * 100;
        }

        if (result[i].designation != "Unspecified") {
            var row = '<tr>';
            row += '<td>' + result[i].designation + '</td>';
            row += '<td class="text-right">' + result[i].registerd + '</td>';
            row += '<td class="text-right">' + result[i].scheduled + '</td>';
            row += '<td class="text-right">' + result[i].attend + '</td>';
            row += '<td class="text-right">' + today.toFixed(2) + '%</td>';
            row += '<td class="text-right">' + "0" + '</td>';
            row += '<td><span class="badge badge-success"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="4.5" stroke-linecap="round" stroke-linejoin="round" class="feather feather-trending-up"><polyline points="23 6 13.5 15.5 8.5 10.5 1 18"></polyline><polyline points="17 6 23 6 23 12"></polyline></svg></span></td>';
            row += '</tr>';
            $('#tbodyDashBoard').append(row);
        }
    }


}