
/**
 * java script -employee
 *
 * @author  Sampath Perera
 * @since   2020-11-06
 */

/**
* chooseFile
* This function is used to open filechooser dialog.
* @param elemId This is the paramter to identify filechoose tag name
*/
function chooseFile(elemId) {
    var elem = document.getElementById(elemId);
    if (elem && document.createEvent) {
        var evt = document.createEvent("MouseEvents");
        evt.initEvent("click", true, false);
        elem.dispatchEvent(evt);
    }
}


/**
* JQuery
* This is used to call tags event
*/
$(document).ready(function () {
    $('#myTable').DataTable();
    $('#btnResetEmployee').hide();
    $('#chekcontactExpireOn').hide();
    $('#lblcontactExpireOn').hide();
    $('#dateExpireOn').hide();
    $('#pills-attachment-tab').hide();


    /**
    * datepicker
    * This is jquery foe datepicker .
    */
    $('input[name="dteDateOfBorth"]').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        autoUpdateInput: false
    }).on('apply.daterangepicker', function (ev, picker) {
        $(this).val(picker.startDate.format('YYYY-MM-DD'));
        pansionDate($(this).val());
    });

    /**
  * datepicker
  * This is jquery for datepicker .
  */
    $('input[name="dteResign"]').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        autoUpdateInput: false
    }).on('apply.daterangepicker', function (ev, picker) {
        $(this).val(picker.startDate.format('YYYY-MM-DD'));
    });

    /**
    * datepicker
    * This is jquery foe datepicker .
    */
    $('input[name="dteDateOfJoined"]').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        autoUpdateInput: false
    }).on('apply.daterangepicker', function (ev, picker) {
        $(this).val(picker.startDate.format('YYYY-MM-DD'));
    });


    /**
    * datepicker
    * This is jquery for datepicker .
    */
    $('input[name="dteContractExpire"]').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        autoUpdateInput: false
    }).on('apply.daterangepicker', function (ev, picker) {
        $(this).val(picker.startDate.format('YYYY-MM-DD'));
    });




    /**
    * datepicker
    * This is jquery for datepicker .
    */
    $('input[name="txtEpfEtfDate"]').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        autoUpdateInput: false
    }).on('apply.daterangepicker', function (ev, picker) {
        $(this).val(picker.startDate.format('YYYY-MM-DD'));
    });





    //Toast library for message
    toastr.options = {
        timeOut: 3000,
        progressBar: true,
        showMethod: "slideDown",
        hideMethod: "slideUp",
        showDuration: 200,
        hideDuration: 200
    };
    ////////////



    allSettings();//when call this function, all settings auto load



    /**
    * imgTag
    * This function is used to set image to img tag.
    */
    document.getElementById('imgFile').onchange = function (evt) {
        var tgt = evt.target || window.event.srcElement,
            files = tgt.files;
        // FileReader support
        var image = document.getElementById('imgEmployee');
        image.src = URL.createObjectURL(evt.target.files[0]);

    }


    /**
    * imgTag
    * This function is used to set image to img tag.
    */
    $('#btnSaveEmployee').click(function (event) {
        event.preventDefault();
        var form = $('#employeeForm').get(0);
        var data = new FormData(form);


        $('#' + isRequiredInputsSave().tab).trigger('click');
        if ($('#btnSaveEmployee').text() == "Save") {

            if (isRequiredInputsSave().isRequired) {
                save(data);
            }


        } else if ($('#btnSaveEmployee').text() == "Update") {
            var id = $('#hidEmployeeID').val();

            if (isRequiredInputsUpdate().isRequired) {
                update2(data);
            }
        }

    });



    /**
    * resetEmployee
    * This function is used to reset form.
    */
    $('#btnResetEmployee').click(function (event) {
        event.preventDefault();
        resetEmployee();
    });


    loadEmployee();//this function used to load employee detailsa and settings, in update and view time


    $('#selcEmployeeStatus').on('change', function () {
        if ($(this).val() == 4) {
            $('#dteResign').prop("disabled", false);
        } else {
            $('#dteResign').prop("disabled", true);
        }
    });



    $('#selecGender').on('change', function () {
        pansionDate($('#dteDateOfBorth').val());
    });


    $('#cmbPayMethod').on('change', function () {
        var pay_id = $(this).val();
        if (pay_id == 1) {

        }
    });
});



/**
* loadEmployee
* This function used to load employee detailsa and settings, in update and view time
*/
function loadEmployee() {

    if (window.location.search.length > 0) {
        $('#btnResetEmployee').show();
        var sPageURL = window.location.search.substring(1);
        var param = sPageURL.split('&');

        if (param.length == 2) {
            $('#btnSaveEmployee').hide();
        } else {
            $('#btnSaveEmployee').show();
        }

        var id = param[0];
        $('#hidEmployeeID').val(id);
        $.ajax({
            type: "GET",
            url: "/hr/employee/employee/" + id,
            processData: false,
            contentType: false,
            cache: false,
            timeout: 800000,
            beforeSend: function () {

            },
            success: function (response) {
                console.log(response);
                if (response.data.success) {


                    var employee_id = response.data.result['employee_id'];
                    $('#txtEmployeeID').val(employee_id);

                    var name_withinitial = response.data.result['name_withinitial'];
                    $('#txtName').val(name_withinitial);

                    var name_sinhala = response.data.result['name_sinhala'];
                    $('#txtNameSinhala').val(name_sinhala);

                    var name_full = response.data.result['name_full'];
                    $('#txtFullName').val(name_full);

                    var callin_name = response.data.result['callin_name'];
                    $('#txtCallinName').val(callin_name);

                    var address = response.data.result['address'];
                    $('#txtEmployeeAddress').val(address);

                    var nic = response.data.result['nic'];
                    $('#txtNic').val(nic);

                    var drvl = response.data.result['drvl'];
                    $('#txtLicen').val(drvl);

                    var birthday = response.data.result['birthday'];
                    $('#dteDateOfBorth').val(birthday);

                    var date_join = response.data.result['date_join'];
                    $('#dteDateOfJoined').val(date_join);

                    var date_resign = response.data.result['resign_date'];
                    $('#dteResign').val(date_resign);

                    var pension_date = response.data.result['pension_date'];
                    $('#txtPensionDate').val(pension_date);

                    var etf_epf_date = response.data.result['etf_epf_date'];
                    $('#txtEpfEtfDate').val(etf_epf_date);

                    var bank_account = response.data.result['bank_account'];
                    $('#txtBankAC').val(bank_account);

                    var passport = response.data.result['passport'];
                    $('#txtParport').val(passport);

                    var email = response.data.result['email'];
                    $('#txtEmail').val(email);

                    var mobile = response.data.result['mobile'];
                    $('#txtMobile').val(mobile);

                    var fixed = response.data.result['fixed'];
                    $('#txtFixed').val(fixed);

                    var gmap = response.data.result['gmap'];
                    $('#txtGmap').val(gmap);

                    var emegency_contact = response.data.result['emegency_contact'];
                    $('#txtEmegencyContact').val(emegency_contact);

                    var emegency_contactno1 = response.data.result['emegency_contactno1'];
                    $('#txtEmegencyContactno1').val(emegency_contactno1);

                    var emegency_contact2 = response.data.result['emegency_contact2'];
                    $('#txtEmegencyContact2').val(emegency_contact2);

                    var emegency_contactno2 = response.data.result['emegency_contactno2'];
                    $('#txtEmegencyContactno2').val(emegency_contactno2);

                    var epf_no = response.data.result['epf_no'];
                    $('#txtEpfNo').val(epf_no);

                    var notes = response.data.result['notes'];
                    $('#txtNotes').val(notes);

                    var photo_parth = response.data.result['photo_parth'];
                    var base_image = new Image();
                    base_image.src = photo_parth;
                    base_image.onerror = function () {
                        photo_parth = '/images/employee.jpg'; // place your error.png image instead
                    };

                    base_image.onload = function () {
                        $('#imgEmployee').attr("src", photo_parth);
                    };

                    var supervisor = response.data.result['supervisor'];
                    $('#auto-comp1').val(supervisor);

                    var supervisor_id = response.data.result['supervisor_id'];
                    $('#supervisor_id').val(supervisor_id);

                    var attendance_id = response.data.result['attendance_id'];
                    $("#txtAttendanceID").val(attendance_id);

                    var sms_alert = response.data.result['sms_alert'];
                    $('#checkSmsAlert').prop('checked', sms_alert);

                    var email_alert = response.data.result['email_alert'];
                    $('#checkEmailAlert').prop('checked', email_alert);

                    var contract = response.data.result['contract'];
                    $('#checkContract').prop('checked', contract);

                    var contract_expire = response.data.result['contract_expire'];
                    $('#dteContractExpire').val(contract_expire);

                    var town_id = response.data.result['town_id'];
                    var civilstatus_id = response.data.result['civilstatus_id'];
                    var designation_id = response.data.result['designation_id'];
                    var team_id = response.data.result['team_id'];
                    var employeetype_id = response.data.result['employeetype_id'];
                    var employeestatus_id = response.data.result['employeestatus_id'];
                    var category_id = response.data.result['category_id'];
                    var site_id = response.data.result['site_id'];
                    var department_id = response.data.result['department_id'];
                    var section_id = response.data.result['section_id'];
                    var subsection_id = response.data.result['subsection_id'];
                    var bank_id = response.data.result['bank_id'];
                    var bankbranch_id = response.data.result['bankbranch_id'];
                    var company_id = response.data.result['company_id'];
                    var gender_id = response.data.result['gender_id'];
                    var moh_division_id = response.data.result['moh_division_id'];
                    var police_station_id = response.data.result['police_station_id'];
                    var gs_division_id = response.data.result['gs_division_id'];
                    var payMethod = response.data.result['pay_method'];

                    //setSelectedOption('selcTown', town_id);
                    setSelectedOption('selcCivilStatus', civilstatus_id);
                    setSelectedOption('selcDesignation', designation_id);
                    setSelectedOption('selcTeam', team_id);
                    setSelectedOption('selcEmployeeType', employeetype_id);
                    setSelectedOption('selcEmployeeStatus', employeestatus_id);
                    setSelectedOption('selcCategory', category_id);
                    setSelectedOption('selcSite', site_id);
                    setSelectedOption('selcDepartment', department_id);
                    setSelectedOption('selcSection', section_id);
                    setSelectedOption('selcSubSection', subsection_id);
                    setSelectedOption('selcBank', bank_id);
                    setSelectedOption('selcBankBranch', bankbranch_id);
                    setSelectedOption('selcCompany', company_id);
                    setSelectedOption('selecGender', gender_id);
                    setSelectedOption('selcMohDivision', moh_division_id);
                    setSelectedOption('selcPolice', police_station_id);
                    setSelectedOption('selcGsDivision', gs_division_id);
                    if (payMethod) {
                        setSelectedOption('cmbPayMethod', payMethod);
                    }
                    $('#btnSaveEmployee').text('Update');
                    $('#pills-attachment-tab').show();

                    loadAttachment(employee_id);

                    if (employeestatus_id == 4) {
                        $('#dteResign').prop("disabled", false);
                    }

                } else {
                    showErrorMessage();
                }
            },
            error: function (error) {
                console.log(error);

            },
            complete: function () {

            }

        });
    }


}








/**
* save
* This function is used to save employee.
* @param data This is the paramter to ajax data
*/
function save(data) {

    $.ajax({
        type: "POST",
        enctype: 'multipart/form-data',
        url: '/hr/employee',
        data: data,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {

                var name = response.data.name;
                var message = response.data.message;
                if (name == "duplicate") {
                    showWarningMessage(message);
                    return;
                }

                showSuccessMessage("Employee has been saved successfully...");
                resetEmployee();

            } else {
                showErrorMessage();
            }


        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {

        }

    });
}

/**
* allSettings
* This function is used to load all settings.
*/
function allSettings() {
    $.ajax({
        type: "GET",
        url: "/hr/employee/settings",
        processData: false,
        contentType: false,
        async: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {
                var result = response.data.result;
                appendSettings(result);
            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {

        }

    });
}


/**
* appendSettings
* This function is used append option to combobox.
* @param collection This is the paramter to combobox elements item
*/
function appendSettings(collection) {

    $('#selcSupervisor').append('<option value="unspecified">Unspecified</option>');
    $('#selcBank').append('<option value="" disabled selected>Select Here</option>');
    $('#selcBankBranch').append('<option value="" disabled selected>Select Here</option>');
    $('#selcTown').append('<option value="" disabled selected>Select Here</option>');
    $('#selcEmployeeType').append('<option value="" disabled selected>Select Here</option>');
    $('#selcEmployeeStatus').append('<option value="" disabled selected>Select Here</option>');
    $('#selcCategory').append('<option value="" disabled selected>Select Here</option>');
    $('#selcSite').append('<option value="" disabled selected>Select Here</option>');
    $('#selcDepartment').append('<option value="" disabled selected>Select Here</option>');
    $('#selcSection').append('<option value="" disabled selected>Select Here</option>');
    $('#selcSubSection').append('<option value="" disabled selected>Select Here</option>');
    $('#selcCivilStatus').append('<option value="" disabled selected>Select Here</option>');
    $('#selcDesignation').append('<option value="" disabled selected>Select Here</option>');
    $('#selcTeam').append('<option value="0" disabled selected>Not Applicable</option>');
    $('#selcCompany').append('<option value="" disabled selected>Select Here</option>');
    $('#selcMohDivision').append('<option value="" disabled selected>Select Here</option>');
    $('#selcPolice').append('<option value="" disabled selected>Select Here</option>');
    $('#selcGsDivision').append('<option value="" disabled selected>Select Here</option>');

    $.each(collection['Bank'], function (index, value) {
        $('#selcBank').append('<option value="' + value['bank_id'] + '">' + value['bank_name'] + '</option>');
    });
    $.each(collection['BankBranch'], function (index, value) {
        $('#selcBankBranch').append('<option value="' + value['bank_branch_id'] + '">' + value['bank_branch_name'] + '</option>');
    });
    $.each(collection['Town'], function (index, value) {
        $('#selcTown').append('<option value="' + value['town_id'] + '">' + value['town'] + '</option>');
    });
    $.each(collection['EmployeeType'], function (index, value) {
        $('#selcEmployeeType').append('<option value="' + value['employeetype_id'] + '">' + value['employeetype'] + '</option>');
    });
    $.each(collection['EmployeeStatus'], function (index, value) {
        $('#selcEmployeeStatus').append('<option value="' + value['employeestatus_id'] + '">' + value['employeestatus'] + '</option>');
    });
    $.each(collection['Category'], function (index, value) {
        $('#selcCategory').append('<option value="' + value['category_id'] + '">' + value['category'] + '</option>');
    });
    $.each(collection['Site'], function (index, value) {
        $('#selcSite').append('<option value="' + value['site_id'] + '">' + value['site'] + '</option>');
    });
    $.each(collection['Department'], function (index, value) {
        $('#selcDepartment').append('<option value="' + value['department_id'] + '">' + value['department'] + '</option>');
    });
    $.each(collection['Section'], function (index, value) {
        $('#selcSection').append('<option value="' + value['section_id'] + '">' + value['section'] + '</option>');
    });
    $.each(collection['SubSection'], function (index, value) {
        $('#selcSubSection').append('<option value="' + value['subsection_id'] + '">' + value['subsection'] + '</option>');
    });
    $.each(collection['CivilStatus'], function (index, value) {
        $('#selcCivilStatus').append('<option value="' + value['civilstatus_id'] + '">' + value['civilstatus'] + '</option>');
    });
    $.each(collection['Designation'], function (index, value) {
        $('#selcDesignation').append('<option value="' + value['designation_id'] + '">' + value['designation'] + '</option>');
    });
    $.each(collection['Team'], function (index, value) {
        $('#selcTeam').append('<option value="' + value['team_id'] + '">' + value['team_name'] + '</option>');
    });

    var supervisor_arr = [];
    supervisor_arr.push({ "img": "", "id": "Unspecified", "value": "Unspecified" });
    $.each(collection['Supervisor'], function (index, value) {
        supervisor_arr.push({ "img": value['photo_parth'], "id": value['employee_id'], "value": value['name_withinitial'] });
    });

    $("#auto-comp1").setData(supervisor_arr);

    $.each(collection['Company'], function (index, value) {
        $('#selcCompany').append('<option value="' + value['company_id'] + '">' + value['company'] + '</option>');

    });

    $.each(collection['MohDivision'], function (index, value) {
        $('#selcMohDivision').append('<option value="' + value['moh_division_id'] + '">' + value['moh_division'] + '</option>');

    });

    $.each(collection['Police'], function (index, value) {
        $('#selcPolice').append('<option value="' + value['police_station_id'] + '">' + value['police_station'] + '</option>');

    });

    $.each(collection['GsDivision'], function (index, value) {
        $('#selcGsDivision').append('<option value="' + value['gs_division_id'] + '">' + value['gs_division'] + '</option>');

    });



}



/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {
    toastr.success(message);
}


/**
* showWarningMessage
* This function is used to show warning message.
* @param message This is the paramter to require message content
*/
function showWarningMessage(message) {
    toastr.warning(message);
}



/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}


/**
* bankBranch
* This function is used to select the bank branches.this will execute select the bank
*/
function bankBranch() {
    //alert('bank branch');
    var bank_id = $('#selcBank').val();
    $.ajax({
        type: "GET",
        url: "/hr/employee/bank/branch/" + bank_id,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {

                var branchArray = response.data.result;
                $('#selcBankBranch').empty();
                //$('#selcBankBranch').append(' <option value="" disabled selected>Select Bank Branch</option>');

                $.each(branchArray, function (index, value) {
                    $('#selcBankBranch').append('<option value="' + value['bankbranch_id'] + '">' + value['bankbranch'] + '</option>');
                });

            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {

        }

    });
}







/**
* subSection
* This function is used to select the sub section.this will execute select the section
*/
function subSection() {

    var section_id = $('#selcSection').val();
    $.ajax({
        type: "GET",
        url: "/hr/employee/section/subsection/" + section_id,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {

                var subSectionhArray = response.data.result;
                $('#selcSubSection').empty();

                $.each(subSectionhArray, function (index, value) {
                    $('#selcSubSection').append('<option value="' + value['subsection_id'] + '">' + value['subsection'] + '</option>');
                });



            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {

        }

    });
}




/**
* update
* This function is used to update employee.
* @param data This is the paramter to ajax data
*/
function update2(data) {

    $.ajax({
        type: "POST",
        enctype: 'multipart/form-data',
        url: '/hr/employee/update',
        data: data,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {

                showSuccessMessage("Employee has been updated successfully...");
                location.href = "/hr/employeeList";
            } else {
                showErrorMessage();
            }


        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {
            //location.href = "/hr/employeeList";
        }

    });
}



/**
* resetEmployee
* This function is used to reset form.
*/
function resetEmployee() {
    $('#employeeForm').trigger("reset");
    $('#btnResetEmployee').hide();
    $('#btnSaveEmployee').text('Save');
    $("#imgEmployee").attr("src", "/images/employee.jpg");
    $("#pills-general-tab").click();
    if (create_permission == 1) {
        $('#btnSaveEmployee').show();
    } else {
        $('#btnSaveEmployee').hide();
    }

}



function setSelectedOption(id, valueToSelect) {
    let element = document.getElementById(id);
    element.value = valueToSelect;
}


function autoCompleteOnChange() {
    var employee_id = $('#auto-comp1').optionID();
    $('#supervisor_id').attr('value', employee_id);
}

function autoCompleteSelectedOption(parent, args) {

}






function loadAttachment(id) {
    //resetAttachment();

    $.ajax({
        type: "GET",
        url: "/hr/attachment/allFiles/" + id,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                var data = [];
                for (i = 0; i < response.data.result.length; i++) {
                    var title = response.data.result[i]['file_path'];
                    var id = response.data.result[i]['id'];
                    var file = "'" + title + "'";
                    var string_id = "'" + id + "'";
                    data.push({
                        "thTitle": title,
                        "thView": '<button type="button" class="btn btn-success" onclick="viewAttachment(' + file + ')"><i class="fa fa-eye" aria-hidden="true"></i></button>',
                        "thDownload": '<button type="button"  class="btn btn-primary" onclick="downloadAttachment(' + file + ')"><i class="fa fa-download" aria-hidden="true"></i></button>',
                        "thDelete": '<button type="button"  class="btn btn-danger" onclick="attachmentDelete(' + string_id + ')"><i class="fa fa-trash" aria-hidden="true"></i></button>',
                    });
                }

                $('#myTable').DataTable({
                    destroy: true,
                    responsive: false,
                    "order": [],
                    "data": data,
                    "columns": [
                        { "data": "thTitle" },
                        { "data": "thView" },
                        { "data": "thDownload" },
                        { "data": "thDelete" },
                    ],
                    columnDefs: [
                        { width: 20, targets: 1 },
                        { width: 20, targets: 2 },
                        { width: 20, targets: 3 }
                    ],
                });
            } else {

            }

        },
        error: function (error) {
            console.log(error);

        },
        complete: function () {

        }
    });

}








function viewAttachment(file) {

    window.open('/employee/' + file);

}


function downloadAttachment(file) {

    var link = document.createElement("a");
    link.download = file;
    link.href = "/employee/" + file;
    document.body.appendChild(link);
    link.click();
    document.body.removeChild(link);
    delete link;

}

function attachmentDelete(attachment_id) {

    $.ajax({
        type: "GET",
        url: "/hr/attachment/delete/" + attachment_id,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                showSuccessMessage("Attachment has been deleted successfully...");
                loadAttachment($('#hidEmployeeID').val());
            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error);

        },
        complete: function () {

        }
    });
}



function pansionDate(date_of_birth) {

    var gender = $('#selecGender').val();
    if (gender != null) {
        $.ajax({
            type: "GET",
            url: "/hr/employee/pensionDate/" + date_of_birth + "/" + gender,
            processData: false,
            contentType: false,
            cache: false,
            timeout: 800000,
            beforeSend: function () {

            },
            success: function (response) {
                console.log(response);
                $('#txtPensionDate').val(response);

            },
            error: function (error) {
                console.log(error);

            },
            complete: function () {

            }
        });
    }

}



