
var supervisor_id = null;
var employee_id = null;
var schedule_id = null;

$(document).ready(function () {
    $('#tblEmployeeSupervisor').DataTable({
        "scrollX": true,
        "order": [],
        "columns": [
            { "data": "employee_id" },
            { "data": "name" },
            { "data": "category" },
            { "data": "site" },
            { "data": "department" },
            { "data": "section" },
            { "data": "subsection" },
            { "data": "set", className: "set" },
        ],
        columnDefs: [
            { width: 100, targets: 0 },
            { width: 50, targets: 7 },
        ],
    });


    $('#tblEmployeeSchedule').DataTable({
        "scrollX": true,
        "order": [],
        "columns": [
            { "data": "employee_id" },
            { "data": "name" },
            { "data": "shift" },
            { "data": "date" },
            { "data": "intime" },
            { "data": "outtime" },
            { "data": "edit", className: "edit" },
            { "data": "remove", className: "remove" },
        ],
        columnDefs: [
            { width: 100, targets: 0 },
            { width: 50, targets: 3 },
            { width: 50, targets: 4 },
            { width: 50, targets: 5 },
            { width: 50, targets: 6 },
            { width: 50, targets: 7 },
        ],
    });

    loadEmployee_ID();
    loadEmployee_Name();
    getAllShift();
    getServerDate();
});


$(document).ready(function () {
    /**
     * datepicker
     * This is jquery foe datepicker .
     */

    $('input[name="date"]').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        autoUpdateInput: false,
    }).on('apply.daterangepicker', function (ev, picker) {
        $(this).val(picker.startDate.format('YYYY-MM-DD'));
        getAllEmployeesBySupervisor(supervisor_id);
    });




    $('.clockpicker-example').clockpicker({
        autoclose: true,
        use24hours: true,
    });



    $('#btnSetting').click(function () {
        var event = $(this).text();

        if (event == "Save") {
            applyShift();
        } else if (event == "Update") {
            updateShift();
        }

    });


    $('#pills-contact-tab').on('click', function () {
        var supervisor_id = $('#auto-comp2').optionID();
        clearCalander();
        createScheduleCalendarBySupervisor(supervisor_id);
    });



});




var start = moment().subtract(29, 'days');
var end = moment();

function cb(start, end) {
    $('#dashboard-daterangepicker span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
    var start_date = new Date(start);
    var end_date = new Date(end);

    var str_start = start_date.getFullYear() + "-" + (start_date.getMonth() + 1) + "-" + start_date.getDate();
    var str_end = end_date.getFullYear() + "-" + (end_date.getMonth() + 1) + "-" + end_date.getDate();


    clearCalander();
    createScheduleCalendarDateRange(employee_id, str_start, str_end);

}

$('#dashboard-daterangepicker').daterangepicker({
    startDate: start,
    endDate: end,
    opens: $('body').hasClass('rtl') ? 'right' : 'left',
    ranges: {
        'Today': [moment(), moment()],
        'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
        'Last 7 Days': [moment().subtract(6, 'days'), moment()],
        'Last 30 Days': [moment().subtract(29, 'days'), moment()],
        'This Month': [moment().startOf('month'), moment().endOf('month')],
        'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
    }
}, cb);

cb(start, end);



function getServerDate() {


    $.ajax({
        type: "GET",
        url: '/hr/attendanceEmployeeScheduleSupervisor/getServerDate',
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            $('#txtDate').val(response);

        },
        error: function (error) {
            console.log(error);
            //showErrorMessage();
        },
        complete: function () {

        }

    });
}



/**
* loadEmployee_ID
* This function is used to load allemplyee id 
*/
function loadEmployee_ID() {


    $.ajax({
        type: "GET",
        url: '/hr/attendanceEmployeeScheduleSupervisor/allEmployeeId',
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {

                $("#auto-comp1").setData(response.data.result);


            } else {

            }

        },
        error: function (error) {
            console.log(error);
            //showErrorMessage();
        },
        complete: function () {

        }

    });
}




/**
* loadEmployee_Name
* This function is used to load allemplyee name 
*/
function loadEmployee_Name() {


    $.ajax({
        type: "GET",
        url: '/hr/attendanceEmployeeScheduleSupervisor/allEmployeeName',
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {

                $("#auto-comp2").setData(response.data.result);
                //$("#auto-comp3").setData(response.data.result);

            } else {

            }

        },
        error: function (error) {
            console.log(error);
            //showErrorMessage();
        },
        complete: function () {

        }

    });
}





//This function is override from autocomplete.min.js
function autoCompleteSelectedOption(input, data) {
    progress(true);
    supervisor_id = data.id;
    loadEmployee(data.id);
    getAllEmployeesBySupervisor(data.id);
    loadEmployeeSchedule(data.id);
    clearCalander();
    createScheduleCalendarBySupervisor(supervisor_id);

}




function loadEmployee(employee_id) {

    $.ajax({
        type: "GET",
        url: '/hr/attendanceEmployeeScheduleSupervisor/employee/' + employee_id,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {

                var employee = response.data.result;
                $('#imgEmployee').attr("src", employee.photo_parth);
                $('#employee_id').val(employee.employee_id);
                $('#auto-comp1').val(employee.employee_id);
                $('#auto-comp2').val(employee.name_withinitial);

            } else {

            }

        },
        error: function (error) {
            console.log(error);
            //showErrorMessage();
        },
        complete: function () {

        }

    });
}




function getAllEmployeesBySupervisor(id) {


    $.ajax({
        type: "GET",
        url: '/hr/attendanceEmployeeScheduleSupervisor/allEmployee/' + id,
        data: { "date": $('#txtDate').val() },
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {

                appendTableRow_Employee(response.data.result);

            } else {

            }

        },
        error: function (error) {
            console.log(error);
            //showErrorMessage();
        },
        complete: function () {
            progress(false);
        }

    });
}










function appendTableRow_Employee(result) {

    var data = [];
    for (i = 0; i < result.length; i++) {
        emp_id = result[i]['employee_id'];
        var name = result[i]['name_withinitial'];
        var category = result[i]['category'];
        var site = result[i]['site'];
        var department = result[i]['department'];
        var section = result[i]['section'];
        var subsection = result[i]['subsection'];
        //var company = result[i]['company'];
        var string_id = "'" + emp_id + "'";


        data.push({
            "employee_id": emp_id,
            "name": name,
            "category": category,
            "site": site,
            "department": department,
            "section": section,
            "subsection": subsection,
            "set": '<button class="btn btn-primary" onclick="showModal(' + string_id + ')">Set</button>',
        });
    }

    var table = $('#tblEmployeeSupervisor').DataTable();
    table.clear();
    table.rows.add(data).draw();
    table.columns('.set').visible(false);



    if (set_permission == 1) {
        table.columns('.set').visible(true);
    }

}












function appendTableRow_employeeSchedule(result) {

    var data = [];
    for (i = 0; i < result.length; i++) {
        var id = result[i]['schedule_id'];
        employee_id = result[i]['employee_id'];
        var name = result[i]['name_withinitial'];
        var shift = result[i]['shift_name'];
        var date = result[i]['schedule_date_from'];
        var intime = result[i]['in_time'];
        var outtime = result[i]['out_time'];
        var string_id = "'" + employee_id + "'";
        var string_date = "'" + date + "'";

        data.push({
            "employee_id": employee_id,
            "name": name,
            "shift": shift,
            "date": date,
            "intime": intime,
            "outtime": outtime,
            "edit": '<button class="btn btn-primary" onclick="edit(' + string_id + ',' + string_date + ')"><i class="fa fa-pencil-square-o" aria-hidden="true"></i></button>',
            "remove": '<button class="btn btn-danger" onclick="removeShift(' + id + ')">Remove</button>',
        });
    }

    var table = $('#tblEmployeeSchedule').DataTable();
    table.clear();
    table.rows.add(data).draw();
    table.columns('.edit').visible(false);
    table.columns('.remove').visible(false);


    if (edit_permission == 1) {
        table.columns('.edit').visible(true);
    }

    if (remove_permission == 1) {
        table.columns('.remove').visible(true);
    }

}









function getAllShift() {


    $.ajax({
        type: "GET",
        url: '/hr/attendanceEmployeeScheduleSupervisor/allShift',
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {

                appendOption('cmbShift', response.data.result);

            } else {

            }

        },
        error: function (error) {
            console.log(error);
            //showErrorMessage();
        },
        complete: function () {

        }

    });
}






function getShift(id, date) {

    $.ajax({
        type: "GET",
        url: '/hr/attendanceEmployeeScheduleSupervisor/getEmployeeShift/' + id,
        data: { "date": date },
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {

                var shift = response.data.result;
                schedule_id = shift.schedule_id;
                resetModal();
                setSelectedOption('cmbShift', shift.shift_id);
                $('#txtIntime').val(shift.in_time);
                $('#txtOuttime').val(shift.out_time);
                $('#txtFromDate').val(shift.schedule_date_from);
                $('#txtToDate').val(shift.schedule_date_from);
                $('#txtRemark').val(shift.remark);
                $('#btnSetting').text('Update');
                $("#scheduleAddModal").modal('toggle');


            } else {

            }

        },
        error: function (error) {
            console.log(error);
            //showErrorMessage();
        },
        complete: function () {

        }

    });
}





//auto set in time and out time when select the shift
$('#cmbShift').change(function (event) {


    if (event.target.value == "") {
        return;
    }
    $.ajax({
        type: "GET",
        url: "/hr/attendanceEmployeeScheduleSupervisor/getShiftIntimeOutTime/" + event.target.value,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {
                var shift = response.data.result;
                $('#txtIntime').val(shift.intime);
                $('#txtOuttime').val(shift.outtime);

            } else {
                showErrorMessage();
            }
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {

        }

    });
});



function appendOption(combobox, result) {

    $('#' + combobox).empty();
    $('#' + combobox).append('<option value="disabled" disabled selected>Select here</option>');
    for (i = 0; i < result.length; i++) {
        $('#' + combobox).append('<option value="' + result[i].id + '">' + result[i].value + '</option>');
    }
}




function showModal(id) {
    employee_id = id;
    resetModal();
    var date = $('#txtDate').val();
    $('#txtFromDate').val(date);
    $('#txtToDate').val(date);
    $('#btnSetting').text('Save');
    $("#scheduleAddModal").modal('toggle');
}




function edit(id, date) {
    employee_id = id;
    getShift(id, date);
}




function applyShift() {

    var shift_id = $('#cmbShift').val();
    var start_date = new Date($('#txtFromDate').val()).toISOString().slice(0, 10);
    var end_date = new Date($('#txtToDate').val()).toISOString().slice(0, 10);
    var remark = $('#txtRemark').val();
    var _token = $("input[name='_token']").val();

    var data = new FormData();
    data.append("shift_id", shift_id);
    data.append("employee_id", employee_id);
    data.append("start_date", start_date);
    data.append("end_date", end_date);
    data.append("remark", remark);
    data.append("_token", _token);

    $.ajax({
        type: "POST",
        url: '/hr/attendanceEmployeeScheduleSupervisor/applySchedule',
        data: data,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {

                showSuccessMessage("Employee has been saved successfully...");
                getAllEmployeesBySupervisor(supervisor_id);
                loadEmployeeSchedule(supervisor_id);
                $("#scheduleAddModal").modal('hide');

            } else {
                showErrorMessage();
            }


        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {

        }

    });


}







function updateShift() {

    var shift = $('#cmbShift').val();
    var intime = $('#txtIntime').val();
    var outtime = $('#txtOuttime').val();
    var fromDate = $('#txtFromDate').val();
    var toDate = $('#txtToDate').val();
    var remark = $('#txtRemark').val();


    var _token = $("input[name='_token']").val();


    $.ajax({
        type: 'PUT',
        url: '/hr/attendanceEmployeeScheduleSupervisor/updateShift/' + schedule_id,
        data: {
            "shift": shift,
            "intime": intime,
            "outtime": outtime,
            "fromDate": fromDate,
            "toDate": toDate,
            "remark": remark,
            "employee": employee_id,
            "_token": _token,
        },
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {
                showSuccessMessage("Schedule has been updated successfully...");
                getAllEmployeesBySupervisor(supervisor_id);
                loadEmployeeSchedule(supervisor_id);
                $("#scheduleAddModal").modal('hide');

            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error.message);
            showErrorMessage();
        },
        complete: function () {

        }

    });
}





/** Test */
function loadEmployeeSchedule(id) {


    $.ajax({
        type: "GET",
        url: '/hr/attendanceEmployeeScheduleSupervisor/allEmployeeSchedule/' + id,
        data: {
            "dateFrom": '2021-01-01',
        },
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {

                appendTableRow_employeeSchedule(response.data.result);

            } else {

            }

        },
        error: function (error) {
            console.log(error);
            //showErrorMessage();
        },
        complete: function () {
            progress(false);
        }

    });
}







/** End Test */
function removeShift(id) {


    $.ajax({
        type: 'DELETE',
        url: '/hr/attendanceEmployeeScheduleSupervisor/removeShift/' + id,
        data: {
            _token: $('input[name=_token]').val()
        },
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {

                showSuccessMessage("Shift has been deleted successfully...");
                getAllEmployeesBySupervisor(supervisor_id);
                loadEmployeeSchedule(supervisor_id);

            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }
    });
}







function setSelectedOption(id, valueToSelect) {
    let element = document.getElementById(id);
    element.value = valueToSelect;
}




function resetModal() {
    var date = getServerDate();
    setSelectedOption('cmbShift', 'disabled');
    //$('#txtIntime').val(shift.in_time);
    //$('#txtOuttime').val(shift.out_time);
    $('#txtFromDate').val(date);
    $('#txtToDate').val(date);
    $('#txtRemark').val('');
    $('#btnSetting').text('Save');
}






function createScheduleCalendarBySupervisor(id) {

    $.ajax({
        type: "GET",
        url: '/hr/attendanceEmployeeScheduleSupervisor/supervisorSchedule/' + id,
        processData: false,
        contentType: false,
        async: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {

                createScheduleCalendar(response.data.result);
                getHolidays();

            } else {

            }

        },
        error: function (error) {
            console.log(error);
            //showErrorMessage();
        },
        complete: function () {

        }

    });
}






function createScheduleCalendarDateRange(employee_id, start, end) {

    $.ajax({
        type: "GET",
        url: '/hr/attendanceEmployeeScheduleSupervisor/supervisorScheduleDateRange/' + employee_id,
        data: {
            "start": start,
            "end": end,
        },
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {

                createScheduleCalendar(response.data.result);
                getHolidays();

            } else {

            }

        },
        error: function (error) {
            console.log(error);
            //showErrorMessage();
        },
        complete: function () {

        }

    });
}





function getHolidays() {

    $.ajax({
        type: "GET",
        url: '/hr/attendanceEmployeeScheduleSupervisor/employeeHolidays',
        processData: false,
        contentType: false,
        async: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {

                createHoliday(response.data.result);

            } else {

            }

        },
        error: function (error) {
            console.log(error);
            //showErrorMessage();
        },
        complete: function () {

        }

    });
}






function createScheduleCalendar(result) {

    var schedule_arr = [];
    if (result.length == 0) {
        return;
    }


    var date = result[0].schedule_date_from;
    var arr = date.split("-");
    var day = 0;
    if (arr.length == 3) {
        day = parseInt(arr[2]);
    }

    var schedule = [];
    for (i = 0; i < result.length; i++) {
        var next_date = result[i].schedule_date_from;
        var next_day = parseInt(next_date.split("-")[2]);
        if (day == next_day) {
            schedule.push({ "shift_id": result[i].shift_id, "shift": result[i].shift_name, "date": result[i].schedule_date_from, "in_time": result[i].in_time, "out_time": result[i].out_time });

        } else {
            schedule_arr.push(schedule);
            day = next_day;
            schedule = [];
            schedule.push({ "shift_id": result[i].shift_id, "shift": result[i].shift_name, "date": result[i].schedule_date_from, "in_time": result[i].in_time, "out_time": result[i].out_time });

        }
        day++;

    }
    schedule_arr.push(schedule);

    for (i = 0; i < schedule_arr.length; i++) {
        var end_date = new Date(schedule_arr[i][schedule_arr[i].length - 1].date);
        end_date.setDate(end_date.getDate() + 1);
        var start = schedule_arr[i][0].date;
        var end = end_date.getFullYear() + "-" + (((end_date.getMonth() + 1) > 9 ? '' : '0') + (end_date.getMonth() + 1)) + "-" + ((end_date.getDate() > 9 ? '' : '0') + end_date.getDate());
        var in_time = schedule_arr[i][0].in_time;
        var out_time = schedule_arr[i][0].out_time;
        var shift_id = schedule_arr[i][0].shift_id;
        addShedule(shift_id, schedule_arr[i][0].shift, start, end, in_time, out_time);
    }
    //console.log(schedule_arr);
    createCalendar();

}








function createHoliday(result) {

    console.log(result);
    if (result.length == 0) {
        return;
    }

    for (i = 0; i < result.length; i++) {
        var date = result[i].holyday_date;
        var holiday = result[i].holyday_type;
        addHoliday('', holiday, date, date, '00:00', '00:00');
    }
    createCalendar();

}





/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {
    toastr.success(message);
}


/**
* showWarningMessage
* This function is used to show warning message.
* @param message This is the paramter to require message content
*/
function showWarningMessage(message) {
    toastr.warning(message);
}



/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}

