@extends('hr::layouts.app')

@section('head')
<!-- Fullcalendar -->
<link rel="stylesheet" href="{{ url('vendors/fullcalendar/fullcalendar.min.css') }}" type="text/css">

<!-- Clockpicker -->
<link rel="stylesheet" href="{{ url('vendors/clockpicker/bootstrap-clockpicker.min.css') }}" type="text/css">

<!-- Datepicker -->
<link rel="stylesheet" href="{{ url('vendors/datepicker/daterangepicker.css') }}" type="text/css">

<!-- AutoComplete -->
<link rel="stylesheet" href="{{ Module::asset('hr:js/autocomplete2/css/autocomplete.min.css') }}" type="text/css">
@endsection

@section('parentClassName', 'web-app')

@section('content')

<div class="page-header">
    <div>
        <h3></h3>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="#">Home</a>
                </li>
                <li class="breadcrumb-item">
                    <a href="#">Pages</a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">Form Page</li>
            </ol>
        </nav>
    </div>
</div>


<div class="row">
    <div class="col-md-12">
        <div class="card ">
            <div class="card-body">
                <div class="row">
                    <div class="col-md-3 app-sidebar">
                        <h3 class="mb-4">Calendar</h3>


                        <div class="row">
                            <div class="col-md-6"></div>
                            <div class="col-md-6">
                                <img class="img img-thumbnail" src="/images/employee.jpg" id="imgEmployee" alt="image/" style="min-height: 130px;max-width:130px">
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <label>Employee ID</label>
                                <input type="text" class="form-control auto-complete" id="auto-comp1">
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <label>Employee Name</label>
                                <input type="text" class="form-control auto-complete" id="auto-comp2">
                            </div>
                        </div>

                        <div>
                            <div class="list-group list-group-flush" id="external-events">
                                <div class="list-group-item fc-event">
                                    <i class="fa fa-circle text-success" data-icon="car"></i> Shift
                                </div>
                                <div class="list-group-item fc-event">
                                    <i class="fa fa-circle text-danger" data-icon="users"></i> Holidays
                                </div>

                            </div>
                        </div>
                        <div class="custom-control custom-checkbox mt-3">
                            <input type="checkbox" class="custom-control-input" id="drop-remove" checked="">
                            <label class="custom-control-label" for="drop-remove">Remove after drop</label>
                        </div>
                    </div>
                    <div class="col-md-9 app-content">
                        <div class="app-content-overlay"></div>
                        <div class="card app-content-body">
                            <div class="card-body">
                               <!-- <a href="#" class="app-sidebar-menu-button btn btn-outline-light mb-3">
                                    <i data-feather="menu"></i>
                                </a>!-->
                                <div class="row">
                                    <div class="col-md-12" style="text-align: right;">
                                        <div id="dashboard-daterangepicker" class="btn btn-outline-light">
                                            <span>Jan, 05, 2021</span>
                                        </div>
                                    </div>
                                </div>
                                <br>
                                <div id="calendar-demo"></div>
                            </div>
                        </div>
                    </div>



                    <!-- begin::Event Info Modal -->
                    <div class="modal fade" id="viewEventModal" tabindex="-1" role="dialog" aria-hidden="true">
                        <div class="modal-dialog" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title">
                                        <span class="event-icon mr-2"></span>
                                        <span class="event-title">Modal Title</span>
                                    </h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <i class="ti-close"></i>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <div class="event-body"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- end::Event Info Modal -->
                </div>

            </div>
        </div>
    </div>
</div>

@endsection

@section('script')

<!-- AutoComplete -->
<script src="{{ Module::asset('hr:js/autocomplete2/js/autocomplete.min.js') }}"></script>

<!-- Fullcalendar -->
<script src="{{ url('vendors/fullcalendar/moment.min.js') }}"></script>
<script src="{{ url('vendors/fullcalendar/fullcalendar.min.js') }}"></script>

<!-- Clockpicker -->
<script src="{{ url('vendors/clockpicker/bootstrap-clockpicker.min.js') }}"></script>
<script src="{{ url('assets/js/examples/clockpicker.js') }}"></script>

<!-- Datepicker -->
<script src="{{ url('vendors/datepicker/daterangepicker.js') }}"></script>
<script src="{{ url('assets/js/examples/datepicker.js') }}"></script>




<script src="{{ Module::asset('hr:js/examples/pages/calendar.js') }}"></script>
<script src="{{ Module::asset('hr:js/calander.js') }}"></script>
<script src="{{ Module::asset('hr:js/attendanceEmployeeSchedule.js') }}"></script>
@endsection
