@extends('hr::layouts.app')

@section('head')
<!-- DataTable -->
<link rel="stylesheet" href="{{ url('vendors/dataTable/datatables.min.css') }}" type="text/css">
<link rel="stylesheet" href="{{ url('vendors/datepicker/daterangepicker.css') }}" type="text/css">
<!-- AutoComplete -->
<link rel="stylesheet" href="{{ Module::asset('hr:js/autocomplete2/css/autocomplete.min.css') }}" type="text/css">
<!-- Prism -->
<link rel="stylesheet" href="{{ url('vendors/prism/prism.css') }}" type="text/css">
<link rel="stylesheet" href="{{ Module::asset('hr:css/hr/employee.css') }}" type="text/css">
<script>
    var create_permission = "{{Auth::user()->can('employee_create')}}";
</script>
<style>
    /*default version*/
    @font-face {
        font-family: 'sinhalaFont';
        src: url('../fonts/FM_Abhaya.TTF');
        src: url('../fonts/FM_Abhaya.TTF') format('embedded-opentype'), url('../fonts/FM_Abhaya.TTF') format('woff'), url('../fonts/FM_Abhaya.TTF') format('truetype'), url('../fonts/FM_Abhaya.TTF') format('svg');
        font-weight: normal;
        font-style: normal;
    }
</style>

@endsection

@section('content')

<div class="page-header">
    <div>
        <h3></h3>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="#">Home</a>
                </li>
                <li class="breadcrumb-item">
                    <a href="#">Pages</a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">Form Page</li>
            </ol>
        </nav>
    </div>
</div>

<div class="row">
    <div class="col-md-12">
        <div class="card ">
            <form method="POST" id="employeeForm" enctype="multipart/form-data">
                {{ csrf_field() }}
                <div class="card-body">
                    <h6 class="card-title">Employee</h6>
                    <ul class="nav nav-pills mb-3" role="tablist" id="navMenuItem">
                        <li class="nav-item">
                            <a class="nav-link active" id="pills-general-tab" data-toggle="pill" href="#tbGeneral" role="tab" aria-controls="pills-general" aria-selected="true">General</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" id="pills-contact-tab" data-toggle="pill" href="#tbContactInfo" role="tab" aria-controls="pills-contact" aria-selected="false">Contact info</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" id="pills-settings-tab" data-toggle="pill" href="#tbSettings" role="tab" aria-controls="pills-settings" aria-selected="false">Settings</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" id="pills-note-tab" data-toggle="pill" href="#tbNotes" role="tab" aria-controls="pills-notes" aria-selected="false">Notes</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" id="pills-attachment-tab" data-toggle="pill" href="#tbAttachment" role="tab" aria-controls="pills-attachment" aria-selected="false">Attachment</a>
                        </li>
                    </ul>
                    <br>


                    <div class="tab-content">
                        <div class="tab-pane fade show active" id="tbGeneral" role="tabpanel" aria-labelledby="pills-general-tab">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-row">
                                        <div class="col-md-12 mb-3">
                                            <i class="fa fa-id-card text-info" aria-hidden="true"></i>
                                            <label for="txtEmployeeID">Employee ID</label>
                                            <input type="hidden" id="hidEmployeeID" name="hidEmployeeID" value="">
                                            <input type="text" class="form-control required-input" autocomplete="off" id="txtEmployeeID" name="txtEmployeeID" placeholder="Employee ID" required="">
                                            <div class="required-feedback">
                                                <i class="fa fa-exclamation-triangle text-danger" aria-hidden="true"></i>
                                                <label class="text-danger">Please enter employee id</label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-row">
                                        <div class="col-md-12 mb-3">
                                            <i class="fa fa-pencil text-info" aria-hidden="true"></i>
                                            <label for="txtName">Name (With initials)</label>
                                            <input type="text" class="form-control required-input" autocomplete="off" id="txtName" name="txtName" placeholder="Name (With initials)">
                                            <div class="required-feedback">
                                                <i class="fa fa-exclamation-triangle text-danger" aria-hidden="true"></i>
                                                <label class="text-danger">Please enter employee name</label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-row">
                                        <div class="col-md-12 mb-3">
                                            <i class="fa fa-pencil text-info" aria-hidden="true"></i>
                                            <label for="txtName">Name (Sinhala)</label>
                                            <input type="text" class="form-control" id="txtNameSinhala" autocomplete="off" name="txtNameSinhala" placeholder="ku ^isxy,&" style="font-family: 'sinhalaFont'; font-size: 18px;">
                                            <!--<div class="required-feedback">
                                                <i class="fa fa-exclamation-triangle text-danger" aria-hidden="true"></i>
                                                <label class="text-danger">Please enter employee name (Sinhala)</label>
                                            </div>-->
                                        </div>
                                    </div>
                                    <div class="form-row">
                                        <div class="col-md-12 mb-3">
                                            <i class="fa fa-pencil text-info" aria-hidden="true"></i>
                                            <label for="txtFullName">Full Name</label>
                                            <input type="text" class="form-control required-input" autocomplete="off" id="txtFullName" name="txtFullName" placeholder="Full Name">
                                            <div class="required-feedback">
                                                <i class="fa fa-exclamation-triangle text-danger" aria-hidden="true"></i>
                                                <label class="text-danger">Please enter employee full name</label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-row">
                                        <div class="col-md-12 mb-3">
                                            <i class="fa fa-pencil text-info" aria-hidden="true"></i>
                                            <label for="txtCallinName">Calling Name</label>
                                            <input type="text" class="form-control required-input" autocomplete="off" id="txtCallinName" name="txtCallinName" placeholder="Callin Name">
                                            <div class="required-feedback">
                                                <i class="fa fa-exclamation-triangle text-danger" aria-hidden="true"></i>
                                                <label class="text-danger">Please enter emergency calling name</label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-row">
                                        <div class="col-md-12">
                                            <div class="form-row">
                                                <div class="col-md-12 mb-3">
                                                    <i class="fa fa-address-book-o text-info" aria-hidden="true"></i>
                                                    <label for="txtEmployeeAddress">Address</label>
                                                    <textarea class="form-control required-input" autocomplete="off" id="txtEmployeeAddress" name="txtEmployeeAddress"></textarea>
                                                    <div class="required-feedback">
                                                        <i class="fa fa-exclamation-triangle text-danger" aria-hidden="true"></i>
                                                        <label class="text-danger">Please enter employee address</label>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-row">
                                        <div class="col-md-12 mb-3">
                                            <i class="fa fa-university text-info" aria-hidden="true"></i>
                                            <label for="txtBankAC">Bank A/C#</label>
                                            <input type="text" class="form-control required-input" autocomplete="off" id="txtBankAC" name="txtBankAC" placeholder="Bank Account">
                                            <div class="required-feedback">
                                                <i class="fa fa-exclamation-triangle text-danger" aria-hidden="true"></i>
                                                <label class="text-danger">Please enter bank account</label>
                                            </div>
                                        </div>
                                        <div class="col-md-12 mb-3">
                                            <i class="fa fa-university text-info" aria-hidden="true"></i>
                                            <label for="selcBank">Bank</label>
                                            <select class="form-control" id="selcBank" name="selcBank" onchange="bankBranch()"></select>
                                            <div class="required-feedback">
                                                <!--<i class="fa fa-exclamation-triangle text-danger" aria-hidden="true"></i>
                                                <label class="text-danger">Please enter bank</label>!-->
                                            </div>
                                        </div>
                                        <div class="col-md-12 mb-3">
                                            <i class="fa fa-university text-info" aria-hidden="true"></i>
                                            <label for="selcBankBranch">Bank Branch</label>
                                            <select class="form-control required-input" id="selcBankBranch" name="selcBankBranch"></select>
                                            <div class="required-feedback">
                                                <i class="fa fa-exclamation-triangle text-danger" aria-hidden="true"></i>
                                                <label class="text-danger">Please enter bank branch</label>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-row">
                                        <div class="col-md-12 mb-3">
                                            <i class="fa fa-street-view text-info" aria-hidden="true"></i>
                                            <label for="validationCustom01">MOH Division</label>
                                            <select class="form-control required-input" id="selcMohDivision" name="selcMohDivision"></select>
                                            <div class="required-feedback">
                                                <i class="fa fa-exclamation-triangle text-danger" aria-hidden="true"></i>
                                                <label class="text-danger">Please enter moh division</label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-row">
                                        <div class="col-md-12 mb-3">
                                            <i class="fa fa-street-view text-info" aria-hidden="true"></i>
                                            <label for="validationCustom01">Police Station</label>
                                            <select class="form-control required-input" id="selcPolice" name="selcPolice"></select>
                                            <div class="required-feedback">
                                                <i class="fa fa-exclamation-triangle text-danger" aria-hidden="true"></i>
                                                <label class="text-danger">Please enter police station</label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-row">
                                        <div class="col-md-12 mb-3">
                                            <i class="fa fa-street-view text-info" aria-hidden="true"></i>
                                            <label for="validationCustom01">GS Division</label>
                                            <select class="form-control required-input" id="selcGsDivision" name="selcGsDivision"></select>
                                            <div class="required-feedback">
                                                <i class="fa fa-exclamation-triangle text-danger" aria-hidden="true"></i>
                                                <label class="text-danger">Please enter gs division</label>
                                            </div>
                                        </div>
                                    </div>

                                </div>

                                <div class="col-md-6">
                                    <div class="col-md-6 mb-3">
                                        <div class="col-md-6 mb-1">
                                            <input type="file" class="form-control imgFile required-file" id="imgFile" name="imgFile" accept="image/*">
                                        </div>
                                        <div class="imgContainer">
                                            <img class="img img-thumbnail" src="/images/employee.jpg" id="imgEmployee" width="160" height="160" alt="image/">
                                            <button type="button" class="btn btn-link" id="btnChooser" onclick="chooseFile('imgFile');"><i class="fa fa-folder-open" aria-hidden="true"></i></button>
                                            <div class="required-file-feedback" id="required-file-feedback">
                                                <i class="fa fa-exclamation-triangle text-danger" aria-hidden="true"></i>
                                                <label class="text-danger">Please choose employee image</label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="container">
                                        <div class="row">
                                            <div class="col-md-6 mb-3">
                                                <i class="fa fa-id-card-o text-info" aria-hidden="true"></i>
                                                <label for="validationCustom01">Nic#</label>
                                                <input type="text" class="form-control required-input" autocomplete="off" id="txtNic" name="txtNic" placeholder="Nic">
                                                <div class="required-feedback">
                                                    <i class="fa fa-exclamation-triangle text-danger" aria-hidden="true"></i>
                                                    <label class="text-danger">Please enter employee nic</label>
                                                </div>
                                            </div>
                                            <div class="col-md-6 mb-3">

                                            </div>
                                        </div>

                                        <div class="row">
                                            <div class="col-md-6 mb-3">
                                                <i class="fa fa-plane text-info" aria-hidden="true"></i>
                                                <label for="validationCustom01">Passport#</label>
                                                <input type="text" class="form-control" autocomplete="off" id="txtParport" name="txtParport" placeholder="Passport">
                                                <div class="valid-feedback">
                                                    Looks good!
                                                </div>
                                            </div>
                                            <div class="col-md-6 mb-3">
                                                <i class="fa fa-id-card text-info" aria-hidden="true"></i>
                                                <label for="validationCustom01">Driving Lic#</label>
                                                <input type="text" class="form-control" autocomplete="off" id="txtLicen" name="txtLicen" placeholder="Driving Lic">
                                                <div class="valid-feedback">
                                                    Looks good!
                                                </div>
                                            </div>
                                        </div>


                                        <div class="row">
                                            <div class="col-md-6 mb-3">
                                                <i class="fa fa-calendar text-info" aria-hidden="true"></i>
                                                <label for="validationCustom01">Date Of Birth</label>
                                                <input type="text" name="dteDateOfBorth" autocomplete="off" class="form-control required-input" id="dteDateOfBorth" placeholder="YYYY-MM-DD">
                                                <div class="required-feedback">
                                                    <i class="fa fa-exclamation-triangle text-danger" aria-hidden="true"></i>
                                                    <label class="text-danger">Please enter employee dob</label>
                                                </div>
                                            </div>
                                            <div class="col-md-6 mb-3">
                                                <i class="fa fa-calendar text-info" aria-hidden="true"></i>
                                                <label for="validationCustom01">Date Of Joined</label>
                                                <input type="text" name="dteDateOfJoined" autocomplete="off" class="form-control required-input" id="dteDateOfJoined" placeholder="YYYY-MM-DD">
                                                <div class="required-feedback">
                                                    <i class="fa fa-exclamation-triangle text-danger" aria-hidden="true"></i>
                                                    <label class="text-danger">Please enter date of joined</label>
                                                </div>
                                            </div>
                                        </div>


                                        <div class="row">
                                            <div class="col-md-6 mb-3">
                                                <i class="fa fa-genderless text-info" aria-hidden="true"></i>
                                                <label for="validationCustom01">Gender</label>
                                                <select class="form-control required-input" id="selecGender" name="selecGender">
                                                    <option value="" disabled selected>Select Gender</option>
                                                    <option value="0">Female</option>
                                                    <option value="1">Male</option>
                                                </select>
                                                <div class="required-feedback">
                                                    <i class="fa fa-exclamation-triangle text-danger" aria-hidden="true"></i>
                                                    <label class="text-danger">Please select gender</label>
                                                </div>
                                            </div>
                                            <div class="col-md-6 mb-3">
                                                <i class="fa fa-user-o text-info" aria-hidden="true"></i>
                                                <label for="validationCustom01">Civil Status</label>
                                                <select class="form-control required-input" id="selcCivilStatus" name="selcCivilStatus"></select>
                                                <div class="required-feedback">
                                                    <i class="fa fa-exclamation-triangle text-danger" aria-hidden="true"></i>
                                                    <label class="text-danger">Please select civil status</label>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="row">
                                            <div class="col-md-6 mb-3">
                                                <i class="fa fa-calendar text-info" aria-hidden="true"></i>
                                                <label for="validationCustom01">Pension Date#</label>
                                                <input type="text" class="form-control required-input" autocomplete="off" id="txtPensionDate" name="txtPensionDate" placeholder="Pension Date" readonly>
                                                <div class="required-feedback">
                                                    <i class="fa fa-exclamation-triangle text-danger" aria-hidden="true"></i>
                                                    <label class="text-danger">Please enter pension date</label>
                                                </div>
                                            </div>
                                            <div class="col-md-6 mb-3">
                                                <i class="fa fa-calendar text-info" aria-hidden="true"></i>
                                                <label for="validationCustom01">ETF/EPF Register date#</label>
                                                <input type="text" class="form-control" autocomplete="off" id="txtEpfEtfDate" name="txtEpfEtfDate">
                                                <!--<div class="required-feedback">
                                                    <i class="fa fa-exclamation-triangle text-danger" aria-hidden="true"></i>
                                                    <label class="text-danger">Please enter etf / epf register date</label>
                                                </div>!-->
                                            </div>
                                        </div>

                                    </div>
                                    <div class="col-md-12">
                                        <i class="fa fa-user-o text-info" aria-hidden="true"></i>
                                        <label for="validationCustom01">Designation</label>
                                        <select class="form-control required-input" id="selcDesignation" name="selcDesignation"></select>
                                        <div class="required-feedback">
                                            <i class="fa fa-exclamation-triangle text-danger" aria-hidden="true"></i>
                                            <label class="text-danger">Please select designation</label>
                                        </div>
                                    </div>
                                    <br>
                                    <div class="col-md-12">
                                        <i class="fa fa-user-o text-info" aria-hidden="true"></i>
                                        <label for="validationCustom01">Team</label>
                                        <select class="form-control required-input" id="selcTeam" name="selcTeam" disabled></select>
                                        <div class="required-feedback">
                                            <i class="fa fa-exclamation-triangle text-danger" aria-hidden="true"></i>
                                            <label class="text-danger">Please select Team</label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="tab-pane fade" id="tbContactInfo" role="tabpanel" aria-labelledby="pills-contact-tab">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-row">
                                        <div class="col-md-12 mb-3">
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <i class="fa fa-envelope text-info" aria-hidden="true"></i>
                                                    <label for="txtEmail">Email</label>
                                                </div>
                                                <div class="col-md-6">
                                                    <input type="checkbox" id="checkEmailAlert" name="checkEmailAlert" class="checkbox"><label id="lblEmailAlert">Email Alert</label>
                                                </div>
                                            </div>
                                            <input type="text" class="form-control" id="txtEmail" name="txtEmail" placeholder="Email">
                                            <div class="valid-feedback">
                                                Looks good!
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-row">
                                        <div class="col-md-12 mb-3">
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <div class="form-row">
                                                        <div class="col-md-12 mb-3">
                                                            <i class="fa fa-phone text-info" aria-hidden="true"></i>
                                                            <label for="txtContact2">Fixed Phone #</label>
                                                            <input type="text" class="form-control" autocomplete="off" id="txtFixed" name="txtFixed" placeholder="Contact 2">
                                                            <!--<div class="required-feedback">
                                                                <i class="fa fa-exclamation-triangle text-danger" aria-hidden="true"></i>
                                                                <label class="text-danger">Please enter employee contact</label>
                                                            </div>!-->
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="form-row">
                                                        <div class="col-md-12 mb-3">

                                                            <div class="row">
                                                                <div class="col-md-12">
                                                                    <div class="row">
                                                                        <div class="col-md-6">
                                                                            <i class="fa fa-phone text-info" aria-hidden="true"></i>
                                                                            <label for="txtContact1">Mobile #</label>
                                                                        </div>
                                                                        <div class="col-md-6">
                                                                            <input type="checkbox" class="checkbox" id="checkSmsAlert" name="checkSmsAlert"><label id="lblSmsAlert">SMS Alert</label>
                                                                        </div>
                                                                    </div>

                                                                </div>
                                                            </div>


                                                            <div class="row">
                                                                <div class="col-md-12">
                                                                    <input type="text" class="form-control required-input" autocomplete="off" id="txtMobile" name="txtMobile" placeholder="Contact 1">
                                                                    <input type="date" class="form-control" id="dateExpireOn" name="dateExpireOn">
                                                                    <div class="required-feedback">
                                                                        <i class="fa fa-exclamation-triangle text-danger" aria-hidden="true"></i>
                                                                        <label class="text-danger">Please enter employee mobile</label>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-row">
                                        <div class="col-md-12 mb-3">
                                            <i class="fa fa-map-marker text-info" aria-hidden="true"></i>
                                            <label for="txtGmap">Google Map URL</label>
                                            <input type="text" class="form-control" autocomplete="off" id="txtGmap" name="txtGmap" placeholder="Google Map URL">
                                        </div>
                                    </div>
                                    <br>
                                    <div class="form-row">
                                        <div class="col-md-6">
                                            <div class="row">
                                                <div class="col-md-12 mb-3">
                                                    <i class="fa fa-user-circle-o text-info" aria-hidden="true"></i>
                                                    <label for="txtEmegencyContact">Emergency Contact Persion1</label>
                                                    <input type="text" class="form-control required-input" autocomplete="off" id="txtEmegencyContact" name="txtEmegencyContact" placeholder="Name">
                                                    <div class="required-feedback">
                                                        <i class="fa fa-exclamation-triangle text-danger" aria-hidden="true"></i>
                                                        <label class="text-danger">Please enter emergency contact persion</label>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-md-12 mb-3">
                                                    <div class="form-row">
                                                        <div class="col-md-12 mb-3">
                                                            <i class="fa fa-phone text-info" aria-hidden="true"></i>
                                                            <label for="txtEmegencyContactno1">Contact # 1</label>
                                                            <input type="text" class="form-control required-input" autocomplete="off" id="txtEmegencyContactno1" name="txtEmegencyContactno1" placeholder="Contact 1">
                                                            <div class="required-feedback">
                                                                <i class="fa fa-exclamation-triangle text-danger" aria-hidden="true"></i>
                                                                <label class="text-danger">Please enter emergency contact no</label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="row">
                                                <div class="col-md-12 mb-3">
                                                    <i class="fa fa-user-circle-o text-info" aria-hidden="true"></i>
                                                    <label for="txtEmegencyContact">Emergency Contact Persion2</label>
                                                    <input type="text" class="form-control required-input" autocomplete="off" id="txtEmegencyContact2" name="txtEmegencyContact2" placeholder="Name">
                                                    <div class="required-feedback">
                                                        <i class="fa fa-exclamation-triangle text-danger" aria-hidden="true"></i>
                                                        <label class="text-danger">Please enter emergency contact persion</label>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-md-12 mb-3">
                                                    <div class="form-row">
                                                        <div class="col-md-12 mb-3">
                                                            <i class="fa fa-phone text-info" aria-hidden="true"></i>
                                                            <label for="txtEmegencyContactno2">Contact # 2</label>
                                                            <input type="text" class="form-control required-input" autocomplete="off" id="txtEmegencyContactno2" name="txtEmegencyContactno2" placeholder="Contact 2">
                                                            <div class="required-feedback">
                                                                <i class="fa fa-exclamation-triangle text-danger" aria-hidden="true"></i>
                                                                <label class="text-danger">Please enter emergency contact no</label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="tab-pane fade" id="tbSettings" role="tabpanel" aria-labelledby="pills-settings-tab">
                            <div class="row">
                                <div class="col-md-5">
                                    <div class="form-row">
                                        <div class="col-md-12 mb-3">
                                            <i class="fa fa-id-card text-info" aria-hidden="true"></i>
                                            <label for="txtAttendanceID">Attendance ID</label>
                                            <input type="text" class="form-control required-input" autocomplete="off" id="txtAttendanceID" name="txtAttendanceID" placeholder="Attendance ID">
                                            <div class="required-feedback">
                                                <i class="fa fa-exclamation-triangle text-danger" aria-hidden="true"></i>
                                                <label class="text-danger">Please enter employee attendance id</label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-row">
                                        <div class="col-md-12 mb-3">
                                            <i class="fa fa-id-badge text-info" aria-hidden="true"></i>
                                            <label for="txtEpfNo">EPF No</label>
                                            <input type="text" class="form-control" autocomplete="off" id="txtEpfNo" name="txtEpfNo" placeholder="EPF No">
                                            <!--<div class="required-feedback">
                                                <i class="fa fa-exclamation-triangle text-danger" aria-hidden="true"></i>
                                                <label class="text-danger">Please enter employee epf no</label>
                                            </div>!-->
                                        </div>
                                    </div>
                                    <div class="form-row">
                                        <div class="col-md-12 mb-3">
                                            <i class="fa fa-user-o text-info" aria-hidden="true"></i>
                                            <label for="selcEmployeeType">Employee Type</label>
                                            <select class="form-control required-input" id="selcEmployeeType" name="selcEmployeeType" placeholder="Employee Type"></select>
                                            <div class="required-feedback">
                                                <i class="fa fa-exclamation-triangle text-danger" aria-hidden="true"></i>
                                                <label class="text-danger">Please select employee type</label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-row">
                                        <div class="col-md-12 mb-3">
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <i class="fa fa-user-o text-info" aria-hidden="true"></i>
                                                    <label for="selcEmployeeStatus">Employee Status</label>
                                                    <select class="form-control required-input" id="selcEmployeeStatus" name="selcEmployeeStatus" placeholder="Employee Status"></select>
                                                    <div class="required-feedback">
                                                        <i class="fa fa-exclamation-triangle text-danger" aria-hidden="true"></i>
                                                        <label class="text-danger">Please select employee status</label>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <i class="fa fa-calendar text-info" aria-hidden="true"></i>
                                                    <label for="selcEmployeeStatus">Resign Date</label>
                                                    <input type="text" name="dteResign" class="form-control" autocomplete="off" id="dteResign" placeholder="YYYY-MM-DD" disabled>
                                                    <div class="valid-feedback">
                                                        Looks good!
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-row">
                                        <div class="col-md-12 mb-3">
                                            <i class="fa fa-list text-info" aria-hidden="true"></i>
                                            <label for="txtCategory">Category</label>
                                            <select class="form-control required-input" id="selcCategory" name="selcCategory" placeholder="Category"></select>
                                            <div class="required-feedback">
                                                <i class="fa fa-exclamation-triangle text-danger" aria-hidden="true"></i>
                                                <label class="text-danger">Please select employee category</label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-row">
                                        <div class="col-md-12 mb-3">
                                            <i class="fa fa-sitemap text-info" aria-hidden="true"></i>
                                            <label for="txtSite">Site</label>
                                            <select class="form-control required-input" id="selcSite" name="selcSite" placeholder="Site"></select>
                                            <div class="required-feedback">
                                                <i class="fa fa-exclamation-triangle text-danger" aria-hidden="true"></i>
                                                <label class="text-danger">Please select employee site</label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-5">
                                    <div class="form-row">
                                        <div class="col-md-12 mb-3">
                                            <i class="fa fa-users text-info" aria-hidden="true"></i>
                                            <label for="txtDepartment">Department</label>
                                            <select class="form-control required-input" id="selcDepartment" name="selcDepartment" placeholder="Department"></select>
                                            <div class="required-feedback">
                                                <i class="fa fa-exclamation-triangle text-danger" aria-hidden="true"></i>
                                                <label class="text-danger">Please select employee department</label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-row">
                                        <div class="col-md-12 mb-3">
                                            <i class="fa fa-users text-info" aria-hidden="true"></i>
                                            <label for="txtSection">Section</label>
                                            <select class="form-control required-input" id="selcSection" name="selcSection" placeholder="Section" onchange="subSection()"></select>
                                            <div class="required-feedback">
                                                <i class="fa fa-exclamation-triangle text-danger" aria-hidden="true"></i>
                                                <label class="text-danger">Please select employee section</label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-row">
                                        <div class="col-md-12 mb-3">
                                            <i class="fa fa-users text-info" aria-hidden="true"></i>
                                            <label for="txtSubSection">Subsection</label>
                                            <select class="form-control required-input" id="selcSubSection" name="selcSubSection" placeholder="Subsection"></select>
                                            <div class="required-feedback">
                                                <i class="fa fa-exclamation-triangle text-danger" aria-hidden="true"></i>
                                                <label class="text-danger">Please select employee sub section</label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-row">
                                        <div class="col-md-12 mb-3">
                                            <i class="fa fa-users text-info" aria-hidden="true"></i>
                                            <label for="txtCompany">Company</label>
                                            <select class="form-control required-input" id="selcCompany" name="selcCompany" placeholder="Company"></select>
                                            <div class="required-feedback">
                                                <i class="fa fa-exclamation-triangle text-danger" aria-hidden="true"></i>
                                                <label class="text-danger">Please select employee company</label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-row">
                                        <div class="col-md-12 mb-3">
                                            <i class="fa fa-user-o text-info" aria-hidden="true"></i>
                                            <label for="txtSupervisor">Report Officer</label>
                                            <!--<select class="form-control" id="selcSupervisor" name="selcSupervisor" placeholder="Supervisor" required=""></select>!-->
                                            <input type="hidden" id="supervisor_id" name="supervisor_id" value="Unspecified">
                                            <input type="text" class="form-control auto-complete" autocomplete="off" id="auto-comp1" name="txtAutoComplete" value="Unspecified" onchange="autoCompleteOnChange()">
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-12 mb-3">
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <i class="fa fa-calendar text-info" aria-hidden="true"></i>
                                                    <label>Contract</label>
                                                    <input type="checkbox" id="checkContract" name="checkContract">
                                                </div>

                                            </div>
                                            <input type="text" name="dteContractExpire" class="form-control" id="dteContractExpire" placeholder="YYYY-MM-DD">
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-12 mb-3">
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <i class="fa fa-money text-info" aria-hidden="true"></i>
                                                    <label>Pay Method</label>
                                                </div>

                                            </div>
                                            <select name="payMethod" class="form-control" id="cmbPayMethod">
                                                <option value="0">Cash</option>
                                                <option value="1">Bank</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="tab-pane fade" id="tbNotes" role="tabpanel" aria-labelledby="pills-notes-tab">
                            <div class="form-row">
                                <div class="col-md-12 mb-5">
                                    <i class="fa fa-pencil text-info" aria-hidden="true"></i>
                                    <label for="txtNotes">Notes</label>
                                    <br>
                                    <textarea class="form-control" id="txtNotes" name="txtNotes"></textarea>
                                    <div class="valid-feedback">
                                        Looks good!
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="tab-pane fade" id="tbAttachment" role="tabpanel" aria-labelledby="pills-attachment-tab">
                            <div class="card">
                                <div class="card-body">
                                    <div class="form-row">
                                        <i class="fa fa-paperclip text-info" aria-hidden="true"></i>
                                        <strong>Attachment</strong>
                                    </div>
                                    <br>
                                    <div class="form-row">
                                        <div class="col-md-8">
                                            <div class="table-responsive">
                                                <!-- Required for Responsive -->
                                                <table id="myTable" class="table table-striped  datatable">
                                                    <thead>
                                                        <tr>
                                                            <th>Title</th>
                                                            <th>View</th>
                                                            <th>Down</th>
                                                            <th>Delete</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <!--<tr>
                                                            <td>dummy_title</td>
                                                            <td class="thView">
                                                                <button class="btn btn-success setting-edit-btn"><i class="fa fa-eye" aria-hidden="true"></i></button>
                                                            </td>
                                                            <td class="thDownload">
                                                                <button class="btn btn-primary setting-edit-btn"><i class="fa fa-download" aria-hidden="true"></i></button>
                                                            </td>
                                                            <td class="thDelete">
                                                                <button class="btn btn-danger setting-edit-btn"><i class="fa fa-trash" aria-hidden="true"></i></button>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td>dummy_title</td>
                                                            <td class="thView">
                                                                <button class="btn btn-success setting-edit-btn"><i class="fa fa-eye" aria-hidden="true"></i></button>
                                                            </td>
                                                            <td class="thDownload">
                                                                <button class="btn btn-primary setting-edit-btn"><i class="fa fa-download" aria-hidden="true"></i></button>
                                                            </td>
                                                            <td class="thDelete">
                                                                <button class="btn btn-danger setting-edit-btn"><i class="fa fa-trash" aria-hidden="true"></i></button>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td>dummy_title</td>
                                                            <td class="thView">
                                                                <button class="btn btn-success setting-edit-btn"><i class="fa fa-eye" aria-hidden="true"></i></button>
                                                            </td>
                                                            <td class="thDownload">
                                                                <button class="btn btn-primary setting-edit-btn"><i class="fa fa-download" aria-hidden="true"></i></button>
                                                            </td>
                                                            <td class="thDelete">
                                                                <button class="btn btn-danger setting-edit-btn"><i class="fa fa-trash" aria-hidden="true"></i></button>
                                                            </td>
                                                        </tr>!-->
                                                    </tbody>
                                                </table>
                                            </div>

                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-footer employeeSave">

                    @if(Auth::user()->can('employee_create') || Auth::user()->can('employee_edit'))
                    <button type="button" class="btn btn-warning" id="btnResetEmployee">Reset</button>
                    <button type="button" class="btn btn-primary" id="btnSaveEmployee">Save</button>
                    @endif
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

<!-- App scripts -->
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
@section('script')
<!-- DataTable -->
<script src="{{ url('vendors/dataTable/datatables.min.js') }}"></script>
<script src="{{ url('assets/js/examples/datatable.js') }}"></script>
<!-- AutoComplete -->
<script src="{{ Module::asset('hr:js/autocomplete2/js/autocomplete.min.js') }}?random=<?php echo uniqid(); ?>"></script>
<!-- RequiredInput -->
<script src="{{ Module::asset('hr:js/rquired_input.min.js') }}?random=<?php echo uniqid(); ?>"></script>
<!-- Javascript -->
<script src="{{ url('vendors/datepicker/daterangepicker.js') }}"></script>
<script src="{{ Module::asset('hr:js/employee.js') }}?random=<?php echo uniqid(); ?>"></script>
<!-- Prism -->
<script src="{{ url('vendors/prism/prism.js') }}"></script>
<script src="{{ url('assets/js/notification.js') }}?random=<?php echo uniqid(); ?>"></script>
@endsection