@extends('hr::layouts.app')

@section('head')
<!-- Prism -->
<link rel="stylesheet" href="{{ url('vendors/prism/prism.css') }}" type="text/css">
<link rel="stylesheet" href="{{ Module::asset('hr:css/hr/settings.css') }}" type="text/css">

<script>
    var town_edit_permission = "{{Auth::user()->can('employee_town_edit')}}";
    var town_disable_permission = "{{Auth::user()->can('employee_town_enable_disable')}}";

    var civilstatus_edit_permission = "{{Auth::user()->can('employee_civilstatus_edit')}}";
    var civilstatus_disable_permission = "{{Auth::user()->can('employee_civilstatus_enable_disable')}}";

    var designation_edit_permission = "{{Auth::user()->can('employee_designation_edit')}}";
    var designation_disable_permission = "{{Auth::user()->can('employee_designation_enable_disable')}}";

    var status_edit_permission = "{{Auth::user()->can('employee_status_edit')}}";
    var status_disable_permission = "{{Auth::user()->can('employee_status_enable_disable')}}";

    var site_edit_permission = "{{Auth::user()->can('employee_site_edit')}}";
    var site_disable_permission = "{{Auth::user()->can('employee_site_enable_disable')}}";

    var department_edit_permission = "{{Auth::user()->can('employee_department_edit')}}";
    var department_disable_permission = "{{Auth::user()->can('employee_department_enable_disable')}}";

    var section_edit_permission = "{{Auth::user()->can('employee_section_edit')}}";
    var section_disable_permission = "{{Auth::user()->can('employee_section_enable_disable')}}";

    var subsection_edit_permission = "{{Auth::user()->can('employee_subsection_edit')}}";
    var subsection_disable_permission = "{{Auth::user()->can('employee_subsection_enable_disable')}}";

    var mohdivision_edit_permission = "{{Auth::user()->can('employee_mohdivision_edit')}}";
    var mohdivision_disable_permission = "{{Auth::user()->can('employee_mohdivision_enable_disable')}}";

    var police_edit_permission = "{{Auth::user()->can('employee_police_edit')}}";
    var police_disable_permission = "{{Auth::user()->can('employee_police_enable_disable')}}";

    var gsdivision_edit_permission = "{{Auth::user()->can('employee_gsdivision_edit')}}";
    var gsdivision_disable_permission = "{{Auth::user()->can('employee_gsdivision_enable_disable')}}";

</script>

<style>
    /*default version*/
    @font-face {
        font-family: 'sinhalaFont';
        src: url('../fonts/FM_Abhaya.TTF');
        src: url('../fonts/FM_Abhaya.TTF') format('embedded-opentype'), url('../fonts/FM_Abhaya.TTF') format('woff'), url('../fonts/FM_Abhaya.TTF') format('truetype'), url('../fonts/FM_Abhaya.TTF') format('svg');
        font-weight: normal;
        font-style: normal;
    }
</style>
<meta charset="UTF-8">
@endsection

@section('content')

<div class="page-header">
    <div>
        <h3></h3>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="#">Home</a>
                </li>
                <li class="breadcrumb-item">
                    <a href="#">Pages</a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">Form Page</li>
            </ol>
        </nav>
    </div>
</div>

<div class="row">
    <div class="col-md-12">
        <div class="card ">
            <div class="card-body">
                <h6 class="card-title">Settings</h6>
                <div class="accordion" id="accordionExample">

                    @if(Auth::user()->can('employee_town'))
                    <div class="col-md-12 mb-3">
                        <div class="card ">
                            <div class="card-header" id="headingTown">
                                <h5 class="mb-0">
                                    <button class="btn btn-link" type="button" id="settingsModal" data-toggle="collapse" data-target="#collapseTown" aria-expanded="false" aria-controls="collapseTown" onclick="getSettings('Town')">
                                        <i class="ti-settings mr-2"></i> Town
                                    </button>
                                </h5>
                            </div>
                            <div id="collapseTown" class="collapse" aria-labelledby="headingTown" data-parent="#accordionExample">
                                <div class="card-body">
                                    <div>
                                        @if(Auth::user()->can('employee_town_add'))
                                        <button type="button" class="btn btn-primary" data-target="#settingsAddModal" data-whatever="@getbootstrap" name="save" onclick="showModal('save','Town')">
                                            <i class="fa fa-plus" aria-hidden="true"></i>
                                        </button>
                                        @endif
                                    </div>
                                    <div class="table-responsive">
                                        <!-- Required for Responsive -->
                                        <table class="table">
                                            <thead>
                                                <tr>
                                                    <th class="id">ID#</th>
                                                    <th>Name</th>
                                                    <th class="edit edit_town">Edit</th>
                                                    <th class="disable disable_town">Status</th>
                                                </tr>
                                            </thead>
                                            <tbody id="tblTown"></tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endif

                    @if(Auth::user()->can('employee_civilstatus'))
                    <div class="col-md-12 mb-3">
                        <div class="card">
                            <div class="card-header" id="headingCivilStatus">
                                <h5 class="mb-0">
                                    <button class="btn btn-link" type="button" data-toggle="collapse" data-target="#collapseCivilStatus" aria-expanded="false" aria-controls="collapseCivilStatus" onclick="getSettings('CivilStatus')">
                                        <i class="ti-settings mr-2"></i> CivilStatus
                                    </button>
                                </h5>
                            </div>
                            <div id="collapseCivilStatus" class="collapse" aria-labelledby="headingCivilStatus" data-parent="#accordionExample">
                                <div class="card-body">
                                    <div>
                                        @if(Auth::user()->can('employee_civilstatus_add'))
                                        <button type="button" class="btn btn-primary" data-target="#settingsAddModal" data-whatever="@getbootstrap" name="save" onclick="showModal('save','CivilStatus')">
                                            <i class="fa fa-plus" aria-hidden="true"></i>
                                        </button>
                                        @endif
                                    </div>
                                    <div class="table-responsive">
                                        <!-- Required for Responsive -->
                                        <table class="table">
                                            <thead>
                                                <tr>
                                                    <th class="id">ID#</th>
                                                    <th>Name</th>
                                                    <th class="edit edit_civilstatus">Edit</th>
                                                    <th class="disable disable_civilstatus">Status</th>
                                                </tr>
                                            </thead>
                                            <tbody id="tblCivilStatus"></tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endif

                    @if(Auth::user()->can('employee_designation'))
                    <div class="col-md-12 mb-3">
                        <div class="card">
                            <div class="card-header" id="headingDesignation">
                                <h5 class="mb-0">
                                    <button class="btn btn-link" type="button" data-toggle="collapse" data-target="#collapseDesignation" aria-expanded="false" aria-controls="collapseDesignation" onclick="getSettings('Designation')">
                                        <i class="ti-settings mr-2"></i> Designation
                                    </button>
                                </h5>
                            </div>
                            <div id="collapseDesignation" class="collapse" aria-labelledby="headingDesignation" data-parent="#accordionExample">
                                <div class="card-body">
                                    <div>
                                        @if(Auth::user()->can('employee_designation_add'))
                                        <button type="button" class="btn btn-primary" data-target="#settingsAddModal" data-whatever="@getbootstrap" name="save" onclick="showModal('save','Designation')">
                                            <i class="fa fa-plus" aria-hidden="true"></i>
                                        </button>
                                        @endif
                                    </div>
                                    <div class="table-responsive">
                                        <!-- Required for Responsive -->
                                        <table class="table">
                                            <thead>
                                                <tr>
                                                    <th class="id">ID#</th>
                                                    <th>Name</th>
                                                    <th>Sinhala</th>
                                                    <th class="edit edit_designation">Edit</th>
                                                    <th class="disable disable_designation">Status</th>
                                                </tr>
                                            </thead>
                                            <tbody id="tblDesignation"></tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endif

                    <!--<div class="col-md-12 mb-3">
                        <div class="card">
                            <div class="card-header" id="headingEmployeeType">
                                <h5 class="mb-0">
                                    <button class="btn btn-link" type="button" data-toggle="collapse" data-target="#collapseEmployeeType" aria-expanded="false" aria-controls="collapseEmployeeType" onclick="getSettings('EmployeeType')">
                                        <i class="ti-settings mr-2"></i> Employee Type
                                    </button>
                                </h5>
                            </div>
                            <div id="collapseEmployeeType" class="collapse" aria-labelledby="headingEmployeeType" data-parent="#accordionExample">
                                <div class="card-body">
                                    <div>
                                        <button type="button" class="btn btn-primary" data-target="#settingsAddModal" data-whatever="@getbootstrap" name="save" onclick="showModal('save','EmployeeType')">
                                            <i class="fa fa-plus" aria-hidden="true"></i>
                                        </button>
                                    </div>
                                    <div class="table-responsive">!-->
                    <!-- Required for Responsive !-->
                    <!--<table class="table">
                                            <thead>
                                                <tr>
                                                    <th class="id">ID#</th>
                                                    <th>Name</th>
                                                    <th class="edit">Edit</th>
                                                    <th class="disable">Status</th>
                                                </tr>
                                            </thead>
                                            <tbody id="tblEmployeeType"></tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>!-->

                    @if(Auth::user()->can('employee_status'))
                    <div class="col-md-12 mb-3">
                        <div class="card">
                            <div class="card-header" id="headingEmployeeStatus">
                                <h5 class="mb-0">
                                    <button class="btn btn-link" type="button" data-toggle="collapse" data-target="#collapseEmployeeStatus" aria-expanded="false" aria-controls="collapseEmployeeStatus" onclick="getSettings('EmployeeStatus')">
                                        <i class="ti-settings mr-2"></i> EmployeeStatus
                                    </button>
                                </h5>
                            </div>
                            <div id="collapseEmployeeStatus" class="collapse" aria-labelledby="headingEmployeeStatus" data-parent="#accordionExample">
                                <div class="card-body">
                                    <div>
                                        @if(Auth::user()->can('employee_employeeStatus_add'))
                                        <button type="button" class="btn btn-primary" data-target="#settingsAddModal" data-whatever="@getbootstrap" name="save" onclick="showModal('save','EmployeeStatus')">
                                            <i class="fa fa-plus" aria-hidden="true"></i>
                                        </button>
                                        @endif
                                    </div>
                                    <div class="table-responsive">
                                        <!-- Required for Responsive -->
                                        <table class="table">
                                            <thead>
                                                <tr>
                                                    <th class="id">ID#</th>
                                                    <th>Name</th>
                                                    <th class="edit edit_status">Edit</th>
                                                    <th class="disable disable_status">Status</th>
                                                </tr>
                                            </thead>
                                            <tbody id="tblEmployeeStatus"></tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endif

                    <!--<div class="col-md-12 mb-3">
                        <div class="card">
                            <div class="card-header" id="headingCategory">
                                <h5 class="mb-0">
                                    <button class="btn btn-link" type="button" data-toggle="collapse" data-target="#collapseCategory" aria-expanded="false" aria-controls="collapseCategory" onclick="getSettings('Category')">
                                        <i class="ti-settings mr-2"></i> Category
                                    </button>
                                </h5>
                            </div>
                            <div id="collapseCategory" class="collapse" aria-labelledby="headingCategory" data-parent="#accordionExample">
                                <div class="card-body">
                                    <div>
                                        <button type="button" class="btn btn-primary" data-target="#settingsAddModal" data-whatever="@getbootstrap" name="save" onclick="showModal('save','Category')">
                                            <i class="fa fa-plus" aria-hidden="true"></i>
                                        </button>
                                    </div>
                                    <div class="table-responsive">
                                        Required for Responsive
                                        <table class="table">
                                            <thead>
                                                <tr>
                                                    <th class="id">ID#</th>
                                                    <th>Name</th>
                                                    <th class="edit">Edit</th>
                                                    <th class="disable">Status</th>
                                                </tr>
                                            </thead>
                                            <tbody id="tblCategory"></tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>!-->

                    @if(Auth::user()->can('employee_site'))
                    <div class="col-md-12 mb-3">
                        <div class="card">
                            <div class="card-header" id="headingSite">
                                <h5 class="mb-0">
                                    <button class="btn btn-link" type="button" data-toggle="collapse" data-target="#collapseSite" aria-expanded="false" aria-controls="collapseSite" onclick="getSettings('Site')">
                                        <i class="ti-settings mr-2"></i> Site
                                    </button>
                                </h5>
                            </div>
                            <div id="collapseSite" class="collapse" aria-labelledby="headingSite" data-parent="#accordionExample">
                                <div class="card-body">
                                    <div>
                                        @if(Auth::user()->can('employee_site_add'))
                                        <button type="button" class="btn btn-primary" data-target="#settingsAddModal" data-whatever="@getbootstrap" name="save" onclick="showModal('save','Site')">
                                            <i class="fa fa-plus" aria-hidden="true"></i>
                                        </button>
                                        @endif
                                    </div>
                                    <div class="table-responsive">
                                        <!-- Required for Responsive -->
                                        <table class="table">
                                            <thead>
                                                <tr>
                                                    <th class="id">ID#</th>
                                                    <th>Name</th>
                                                    <th class="edit edit_site">Edit</th>
                                                    <th class="disable disable_site">Status</th>
                                                </tr>
                                            </thead>
                                            <tbody id="tblSite"></tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endif

                    @if(Auth::user()->can('employee_department'))
                    <div class="col-md-12 mb-3">
                        <div class="card">
                            <div class="card-header" id="headingDepartment">
                                <h5 class="mb-0">
                                    <button class="btn btn-link" type="button" data-toggle="collapse" data-target="#collapseDepartment" aria-expanded="false" aria-controls="collapseDepartment" onclick="getSettings('Department')">
                                        <i class="ti-settings mr-2"></i> Department
                                    </button>
                                </h5>
                            </div>
                            <div id="collapseDepartment" class="collapse" aria-labelledby="headingDepartment" data-parent="#accordionExample">
                                <div class="card-body">
                                    <div>
                                        @if(Auth::user()->can('employee_department_add'))
                                        <button type="button" class="btn btn-primary" data-target="#settingsAddModal" data-whatever="@getbootstrap" name="save" onclick="showModal('save','Department')">
                                            <i class="fa fa-plus" aria-hidden="true"></i>
                                        </button>
                                        @endif
                                    </div>
                                    <div class="table-responsive">
                                        <!-- Required for Responsive -->
                                        <table class="table">
                                            <thead>
                                                <tr>
                                                    <th class="id">ID#</th>
                                                    <th>Name</th>
                                                    <th class="edit edit_department">Edit</th>
                                                    <th class="disable disable_department">Status</th>
                                                </tr>
                                            </thead>
                                            <tbody id="tblDepartment"></tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endif

                    @if(Auth::user()->can('employee_section'))
                    <div class="col-md-12 mb-3">
                        <div class="card">
                            <div class="card-header" id="headingSection">
                                <h5 class="mb-0">
                                    <button class="btn btn-link" type="button" data-toggle="collapse" data-target="#collapseSection" aria-expanded="false" aria-controls="collapseSection" onclick="getSettings('Section')">
                                        <i class="ti-settings mr-2"></i> Section
                                    </button>
                                </h5>
                            </div>
                            <div id="collapseSection" class="collapse" aria-labelledby="headingSection" data-parent="#accordionExample">
                                <div class="card-body">
                                    <div>
                                        @if(Auth::user()->can('employee_section_add'))
                                        <button type="button" class="btn btn-primary" data-target="#settingsAddModal" data-whatever="@getbootstrap" name="save" onclick="showModal('save','Section')">
                                            <i class="fa fa-plus" aria-hidden="true"></i>
                                        </button>
                                        @endif
                                    </div>
                                    <div class="table-responsive">
                                        <!-- Required for Responsive -->
                                        <table class="table">
                                            <thead>
                                                <tr>
                                                    <th class="id">ID#</th>
                                                    <th>Name</th>
                                                    <th class="edit edit_section">Edit</th>
                                                    <th class="disable disable_section">Status</th>
                                                </tr>
                                            </thead>
                                            <tbody id="tblSection"></tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endif

                    @if(Auth::user()->can('employee_subsection'))
                    <div class="col-md-12 mb-3">
                        <div class="card">
                            <div class="card-header" id="headingSubSection">
                                <h5 class="mb-0">
                                    <button class="btn btn-link" type="button" data-toggle="collapse" data-target="#collapseSubSection" aria-expanded="false" aria-controls="collapseSubSection" onclick="getSettings('SubSection')">
                                        <i class="ti-settings mr-2"></i> SubSection
                                    </button>
                                </h5>
                            </div>
                            <div id="collapseSubSection" class="collapse" aria-labelledby="headingSubSection" data-parent="#accordionExample">
                                <div class="card-body">
                                    <div>
                                        @if(Auth::user()->can('employee_subsection_add'))
                                        <button type="button" class="btn btn-primary" data-target="#settingsAddModal" data-whatever="@getbootstrap" name="save" onclick="showModal('save','SubSection')">
                                            <i class="fa fa-plus" aria-hidden="true"></i>
                                        </button>
                                        @endif
                                    </div>
                                    <div class="table-responsive">
                                        <!-- Required for Responsive -->
                                        <table class="table">
                                            <thead>
                                                <tr>
                                                    <th class="id">ID#</th>
                                                    <th>Name</th>
                                                    <th class="edit edit_subsection">Edit</th>
                                                    <th class="disable disable_subsection">Status</th>
                                                </tr>
                                            </thead>
                                            <tbody id="tblSubSection"></tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endif

                    @if(Auth::user()->can('employee_mohdivision'))
                    <div class="col-md-12 mb-3">
                        <div class="card">
                            <div class="card-header" id="headingMohDivision">
                                <h5 class="mb-0">
                                    <button class="btn btn-link" type="button" data-toggle="collapse" data-target="#collapseMohDivision" aria-expanded="false" aria-controls="collapseMohDivision" onclick="getSettings('MohDivision')">
                                        <i class="ti-settings mr-2"></i> MOH Division
                                    </button>
                                </h5>
                            </div>
                            <div id="collapseMohDivision" class="collapse" aria-labelledby="headingMohDivision" data-parent="#accordionExample">
                                <div class="card-body">
                                    <div>
                                        @if(Auth::user()->can('employee_mohdivision_add'))
                                        <button type="button" class="btn btn-primary" data-target="#settingsAddModal" data-whatever="@getbootstrap" name="save" onclick="showModal('save','MohDivision')">
                                            <i class="fa fa-plus" aria-hidden="true"></i>
                                        </button>
                                        @endif

                                    </div>
                                    <div class="table-responsive">
                                        <!-- Required for Responsive -->
                                        <table class="table">
                                            <thead>
                                                <tr>
                                                    <th class="id">ID#</th>
                                                    <th>Name</th>
                                                    <th>Mobile</th>
                                                    <th>Office</th>
                                                    <th>Contact Person</th>
                                                    <th class="edit edit_mohdivision">Edit</th>
                                                    <th class="disable disable_mohdivision">Status</th>
                                                </tr>
                                            </thead>
                                            <tbody id="tblMohDivision"></tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endif

                    @if(Auth::user()->can('employee_police'))
                    <div class="col-md-12 mb-3">
                        <div class="card">
                            <div class="card-header" id="headingPolice">
                                <h5 class="mb-0">
                                    <button class="btn btn-link" type="button" data-toggle="collapse" data-target="#collapsePolice" aria-expanded="false" aria-controls="collapsePolice" onclick="getSettings('Police')">
                                        <i class="ti-settings mr-2"></i> Police
                                    </button>
                                </h5>
                            </div>
                            <div id="collapsePolice" class="collapse" aria-labelledby="headingPolice" data-parent="#accordionExample">
                                <div class="card-body">
                                    <div>
                                        @if(Auth::user()->can('employee_police_add'))
                                        <button type="button" class="btn btn-primary" data-target="#settingsAddModal" data-whatever="@getbootstrap" name="save" onclick="showModal('save','Police')">
                                            <i class="fa fa-plus" aria-hidden="true"></i>
                                        </button>
                                        @endif
                                    </div>
                                    <div class="table-responsive">
                                        <!-- Required for Responsive -->
                                        <table class="table">
                                            <thead>
                                                <tr>
                                                    <th class="id">ID#</th>
                                                    <th>Name</th>
                                                    <th>Mobile</th>
                                                    <th>Office</th>
                                                    <th>Contact Person</th>
                                                    <th class="edit edit_police">Edit</th>
                                                    <th class="disable disable_police">Status</th>
                                                </tr>
                                            </thead>
                                            <tbody id="tblPolice"></tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endif

                    @if(Auth::user()->can('employee_gsdivision'))
                    <div class="col-md-12 mb-3">
                        <div class="card">
                            <div class="card-header" id="headingGsDivision">
                                <h5 class="mb-0">
                                    <button class="btn btn-link" type="button" data-toggle="collapse" data-target="#collapseGsDivision" aria-expanded="false" aria-controls="collapseGsDivision" onclick="getSettings('GsDivision')">
                                        <i class="ti-settings mr-2"></i> GS Division
                                    </button>
                                </h5>
                            </div>
                            <div id="collapseGsDivision" class="collapse" aria-labelledby="headingGsDivision" data-parent="#accordionExample">
                                <div class="card-body">
                                    <div>
                                        @if(Auth::user()->can('employee_gsdivision_add'))
                                        <button type="button" class="btn btn-primary" data-target="#settingsAddModal" data-whatever="@getbootstrap" name="save" onclick="showModal('save','GsDivision')">
                                            <i class="fa fa-plus" aria-hidden="true"></i>
                                        </button>
                                        @endif
                                    </div>
                                    <div class="table-responsive">
                                        <!-- Required for Responsive -->
                                        <table class="table">
                                            <thead>
                                                <tr>
                                                    <th class="id">ID#</th>
                                                    <th>Name</th>
                                                    <th>Mobile</th>
                                                    <th>Office</th>
                                                    <th>Contact Person</th>
                                                    <th class="edit edit_gsdivision">Edit</th>
                                                    <th class="disable disable_gsdivision">Status</th>
                                                </tr>
                                            </thead>
                                            <tbody id="tblGsDivision"></tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endif

                </div>
            </div>
        </div>
    </div>


    <div class="modal fade" id="settingsAddModal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="settingsAddModalTitle">Modal title</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <i class="ti-close"></i>
                    </button>
                </div>
                <form method="POST" id="myForm">
                    {{csrf_field()}}
                    <input type="hidden" id="settingID" name="settingID" value>
                    <div class="modal-body" id="settingsAddModalBody">
                        <div class="form-row">
                            <div class="col-md-12 mb-3" id="divSection">
                                <label for="txtName" id="lblSection">Section</label>
                                <select class="form-control" id="selcSection" name="selcSection" value="abc"></select>
                            </div>
                            <div class="col-md-12 mb-3">
                                <label for="txtName">Name</label>
                                <input type="text" class="form-control" id="txtSettingName" name="txtSettingName" placeholder="Name" required="">
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-danger" data-dismiss="modal">Close
                        </button>
                        <button type="button" class="btn btn-primary" id="btnSetting">Save</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>


@endsection

<!-- Javascript -->
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
@section('script')
<!-- App scripts -->
<script src="{{ Module::asset('hr:js/special_character.js') }}?random=<?php echo uniqid(); ?>"></script>
<script src="{{ Module::asset('hr:js/settings.js') }}?random=<?php echo uniqid(); ?>"></script>
<!-- Sweet alert -->
<script src="{{ url('assets/js/examples/sweet-alert.js') }}"></script>
<!-- Prism -->
<script src="{{ url('vendors/prism/prism.js') }}"></script>
<script src="{{ url('assets/js/notification.js') }}?random=<?php echo uniqid(); ?>"></script>
@endsection