/**
 * java script -settings
 *
 * @author  Sampath Perera
 * @since   2020-11-04
 */


/**
 * Constant
 * DO not change constant
 * 
 * Maped server side and client side
 * Maped html and javascript
 * Maped url pattern with  save , update and search
 * 
 */
const SAVE = "save";
const UPDATE = "update";

const TOWN = "Town";
const CIVIL_STATUS = "CivilStatus";
const DESIGNATION = "Designation";
const EMPLOYEE_TYPE = "EmployeeType";
const EMPLOYEE_STATUS = "EmployeeStatus";
const CATEGORY = "Category";
const SITE = "Site";
const DEPARTMENT = "Department";
const SECTION = "Section";
const SUB_SECTION = "SubSection";
const MOH_DIVISION = "MohDivision";
const POLICE = "Police";
const GS_DIVISION = "GsDivision";

const TITLE_MAP = {
    'saveTown': 'Add new town',
    'saveCivilStatus': 'Add new civil status',
    'saveDesignation': 'Add new designation',
    'saveEmployeeType': 'Add new employee type',
    'saveEmployeeStatus': 'Add new employee status',
    'saveCategory': 'Add new category',
    'saveSite': 'Add new site',
    'saveDepartment': 'Add new department',
    'saveSection': 'Add new section',
    'saveSubSection': 'Add new subsection',
    'saveMohDivision': 'Add new moh division',
    'savePolice': 'Add new police',
    'saveGsDivision': 'Add new gs division',

    'updateTown': 'Update town',
    'updateCivilStatus': 'Update civil status',
    'updateDesignation': 'Update designation',
    'updateEmployeeType': 'Update employee type',
    'updateEmployeeStatus': 'Update employee status',
    'updateCategory': 'Update category',
    'updateSite': 'Update site',
    'updateDepartment': 'Update department',
    'updateSection': 'Update section',
    'updateSubSection': 'Update subsection',
    'updateMohDivision': 'Update moh division',
    'updatePolice': 'Update police',
    'updateGsDivision': 'Update gs division',
};


const URL_MAP = {
    'Town': '/hr/settings/town',
    'CivilStatus': '/hr/settings/civilstatus',
    'Designation': '/hr/settings/designation',
    'EmployeeType': '/hr/settings/employeetype',
    'EmployeeStatus': '/hr/settings/employeestatus',
    'Category': '/hr/settings/category',
    'Site': '/hr/settings/site',
    'Department': '/hr/settings/department',
    'Section': '/hr/settings/section',
    'SubSection': '/hr/settings/subsection',
    'MohDivision': '/hr/settings/mohdivision',
    'Police': '/hr/settings/police',
    'GsDivision': '/hr/settings/gsdivision',
};

const URL_MAP_SEARCH = {
    'Town': '/hr/settings/towns',
    'CivilStatus': '/hr/settings/civilstatuses',
    'Designation': '/hr/settings/designations',
    'EmployeeType': '/hr/settings/employeetypes',
    'EmployeeStatus': '/hr/settings/employeestatuses',
    'Category': '/hr/settings/categories',
    'Site': '/hr/settings/sites',
    'Department': '/hr/settings/departments',
    'Section': '/hr/settings/sections',
    'SubSection': '/hr/settings/subsections',
    'MohDivision': '/hr/settings/mohdivision',
    'Police': '/hr/settings/police',
    'GsDivision': '/hr/settings/gsdivision',
};



/**
* showModal
* This function is used to open modal.
* @param event This is the paramter to identify save/update
* @param name This is the paramter to identify settings name
*/
function showModal(event, name) {

    if (name == DESIGNATION) {
        $('#settingsAddModalBody').empty();
        var content = '<div class="form-row">';
        content += '<div class="col-md-12 mb-3" id="divDesignation">';
        content += '<label for="txtName" id="lblDesignation">Designation</label>';
        content += '<input type="text" class="form-control" id="txtSettingName" name="Designation" placeholder="Designation">';
        content += '</div>';
        content += '<div class="col-md-12 mb-3">';
        content += '<label for="txtName">Designation (Sinhala)</label>';
        content += '<input type="text" class="form-control" id="txtDesignationSinhala" name="designationSinhala" placeholder=";k;=r ^isxy,&" required="" style="font-family: sinhalaFont; font-size: 18px;">';
        content += '</div>';
        content += '</div>';
        $('#settingsAddModalBody').append(content);
    } else if (name == MOH_DIVISION) {
        $('#settingsAddModalBody').empty();
        var content = '<div class="form-row">';
        content += '<div class="col-md-12 mb-3" id="divMhoDivision">';
        content += '<label for="txtName" id="lblMhoDivision">MOH Division</label>';
        content += '<input type="text" class="form-control" id="txtSettingName" name="txtSettingName" placeholder="MOH Division">';
        content += '</div>';
        content += '<div class="col-md-12 mb-3">';
        content += '<label for="txtName">MOH' + "'" + 's Mobile </label>';
        content += '<input type="text" class="form-control" id="txtMohMobile" name="txtMohMobile" placeholder="Mobile No" required="">';
        content += '</div>';
        content += '</div>';

        content += '<div class="form-row">';
        content += '<div class="col-md-12 mb-3" id="divMohOfficePhone">';
        content += '<label for="txtName" id="lblMohOfficePhone">Office Phone </label>';
        content += '<input type="text" class="form-control" id="txtMohOfficePhone" name="txtMohOfficePhone" placeholder="Office Phone">';
        content += '</div>';
        content += '<div class="col-md-12 mb-3">';
        content += '<label for="txtName">Contact person</label>';
        content += '<input type="text" class="form-control" id="txtMohContactPerson" name="txtMohContactPerson" placeholder="Contact person" required="">';
        content += '</div>';
        content += '</div>';
        $('#settingsAddModalBody').append(content);

    } else if (name == POLICE) {

        $('#settingsAddModalBody').empty();
        var content = '<div class="form-row">';
        content += '<div class="col-md-12 mb-3" id="divPolice">';
        content += '<label for="txtName" id="lblPolice">Police Station</label>';
        content += '<input type="text" class="form-control" id="txtSettingName" name="txtSettingName" placeholder="Police Station">';
        content += '</div>';
        content += '<div class="col-md-12 mb-3">';
        content += '<label for="txtName">OIC' + "'" + 's Mobile </label>';
        content += '<input type="text" class="form-control" id="txtOicMobile" name="txtOicMobil" placeholder="Mobile No" required="">';
        content += '</div>';
        content += '</div>';

        content += '<div class="form-row">';
        content += '<div class="col-md-12 mb-3" id="divPoliceOfficePhone">';
        content += '<label for="txtName" id="lblPoliceOfficePhone">Office Phone </label>';
        content += '<input type="text" class="form-control" id="txtPoliceOfficePhone" name="txtPoliceOfficePhone" placeholder="Office Phone">';
        content += '</div>';
        content += '<div class="col-md-12 mb-3">';
        content += '<label for="txtName">Contact person</label>';
        content += '<input type="text" class="form-control" id="txtPoliceContactPerson" name="txtPoliceContactPerson" placeholder="Contact person" required="">';
        content += '</div>';
        content += '</div>';
        $('#settingsAddModalBody').append(content);

    } else if (name == GS_DIVISION) {

        $('#settingsAddModalBody').empty();
        var content = '<div class="form-row">';
        content += '<div class="col-md-12 mb-3" id="divGsDivision">';
        content += '<label for="txtName" id="lblPolice">GS Division</label>';
        content += '<input type="text" class="form-control" id="txtSettingName" name="txtSettingName" placeholder="GS Division">';
        content += '</div>';
        content += '<div class="col-md-12 mb-3">';
        content += '<label for="txtName">GS' + "'" + 's Mobile </label>';
        content += '<input type="text" class="form-control" id="txtGsMobile" name="txtGsMobil" placeholder="Mobile No" required="">';
        content += '</div>';
        content += '</div>';

        content += '<div class="form-row">';
        content += '<div class="col-md-12 mb-3" id="divGsOfficePhone">';
        content += '<label for="txtName" id="lblGsOfficePhone">Office Phone </label>';
        content += '<input type="text" class="form-control" id="txtGsOfficePhone" name="txtGsOfficePhone" placeholder="Office Phone">';
        content += '</div>';
        content += '<div class="col-md-12 mb-3">';
        content += '<label for="txtName">Contact person</label>';
        content += '<input type="text" class="form-control" id="txtGsContactPerson" name="txtGsContactPerson" placeholder="Contact person" required="">';
        content += '</div>';
        content += '</div>';
        $('#settingsAddModalBody').append(content);

    } else {
        $('#settingsAddModalBody').empty();
        var content = '<div class="form-row">';
        content += '<div class="col-md-12 mb-3" id="divSection">';
        content += '<label for="txtName" id="lblSection">Section</label>';
        content += '<select class="form-control" id="selcSection" name="selcSection" value="abc"></select>';
        content += '</div>';
        content += '<div class="col-md-12 mb-3">';
        content += '<label for="txtName">Name</label>';
        content += '<input type="text" class="form-control" id="txtSettingName" name="txtSettingName" placeholder="Name" required="">';
        content += '</div>';
        content += '</div>';
        $('#settingsAddModalBody').append(content);
    }

    var title = TITLE_MAP[event + name];

    if (name == SUB_SECTION) {
        $('#selcSection').show();
        $('#lblSection').show();
        loadSection_to_SubSection();
    } else {
        $('#selcSection').hide();
        $('#lblSection').hide();
    }

    $('#txtSettingName').attr('name', name);
    $('#settingsAddModalTitle').text(title);


    if (event == SAVE) {
        $('#btnSetting').attr('name', 'save');
        $('#btnSetting').text('Save');
        $('#txtSettingName').val('');
    }
    if (event == UPDATE) {
        $('#btnSetting').attr('name', 'update');
        $('#btnSetting').text('Update');
        var evt = $('.table tbody').on('click', '.btn', function (event) {
            if (name == DESIGNATION) {

                var currow = $(this).closest('tr');
                var id = currow.find('td:eq(0)').attr('id');
                var value = currow.find('td:eq(1)').text();
                var sinhala = currow.find('td:eq(2)').text();
                $('#settingID').val(id);
                $('#txtSettingName').val(value);
                $('#txtDesignationSinhala').val(sinhala);

            } else if (name == MOH_DIVISION) {

                var currow = $(this).closest('tr');
                var id = currow.find('td:eq(0)').attr('id');
                var value = currow.find('td:eq(1)').text();
                var mobile = currow.find('td:eq(2)').text();
                var phone = currow.find('td:eq(3)').text();
                var contact_persion = currow.find('td:eq(4)').text();
                $('#settingID').val(id);
                $('#txtSettingName').val(value);
                $('#txtMohMobile').val(mobile);
                $('#txtMohOfficePhone').val(phone);
                $('#txtMohContactPerson').val(contact_persion);

            } else if (name == POLICE) {

                var currow = $(this).closest('tr');
                var id = currow.find('td:eq(0)').attr('id');
                var value = currow.find('td:eq(1)').text();
                var mobile = currow.find('td:eq(2)').text();
                var phone = currow.find('td:eq(3)').text();
                var contact_persion = currow.find('td:eq(4)').text();
                $('#settingID').val(id);
                $('#txtSettingName').val(value);
                $('#txtOicMobile').val(mobile);
                $('#txtPoliceOfficePhone').val(phone);
                $('#txtPoliceContactPerson').val(contact_persion);

            } else if (name == GS_DIVISION) {

                var currow = $(this).closest('tr');
                var id = currow.find('td:eq(0)').attr('id');
                var value = currow.find('td:eq(1)').text();
                var mobile = currow.find('td:eq(2)').text();
                var phone = currow.find('td:eq(3)').text();
                var contact_persion = currow.find('td:eq(4)').text();
                $('#settingID').val(id);
                $('#txtSettingName').val(value);
                $('#txtGsMobile').val(mobile);
                $('#txtGsOfficePhone').val(phone);
                $('#txtGsContactPerson').val(contact_persion);

            } else {

                var currow = $(this).closest('tr');
                var id = currow.find('td:eq(0)').attr('id');
                var value = currow.find('td:eq(1)').text();
                $('#settingID').val(id);
                $('#txtSettingName').val(value);
                if (name == SUB_SECTION) {
                    var section = currow.find('td:eq(1)').attr('id');
                    $('#selcSection').attr('value', section);
                }
            }
        });

    }



    $("#settingsAddModal").modal('toggle');
}


/**
* JQuery
* This is used to call save function and update function
* Used url pattern
*/
$(document).ready(function () {

    //Toast library for message
    toastr.options = {
        timeOut: 3000,
        progressBar: true,
        showMethod: "slideDown",
        hideMethod: "slideUp",
        showDuration: 200,
        hideDuration: 200
    };
    ////////////

    $('#btnSetting').click(function (event) {
        event.preventDefault();

        var key = $('#txtSettingName').attr('name');
        var url = URL_MAP[key];
        var _token = $("input[name='_token']").val();

        var evt = event.target.name;

        if (evt == SAVE) {

            var form = new FormData();
            form.append("_token", _token);

            if (key == 'Designation') {
                form.append("designation", $('#txtSettingName').val());
                form.append("designation_sinhala", $('#txtDesignationSinhala').val());
            } else if (key == 'MohDivision') {
                form.append("moh_division", $('#txtSettingName').val());
                form.append("moh_mobile", $('#txtMohMobile').val());
                form.append("office_phone", $('#txtMohOfficePhone').val());
                form.append("contact_person", $('#txtMohContactPerson').val());
            } else if (key == 'Police') {
                form.append("police_station", $('#txtSettingName').val());
                form.append("oic_mobile", $('#txtOicMobile').val());
                form.append("office_phone", $('#txtPoliceOfficePhone').val());
                form.append("contact_person", $('#txtPoliceContactPerson').val());

            } else if (key == 'GsDivision') {
                form.append("gs_division", $('#txtSettingName').val());
                form.append("gs_mobile", $('#txtGsMobile').val());
                form.append("office_phone", $('#txtGsOfficePhone').val());
                form.append("contact_person", $('#txtGsContactPerson').val());

            } else {
                form.append("value", $('#txtSettingName').val());
            }

            if (key == SUB_SECTION) {
                var section_id = $('#selcSection').val();
                form.append("section_id", section_id);
            }
            save(url, form);

        } else if (evt == UPDATE) {

            var id = $('#settingID').val();
            update(url, id);

        }

    });


});


/**
* save
* This function is used to save settings.
* @param url This is the paramter to ajax request url 
* @param form This is the paramter to ajax data
*/
function save(url, form) {

    $.ajax({
        type: "POST",
        url: url,
        data: form,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {
            $("#settingsAddModal").modal('hide');
        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {

                showSuccessMessage("Settings has been saved successfully...");
                getSettings(response.data.name);

            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }

    });
}


/**
* update
* This function is used to update settings.
* @param url This is the paramter to ajax request url 
* @param id This is the paramter to ajax data
*/
function update(url, id) {

    $.ajax({
        type: 'PUT',
        url: url + '/' + id,
        data: $('#myForm').serialize(),
        timeout: 800000,
        beforeSend: function () {
            $("#settingsAddModal").modal('hide');
        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {

                showSuccessMessage("Settings has been updated successfully...");
                getSettings(response.data.name);

            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }

    });
}



/**
* delete
* This function is used to update settings.
* @param url This is the paramter to ajax request url 
* @param id This is the paramter to ajax data
*/
function _delete(url, id, status) {

    var bool = 0;
    if (status) bool = 1;

    $.ajax({
        type: 'DELETE',
        url: url + '/' + id,
        data: {
            _token: $('input[name=_token]').val(),
            "status": bool
        },
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {

                if (status) showSuccessMessage("Data has been enabled successfully...");
                if (!status) showSuccessMessage("Data has been disabled successfully...");

                getSettings(response.data.name);

            } else {
                var msg = response.data.message;
                var id = response.data.result;

                if (msg == "assigned") {//assigned settings cannot be disabled
                    showWarningMessage("Settings has been assigned...!");
                    getSettings(response.data.name);
                } else if (msg == "error") {
                    showErrorMessage();
                }
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }

    });
}



/**
* save
* This function is used to disable settings.
* @param event This is the paramter to identifi desable/enable 
*/
function disable(event, name) {

    var url = URL_MAP[name];
    var id = event.target.id;
    var status = event.target.checked;
    _delete(url, id, status);
}



/**
* save
* This function is used to search settings.
* @param key This is the paramter to identifi ajax request url 
*/
function getSettings(key) {

    var url = URL_MAP_SEARCH[key];
    $.ajax({
        type: "GET",
        url: url,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {

                var name = response.data.name;
                var result = response.data.result;
                loadTable(name, result);

            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {
            $('.ti-settings').show();
            $('.spinner-border').hide();
        }

    });
}



/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {

    toastr.success(message);
}



/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}


/**
* showWarrningMessage
* This function is used to show warning message.
* @param message This is the paramter to require message content
*/
function showWarningMessage(message) {

    toastr.warning(message);
}


/**
* loadTable
* This function is used to data set on the tables.
* @param name This is the paramter to identifi table name
* @param name This is the paramter to require table content
*/
function loadTable(name, result) {

    var disable = { 0: "", 1: "checked" }
    var tbody = "";
    var tableName = "#tbl" + name;

    for (i = 0; i < result.length; i++) {

        var row = "<tr>";

        if (name == TOWN) {

            row += '<td class="id" id="' + result[i].town_id + '">' + generateID(result[i].town_id) + '</td>';
            row += '<td>' + result[i].town + '</td>';
            row += '<td class="edit edit_town">';
            row += '<button type="button" class="btn btn-primary setting-edit-btn" id="' + result[i].town_id + '" onclick="showModal(' + "'update'" + ',' + "'Town'" + ')">';
            row += '<i class="fa fa-pencil-square-o" aria-hidden="true"></button>';

            row += '</td>';
            row += '<td class="disable disable_town">';
            row += '<label class="switch">';
            row += '<input type="checkbox"  id="' + result[i].town_id + '" onchange="disable(event,' + "'Town'" + ')" ' + disable[result[i].status] + '>';

        } else if (name == CIVIL_STATUS) {

            row += '<td class="id" id="' + result[i].civilstatus_id + '">' + generateID(result[i].civilstatus_id) + '</td>';
            row += '<td>' + result[i].civilstatus + '</td>';
            row += '<td class="edit edit_civilstatus">';
            row += '<button type="button" class="btn btn-primary setting-edit-btn" id="' + result[i].civilstatus_id + '" onclick="showModal(' + "'update'" + ',' + "'CivilStatus'" + ')">';
            row += '<i class="fa fa-pencil-square-o" aria-hidden="true"></button>';

            row += '</td>';
            row += '<td class="disable disable_civilstatus">';
            row += '<label class="switch">';
            row += '<input type="checkbox" id="' + result[i].civilstatus_id + '" onchange="disable(event,' + "'CivilStatus'" + ')" ' + disable[result[i].status] + '>';

        } else if (name == DESIGNATION) {

            var sinhala = result[i].designation_sinhala;
            row += '<td class="id" id="' + result[i].designation_id + '">' + generateID(result[i].designation_id) + '</td>';
            row += '<td>' + result[i].designation + '</td>';
            row += '<td style="font-family: sinhalaFont; font-size: 18px;">' + convert_to_sinhala(sinhala) + '</td>';
            row += '<td class="edit edit_designation">';
            row += '<button type="button" class="btn btn-primary setting-edit-btn" id="' + result[i].designation_id + '" onclick="showModal(' + "'update'" + ',' + "'Designation'" + ')">';
            row += '<i class="fa fa-pencil-square-o" aria-hidden="true"></button>';

            row += '</td>';
            row += '<td class="disable disable_designation">';
            row += '<label class="switch">';
            row += '<input type="checkbox" id="' + result[i].designation_id + '" onchange="disable(event,' + "'Designation'" + ')" ' + disable[result[i].status] + '>';

        } else if (name == EMPLOYEE_TYPE) {

            row += '<td class="id" id="' + result[i].employeetype_id + '">' + generateID(result[i].employeetype_id) + '</td>';
            row += '<td>' + result[i].employeetype + '</td>';
            row += '<td class="edit edit_type">';
            row += '<button type="button" class="btn btn-primary setting-edit-btn" id="' + result[i].employeetype_id + '" onclick="showModal(' + "'update'" + ',' + "'EmployeeType'" + ')">';
            row += '<i class="fa fa-pencil-square-o" aria-hidden="true"></button>';

            row += '</td>';
            row += '<td class="disable disable_type">';
            row += '<label class="switch">';
            row += '<input type="checkbox" id="' + result[i].employeetype_id + '" onchange="disable(event,' + "'EmployeeType'" + ')" ' + disable[result[i].status] + '>';

        } else if (name == EMPLOYEE_STATUS) {

            row += '<td class="id" id="' + result[i].employeestatus_id + '">' + generateID(result[i].employeestatus_id) + '</td>';
            row += '<td>' + result[i].employeestatus + '</td>';
            row += '<td class="edit edit_status">';
            row += '<button type="button" class="btn btn-primary setting-edit-btn" id="' + result[i].employeestatus_id + '" onclick="showModal(' + "'update'" + ',' + "'EmployeeStatus'" + ')">';
            row += '<i class="fa fa-pencil-square-o" aria-hidden="true"></button>';

            row += '</td>';
            row += '<td class="disable disable_status">';
            row += '<label class="switch">';
            row += '<input type="checkbox" id="' + result[i].employeestatus_id + '" onchange="disable(event,' + "'EmployeeStatus'" + ')" ' + disable[result[i].status] + '>';

        } else if (name == CATEGORY) {

            row += '<td class="id" id="' + result[i].category_id + '">' + generateID(result[i].category_id) + '</td>';
            row += '<td>' + result[i].category + '</td>';
            row += '<td class="edit edit_category">';
            row += '<button type="button" class="btn btn-primary setting-edit-btn" id="' + result[i].category_id + '" onclick="showModal(' + "'update'" + ',' + "'Category'" + ')">';
            row += '<i class="fa fa-pencil-square-o" aria-hidden="true"></button>';

            row += '</td>';
            row += '<td class="disable disable_category">';
            row += '<label class="switch">';
            row += '<input type="checkbox" id="' + result[i].category_id + '" onchange="disable(event,' + "'Category'" + ')" ' + disable[result[i].status] + '>';

        } else if (name == SITE) {

            row += '<td class="id" id="' + result[i].site_id + '">' + generateID(result[i].site_id) + '</td>';
            row += '<td>' + result[i].site + '</td>';
            row += '<td class="edit edit_site">';
            row += '<button type="button" class="btn btn-primary setting-edit-btn" id="' + result[i].site_id + '" onclick="showModal(' + "'update'" + ',' + "'Site'" + ')">';
            row += '<i class="fa fa-pencil-square-o" aria-hidden="true"></button>';

            row += '</td>';
            row += '<td class="disable disable_site">';
            row += '<label class="switch">';
            row += '<input type="checkbox" id="' + result[i].site_id + '" onchange="disable(event,' + "'Site'" + ')" ' + disable[result[i].status] + '>';

        } else if (name == DEPARTMENT) {

            row += '<td class="id" id="' + result[i].department_id + '">' + generateID(result[i].department_id) + '</td>';
            row += '<td>' + result[i].department + '</td>';
            row += '<td class="edit edit_department">';
            row += '<button type="button" class="btn btn-primary setting-edit-btn" id="' + result[i].department_id + '" onclick="showModal(' + "'update'" + ',' + "'Department'" + ')">';
            row += '<i class="fa fa-pencil-square-o" aria-hidden="true"></button>';

            row += '</td>';
            row += '<td class="disable disable_department">';
            row += '<label class="switch">';
            row += '<input type="checkbox" id="' + result[i].department_id + '" onchange="disable(event,' + "'Department'" + ')" ' + disable[result[i].status] + '>';

        } else if (name == SECTION) {

            row += '<td class="id" id="' + result[i].section_id + '">' + generateID(result[i].section_id) + '</td>';
            row += '<td>' + result[i].section + '</td>';
            row += '<td class="edit edit_section">';
            row += '<button type="button" class="btn btn-primary setting-edit-btn" id="' + result[i].section_id + '" onclick="showModal(' + "'update'" + ',' + "'Section'" + ')">';
            row += '<i class="fa fa-pencil-square-o" aria-hidden="true"></button>';

            row += '</td>';
            row += '<td class="disable disable_section">';
            row += '<label class="switch">';
            row += '<input type="checkbox" id="' + result[i].section_id + '" onchange="disable(event,' + "'Section'" + ')" ' + disable[result[i].status] + '>';

        } else if (name == SUB_SECTION) {

            row += '<td class="id" id="' + result[i].subsection_id + '">' + generateID(result[i].subsection_id) + '</td>';
            row += '<td id="' + result[i].section + '">' + result[i].subsection + '</td>';
            row += '<td class="edit edit_subsection">';
            row += '<button type="button" class="btn btn-primary setting-edit-btn" id="' + result[i].subsection_id + '" onclick="showModal(' + "'update'" + ',' + "'SubSection'" + ')">';
            row += '<i class="fa fa-pencil-square-o" aria-hidden="true"></button>';

            row += '</td>';
            row += '<td class="disable disable_subsection">';
            row += '<label class="switch">';
            row += '<input type="checkbox" id="' + result[i].subsection_id + '" onchange="disable(event,' + "'SubSection'" + ')" ' + disable[result[i].status] + '>';

        } else if (name == MOH_DIVISION) {

            row += '<td class="id" id="' + result[i].moh_division_id + '">' + generateID(result[i].moh_division_id) + '</td>';
            row += '<td>' + result[i].moh_division + '</td>';
            row += '<td>' + result[i].moh_mobile + '</td>';
            row += '<td>' + result[i].office_phone + '</td>';
            row += '<td>' + result[i].contact_person + '</td>';
            row += '<td class="edit edit_mohdividion">';
            row += '<button type="button" class="btn btn-primary setting-edit-btn" id="' + result[i].moh_division_id + '" onclick="showModal(' + "'update'" + ',' + "'MohDivision'" + ')">';
            row += '<i class="fa fa-pencil-square-o" aria-hidden="true"></button>';

            row += '</td>';
            row += '<td class="disable disable_mohdividion">';
            row += '<label class="switch">';
            row += '<input type="checkbox" id="' + result[i].moh_division_id + '" onchange="disable(event,' + "'MohDivision'" + ')" ' + disable[result[i].status] + '>';

        } else if (name == POLICE) {

            row += '<td class="id" id="' + result[i].police_station_id + '">' + generateID(result[i].police_station_id) + '</td>';
            row += '<td>' + result[i].police_station + '</td>';
            row += '<td>' + result[i].oic_mobile + '</td>';
            row += '<td>' + result[i].office_phone + '</td>';
            row += '<td>' + result[i].contact_person + '</td>';
            row += '<td class="edit edit_police">';
            row += '<button type="button" class="btn btn-primary setting-edit-btn" id="' + result[i].police_station_id + '" onclick="showModal(' + "'update'" + ',' + "'Police'" + ')">';
            row += '<i class="fa fa-pencil-square-o" aria-hidden="true"></button>';

            row += '</td>';
            row += '<td class="disable disable_police">';
            row += '<label class="switch">';
            row += '<input type="checkbox" id="' + result[i].police_station_id + '" onchange="disable(event,' + "'Police'" + ')" ' + disable[result[i].status] + '>';

        } else if (name == GS_DIVISION) {

            row += '<td class="id" id="' + result[i].gs_division_id + '">' + generateID(result[i].gs_division_id) + '</td>';
            row += '<td>' + result[i].gs_division + '</td>';
            row += '<td>' + result[i].gs_mobile + '</td>';
            row += '<td>' + result[i].office_phone + '</td>';
            row += '<td>' + result[i].contact_person + '</td>';
            row += '<td class="edit edit_gsdivision">';
            row += '<button type="button" class="btn btn-primary setting-edit-btn" id="' + result[i].gs_division_id + '" onclick="showModal(' + "'update'" + ',' + "'GsDivision'" + ')">';
            row += '<i class="fa fa-pencil-square-o" aria-hidden="true"></button>';

            row += '</td>';
            row += '<td class="disable disable_gsdivision">';
            row += '<label class="switch">';
            row += '<input type="checkbox" id="' + result[i].gs_division_id + '" onchange="disable(event,' + "'GsDivision'" + ')" ' + disable[result[i].status] + '>';

        }

        row += '<span class="slider round"></span>';
        row += '</label>';
        row += '</td>';
        row += '</tr>';
        tbody += row;
    }
    $(tableName).empty();
    $(tableName).append(tbody);



    if (!town_edit_permission) {
        $('.edit_town').hide();
    }

    if (!town_disable_permission) {
        $('.disable_town').hide();
    }


    if (!civilstatus_edit_permission) {
        $('.edit_civilstatus').hide();
    }

    if (!civilstatus_disable_permission) {
        $('.disable_civilstatus').hide();
    }


    if (!designation_edit_permission) {
        $('.edit_designation').hide();
    }

    if (!designation_disable_permission) {
        $('.disable_designation').hide();
    }


    if (!status_edit_permission) {
        $('.edit_status').hide();
    }

    if (!status_disable_permission) {
        $('.disable_status').hide();
    }


    if (!site_edit_permission) {
        $('.edit_site').hide();
    }

    if (!site_disable_permission) {
        $('.disable_site').hide();
    }


    if (!department_edit_permission) {
        $('.edit_department').hide();
    }

    if (!department_disable_permission) {
        $('.disable_department').hide();
    }


    if (!section_edit_permission) {
        $('.edit_section').hide();
    }

    if (!section_disable_permission) {
        $('.disable_section').hide();
    }


    if (!subsection_edit_permission) {
        $('.edit_subsection').hide();
    }

    if (!subsection_disable_permission) {
        $('.disable_subsection').hide();
    }

    if (!mohdivision_edit_permission) {
        $('.edit_mohdividion').hide();
    }

    if (!mohdivision_disable_permission) {
        $('.disable_mohdividion').hide();
    }

    if (!police_edit_permission) {
        $('.edit_police').hide();
    }

    if (!police_disable_permission) {
        $('.disable_police').hide();
    }

    if (!gsdivision_edit_permission) {
        $('.edit_gsdivision').hide();
    }

    if (!gsdivision_disable_permission) {
        $('.disable_gsdivision').hide();
    }

}



/**
* generateID
* This function is used to generate id
* @param id This is the paramter to require id
*/
function generateID(id) {

    let pattern = {
        1: "0000",
        2: "000",
        3: "00",
        4: "0",
    };
    var length = Math.ceil(Math.log(id + 1) / Math.LN10);
    return pattern[length] + id;
}



function loadSection_to_SubSection() {

    var url = URL_MAP_SEARCH[SECTION];
    $.ajax({
        type: "GET",
        url: url,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {

                var name = response.data.name;
                var result = response.data.result;
                $('#selcSection').empty();
                for (i = 0; i < result.length; i++) {
                    var section = result[i]['section'];
                    var id = result[i]['section_id'];
                    makeSectionElement(id, section);
                    var section = $('#selcSection').attr('value');
                    setSelected_Section_to_SubSection(section);
                }

            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }

    });
}


function makeSectionElement(id, section) {
    var element = '<option value="' + id + '">' + section + '</option>';
    $('#selcSection').append(element);
}

function setSelected_Section_to_SubSection(section) {
    $("#selcSection option").filter(function () {
        return $(this).text() == section;
    }).prop('selected', true);
}

