<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateEmployeeCategoriesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('hr_employee_categories', function (Blueprint $table) {
            $table->bigIncrements('category_id');
            $table->string('category',200);
            $table->integer('wage_calculate');
            $table->integer('wage_pay_type');
            $table->double('work_days_month');
            $table->double('work_hour_day');
            $table->double('ot_rate1');
            $table->double('ot_rate2');
            $table->double('ot_rate3');
            $table->double('fixed_ot_rate1');
            $table->double('fixed_ot_rate2');
            $table->double('fixed_ot_rate3');
            $table->double('epf_employer');
            $table->double('epf_employee');
            $table->double('etf_employee');
            $table->double('budget_allowance1');
            $table->double('budget_allowance2');
            $table->double('fine_rate');
            $table->boolean('status');
            $table->timestamps();

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('employee_categories');
    }
}
