<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateAttSpcWorkdaysTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('hr_att_spc_workdays', function (Blueprint $table) {
            $table->id();
            $table->date('sp_work_date');
            $table->foreignId('sp_work_type_id');
            $table->foreign('sp_work_type_id')->references('sp_work_type_id')->on('hr_att_sp_work_types')->onDelete('cascade');
            $table->integer('day_type');
            $table->string('remarks',250);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('att_spc_workdays');
    }
}
