<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateAttShiftsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('hr_att_shifts', function (Blueprint $table) {
            $table->id('shift_id');
            $table->string('shift_name',100);
            $table->time('start_time');
            $table->double('duration');
            $table->double('breack_hours');
            $table->double('short_leave_duration');
            $table->time('halfday_time');
            $table->integer('ot_after_minutes');
            $table->double('days_count');
            $table->boolean('status');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('att_shifts');
    }
}
