<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateEmployeeTeamsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('hr_employee_teams', function (Blueprint $table) {
            $table->id('employee_team_id');
            $table->foreignId('team_id');
            $table->foreign('team_id')->references('team_id')->on('hr_teams')->onDelete('cascade');
            $table->string('employee_id', 25);
            $table->foreign('employee_id')->references('employee_id')->on('hr_employees')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('employee_teams');
    }
}
