<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateLeavesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('hr_leaves', function (Blueprint $table) {
            $table->id('leave_id',25)->unique();
            $table->string('employee_id',25);
            $table->string('employee_name',250);           
            $table->date('date');
            //$table->string('photo_parth',250); 
            $table->date('from');
            $table->date('to');
            $table->string('reason',300);  
            $table->foreignId('leave_type_id'); 
            $table->integer('status');  
            $table->string('approved_by',25);        
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('leaves');
    }
}
