<?php

namespace Modules\Hr\Entities;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;
class AttSpWorkType extends Model
{
    protected $table = 'hr_att_sp_work_types';
    protected $primaryKey = 'sp_work_type_id'; 
    use HasFactory,LogsActivity;
    protected static $logAttributes = [
        'sp_work_type_id',
        'sp_work_type',
        'status',
    ];
    protected static $logOnlyDirty = true;
    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->log_name = "hr_att_sp_work_types";
        $activity->description = $eventName;
        $activity->causer_id = Auth::user()->id;
    }
}
