<?php

namespace Modules\Hr\Entities;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;

class DebtorLoan extends Model
{
    protected $table = 'hr_debtor_loans';
    use HasFactory, LogsActivity;
    protected static $logAttributes = [
        'id',
        'employee_id',
        'amount',
        'no_of_terms',
        'interest_percentage',
        'paid_amount',
        'paid_terms',
        'tran_date',
        'deduct_year',
        'deduct_month',
        'requested_by',
        'approved_by',
        'status',
        'reason',
    ];
    protected static $logOnlyDirty = true;
    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->log_name = "hr_debtor_loans";
        $activity->description = $eventName;
        $activity->causer_id = Auth::user()->id;
    }
}
