<?php

namespace Modules\Hr\Entities;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;

class TransactionItem extends Model
{
    protected $table = 'hr_transaction_items';
    protected $primaryKey = 'item_id'; 
    use HasFactory,LogsActivity;
    protected static $logAttributes = [
        'item_id',
        'narration',
        'narration_sinhala',
        'type',
        'status',
    ];
    protected static $logOnlyDirty = true;
    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->log_name = "hr_transaction_items";
        $activity->description = $eventName;
        $activity->causer_id = Auth::user()->id;
    }
}
