<?php

namespace Modules\Hr\Http\Controllers;


use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Hr\Entities\AtdHolidayType;
use Modules\Hr\Entities\AttLeaveType;
use Modules\Hr\Entities\AttSpWorkType;

class AtdSettingsController extends Controller
{
    //
    public function saveHolidayType(Request $request)
    {

        try {
            $holiday = new AtdHolidayType();
            $holiday->holyday_type = $request->get('txtHolidayType');
            $holiday->status = true;
            $save = $holiday->save();
            if ($save) {
                $responseBody = $this->responseBody(true, "AttendanceHolidayType", "saved", null);
            } else {
                $responseBody = $this->responseBody(false, "AttendanceHolidayType", "saved", $save);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "AttendanceHolidayType", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }







    public function saveWorkDayType(Request $request)
    {

        try {
            $workType = new AttSpWorkType();
            $workType->sp_work_type = $request->get('txtSpWorkType');
            $workType->status = true;
            $save = $workType->save();
            if ($save) {
                $responseBody = $this->responseBody(true, "AttendanceSpecialWorkType", "saved", null);
            } else {
                $responseBody = $this->responseBody(false, "AttendanceSpecialWorkType", "saved", $save);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "AttendanceSpecialWorkType", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }


    





    public function saveLeaveType(Request $request)
    {

        try {
            $leaveType = new AttLeaveType();
            $leaveType->leave_type = $request->get('txtLeaveType');
            $leaveType->days_per_year = $request->get('txtDaysPerYear');
            $leaveType->status = true;
            $save = $leaveType->save();
            if ($save) {
                $responseBody = $this->responseBody(true, "AttendanceLeaveType", "saved", null);
            } else {
                $responseBody = $this->responseBody(false, "AttendanceLeaveType", "saved", $save);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "AttendanceLeaveType", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }





    public function allHolidayType()
    {

        try {
            $atd_holidays = AtdHolidayType::all();
            $responseBody = $this->responseBody(true, "Holiday", "allHolidays", $atd_holidays);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Holiday", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }





    
    public function allWorkDayType()
    {

        try {
            $att_sp_work_day = AttSpWorkType::all();
            $responseBody = $this->responseBody(true, "WorkDay", "allWorkDayType", $att_sp_work_day);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "WorkDay", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }






    public function allLeaveType()
    {

        try {
            $att_leave = AttLeaveType::all();
            $responseBody = $this->responseBody(true, "Leave", "allLeaveType", $att_leave);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Leave", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }





    public function holidayType($id)
    {
        try {
            $atd_holiday = AtdHolidayType::find($id);
            $responseBody = $this->responseBody(true, "Holiday", "Holiday", $atd_holiday);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Holiday", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }





    public function workdayType($id)
    {
        try {
            $atd_workday = AttSpWorkType::find($id);
            $responseBody = $this->responseBody(true, "WorkDay", "WorkDay", $atd_workday);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "WorkDay", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }





    public function leaveType($id)
    {
        try {
            $att_leave = AttLeaveType::find($id);
            $responseBody = $this->responseBody(true, "LeaveType", "LeaveType", $att_leave);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "LeaveType", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }





    public function updateHolidayType(Request $request, $id)
    {

        try {
            $holiday = AtdHolidayType::find($id);
            $holiday->holyday_type = $request->get('type');
            $update = $holiday->save();
            if ($update) {
                $responseBody = $this->responseBody(true, "Holiday", "updated", null);
            } else {
                $responseBody = $this->responseBody(false, "Holiday", "not updated", $update);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Holiday", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }





    public function updateWorkdayType(Request $request, $id)
    {

        try {
            $workday = AttSpWorkType::find($id);
            $workday->sp_work_type = $request->get('type');
            $update = $workday->save();
            if ($update) {
                $responseBody = $this->responseBody(true, "WorkDay", "updated", null);
            } else {
                $responseBody = $this->responseBody(false, "WorkDay", "not updated", $update);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "WorkDay", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }





    public function updateLeaveType(Request $request, $id)
    {

        try {
            $leaveType = AttLeaveType::find($id);
            $leaveType->leave_type = $request->get('type');
            $leaveType->days_per_year = $request->get('daysPerYear');
            $update = $leaveType->save();
            if ($update) {
                $responseBody = $this->responseBody(true, "LeaveType", "updated", null);
            } else {
                $responseBody = $this->responseBody(false, "LeaveType", "not updated", $update);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "LeaveType", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }







    public function disableHolidayType(Request $request, $id)
    {

        try {
            $holidayType = AtdHolidayType::find($id);
            $holidayType->status = $request->get('status');
            $disable = $holidayType->save();
            if ($disable) {
                $responseBody = $this->responseBody(true, "Holiday", "disabled", null);
            } else {
                $responseBody = $this->responseBody(false, "Holiday", "not disabled", $disable);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Holiday", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }





    public function disableWorkDayType(Request $request, $id)
    {

        try {
            $spWorkType = AttSpWorkType::find($id);
            $spWorkType->status = $request->get('status');
            $disable = $spWorkType->save();
            if ($disable) {
                $responseBody = $this->responseBody(true, "WorkDay", "disabled", null);
            } else {
                $responseBody = $this->responseBody(false, "WorkDay", "not disabled", $disable);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "WorkDay", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }







    public function disableLeaveType(Request $request, $id)
    {

        try {
            $leaveType = AttLeaveType::find($id);
            $leaveType->status = $request->get('status');
            $disable = $leaveType->save();
            if ($disable) {
                $responseBody = $this->responseBody(true, "LeaveType", "disabled", null);
            } else {
                $responseBody = $this->responseBody(false, "LeaveType", "not disabled", $disable);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "LeaveType", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }






    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
