<?php

namespace Modules\Hr\Http\Controllers;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;

class Employee3Month6MonthController extends Controller
{
    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    public function index()
    {
        return view('hr::index');
    }

    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create()
    {
        return view('hr::create');
    }

    /**
     * Store a newly created resource in storage.
     * @param Request $request
     * @return Renderable
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Show the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function show($id)
    {
        return view('hr::show');
    }

    /**
     * Show the form for editing the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function edit($id)
    {
        return view('hr::edit');
    }

    /**
     * Update the specified resource in storage.
     * @param Request $request
     * @param int $id
     * @return Renderable
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     * @param int $id
     * @return Renderable
     */
    public function destroy($id)
    {
        //
    }



    public function employee_3month_6month_completed()
    {


        $query = "SELECT hr_employees.employee_id,hr_employees.name_withinitial AS employee_name,hr_employee_designations.designation,hr_employee_sites.site,TIMESTAMPDIFF(MONTH,hr_employees.date_join ,CURDATE()) AS month  FROM hr_employees
        INNER JOIN hr_employee_designations ON hr_employees.designation_id = hr_employee_designations.designation_id
        INNER JOIN hr_employee_sites ON hr_employees.site_id = hr_employee_sites.site_id
        WHERE TIMESTAMPDIFF(MONTH,hr_employees.date_join ,CURDATE()) = 3 || TIMESTAMPDIFF(MONTH,hr_employees.date_join ,CURDATE()) = 6 ORDER BY TIMESTAMPDIFF(MONTH,hr_employees.date_join ,CURDATE())";

        try {
            $result =  DB::select($query);
            $responseBody = $this->responseBody(true, "Employee", "all", $result);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "error", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }




    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
