<?php

namespace Modules\Hr\Http\Controllers;

use Carbon\Carbon;
use DateTime;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Modules\Hr\Entities\AttLeaveType;
use Modules\Hr\Entities\AttSchedule;
use Modules\Hr\Entities\AttShift;
use Modules\Hr\Entities\Company;
use Modules\Hr\Entities\Employee;
use Modules\Hr\Entities\EmployeeCategory;
use Modules\Hr\Entities\EmployeeDepartment;
use Modules\Hr\Entities\EmployeeSection;
use Modules\Hr\Entities\EmployeeSite;
use Modules\Hr\Entities\EmployeeSubsection;
use Modules\Hr\Entities\Team;

class ReportAttSheetController extends Controller
{
    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    public function index()
    {
        return view('hr::index');
    }

    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create()
    {
        return view('hr::create');
    }

    /**
     * Store a newly created resource in storage.
     * @param Request $request
     * @return Renderable
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Show the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function show($id)
    {
        return view('hr::show');
    }

    /**
     * Show the form for editing the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function edit($id)
    {
        return view('hr::edit');
    }

    /**
     * Update the specified resource in storage.
     * @param Request $request
     * @param int $id
     * @return Renderable
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     * @param int $id
     * @return Renderable
     */
    public function destroy($id)
    {
        //
    }



    public function allSettings()
    {

        try {
            $settings = [
                "shift" => $this->shift(),
                "category" => $this->category(),
                "site" => $this->site(),
                "section" => $this->section(),
                "department" => $this->department(),
                "company" => $this->company(),
                "team" => $this->team(),
                "employee" => $this->allEmployee(),
            ];
            $responseBody = $this->responseBody(true, "AllSettings", "all", ["settings" => $settings]);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "AllSettings", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }






    public function shift()
    {

        try {
            $shift = AttShift::all();
            $collection = [];
            for ($i = 0; $i < count($shift); $i++) {
                array_push($collection, ["id" => $shift[$i]['shift_id'], "value" => $shift[$i]['shift_name']]);
            }
            return $collection;
        } catch (\Exception $exception) {
            return $exception;
        }
    }




    private function category()
    {

        try {
            $category = EmployeeCategory::all();
            $collection = [];
            for ($i = 0; $i < count($category); $i++) {
                array_push($collection, ["id" => $category[$i]['category_id'], "value" => $category[$i]['category']]);
            }
            return $collection;
        } catch (\Exception $exception) {
            return $exception;
        }
    }


    private function site()
    {

        try {
            $site = EmployeeSite::all();
            $collection = [];
            for ($i = 0; $i < count($site); $i++) {
                array_push($collection, ["id" => $site[$i]['site_id'], "value" => $site[$i]['site']]);
            }
            return $collection;
        } catch (\Exception $exception) {
            return $exception;
        }
    }



    private function department()
    {

        try {
            $department = EmployeeDepartment::all();
            $collection = [];
            for ($i = 0; $i < count($department); $i++) {
                array_push($collection, ["id" => $department[$i]['department_id'], "value" => $department[$i]['department']]);
            }
            return $collection;
        } catch (\Exception $exception) {
            return $exception;
        }
    }


    private function section()
    {

        try {
            $section = EmployeeSection::all();
            $collection = [];
            for ($i = 0; $i < count($section); $i++) {
                array_push($collection, ["id" => $section[$i]['section_id'], "value" => $section[$i]['section']]);
            }
            return $collection;
        } catch (\Exception $exception) {
            return $exception;
        }
    }


    public function subSection($section_id)
    {
        try {
            $subsection = EmployeeSubsection::where('section_id', '=', $section_id)->get();
            $collection = [];
            for ($i = 0; $i < count($subsection); $i++) {
                array_push($collection, ["id" => $subsection[$i]['subsection_id'], "value" => $subsection[$i]['subsection']]);
            }
            $responseBody = $this->responseBody(true, "Subsection", "all", $collection);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Subsection", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    private function company()
    {

        try {
            $company = Company::all();
            $collection = [];
            for ($i = 0; $i < count($company); $i++) {
                array_push($collection, ["id" => $company[$i]['company_id'], "value" => $company[$i]['company']]);
            }
            return $collection;
        } catch (\Exception $exception) {
            return $exception;
        }
    }




    private function team()
    {

        try {
            $team = Team::all();
            $collection = [];
            for ($i = 0; $i < count($team); $i++) {
                array_push($collection, ["id" => $team[$i]['team_id'], "value" => $team[$i]['team_name']]);
            }
            return $collection;
        } catch (\Exception $exception) {
            return $exception;
        }
    }





    private function allEmployee()
    {
        try {
            $employees = Employee::all();

            $collection = [];
            for ($i = 0; $i < count($employees); $i++) {
                array_push($collection, ["img" => $employees[$i]['photo_parth'], "id" => $employees[$i]['employee_id'], "value" => $employees[$i]['name_withinitial']]);
            }
            return $collection;
        } catch (\Exception $exception) {
            return $exception;
        }
    }





    public function attendanceReport_test($setting)
    {
        try {
            $setting_aaray =  json_decode($setting);
            $category = $setting_aaray->category;
            $site = $setting_aaray->site;
            $department = $setting_aaray->department;
            $section = $setting_aaray->section;
            $subsection = $setting_aaray->subsection;
            $company = $setting_aaray->company;
            $team = $setting_aaray->team;
            $employee = $setting_aaray->employee;
            $startDate = $setting_aaray->startDate;
            $endDate = $setting_aaray->endDate;

            ini_set('max_execution_time', '0'); // for infinite time of execution

            $query = "SELECT
            hr_employees.`employee_id` AS employee_id,
            hr_employees.`name_withinitial` AS employees_name,
            hr_employees.`attendance_id` AS attendance_id,
            hr_att_time.`InTime` AS att_InTime,
            hr_att_time.`OutTime` AS att_OutTime,
            hr_att_time.`Date` AS att_date,
            hr_att_time.`Day_Type` AS Day_Type,
            hr_att_time.`Worked_Day` AS Worked_Day,
            hr_att_time.`Overtime` AS Overtime,
            hr_att_time.`NoPay` AS NoPay,
            hr_att_time.`LeaveType` AS LeaveType,
            hr_att_time.`Late_Arriver` AS Late_Arriver,
            hr_att_time.`Early_Departure` AS Early_Departure
            FROM
            `hr_employees` hr_employees INNER JOIN `hr_att_time` hr_att_time ON hr_employees.`attendance_id` = hr_att_time.`EmployeeID` WHERE ";

            if ($category != '') {
                $query .= "hr_employees.category_id = '" . $category . "' AND ";
            }

            if ($site != '') {
                $query .= "hr_employees.site_id = '" . $site . "' AND ";
            }

            if ($department != '') {
                $query .= "hr_employees.department_id = '" . $department . "' AND ";
            }

            if ($section != '') {
                $query .= "hr_employees.section_id = '" . $section . "' AND ";
            }

            if ($subsection != '') {
                $query .= "hr_employees.subsection_id = '" . $subsection . "' AND ";
            }

            if ($company != '') {
                $query .= "hr_employees.company_id = '" . $company . "' AND ";
            }

            if ($employee != '') {
                $query .= "hr_employees.employee_id = '" . $employee . "' AND ";
            }

            if ($team != '') {
                $query = "SELECT
                hr_employees.`employee_id` AS employee_id,
                hr_employees.`name_withinitial` AS employees_name,
                hr_employees.`attendance_id` AS attendance_id,
                hr_att_time.`InTime` AS att_InTime,
                hr_att_time.`OutTime` AS att_OutTime,
                hr_att_time.`Date` AS att_date,
                hr_att_time.`Day_Type` AS Day_Type,
                hr_att_time.`Worked_Day` AS Worked_Day,
                hr_att_time.`Overtime` AS Overtime,
                hr_att_time.`NoPay` AS NoPay,
                hr_att_time.`LeaveType` AS LeaveType,
                hr_att_time.`Late_Arriver` AS Late_Arriver,
                hr_att_time.`Early_Departure` AS Early_Departure
           FROM
                `hr_employees` hr_employees INNER JOIN `hr_att_time` hr_att_time ON hr_employees.`attendance_id` = hr_att_time.`EmployeeID`
                INNER JOIN `hr_employee_teams` hr_employee_teams ON hr_employees.`employee_id` = hr_employee_teams.`employee_id` WHERE hr_employee_teams.team_id = '" . $team . "' AND ";
            }

            $query = preg_replace('/\W\w+\s*(\W*)$/', '$1', $query);
            $query .= " AND hr_att_time.`Date`  BETWEEN '" . $startDate . "' AND '" . $endDate . "'";

            $result = DB::select($query);
            foreach ($result as $row) {

                $query = "SELECT
                hr_att_shifts.`shift_name` AS shift_name,
                hr_att_shifts.`duration` AS duration,
                hr_att_schedules.`schedule_date_from` AS date_from,
                hr_att_schedules.`in_time` AS in_time,
                hr_att_schedules.`out_time` AS out_time
                FROM
                `hr_employees` hr_employees INNER JOIN `hr_att_schedules` hr_att_schedules ON hr_employees.`employee_id` = hr_att_schedules.`employee_id`
                INNER JOIN `hr_att_shifts` hr_att_shifts ON hr_att_schedules.`shift_id` = hr_att_shifts.`shift_id` WHERE hr_employees.`employee_id` = '" . $row->employee_id . "' AND hr_att_schedules.`schedule_date_from` = '" . $row->att_date . "'";

                $schedule = DB::select($query);
                if (count($schedule) > 0) {

                    $row->shift_start_time = $schedule[0]->in_time;
                    $row->shift_end_time = $schedule[0]->out_time;
                    $row->shift_name = $schedule[0]->shift_name;
                } else {
                    $row->shift_start_time = '';
                    $row->shift_end_time = '';
                    $row->shift_name = '';
                }

                $d    = new DateTime($row->att_date);
                $row->day = substr($d->format('l'), 0, 1);
            }


            $employees = Employee::all();
            $attendance_report_array = array();
            foreach ($employees as $employee) {
                $attendance_array = array();
                foreach ($result as $attendance) {
                    if ($employee->employee_id == $attendance->employee_id) {
                        array_push($attendance_array, $attendance);
                    }
                }
                if (count($attendance_array) > 0) {
                    array_push($attendance_report_array, ["header" => $employee, "body" => $attendance_array]);
                }
            }
            $responseBody = $this->responseBody(true, "Attendance", "all", $attendance_report_array);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Attendance", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }







    public function detailsReport_test($setting)
    {
        try {
            $setting_aaray =  json_decode($setting);
            $category = $setting_aaray->category;
            $site = $setting_aaray->site;
            $department = $setting_aaray->department;
            $section = $setting_aaray->section;
            $subsection = $setting_aaray->subsection;
            $company = $setting_aaray->company;
            $team = $setting_aaray->team;
            $employee = $setting_aaray->employee;
            $startDate = $setting_aaray->startDate;
            $endDate = $setting_aaray->endDate;

            ini_set('max_execution_time', '0'); // for infinite time of execution
            
            $query = "SELECT
            hr_employees.`employee_id` AS employee_id,
            hr_employees.`name_withinitial` AS employees_name,
            hr_employees.`attendance_id` AS attendance_id,
            hr_att_time.`InTime` AS att_InTime,
            hr_att_time.`OutTime` AS att_OutTime,
            hr_att_time.`Date` AS att_date,
            hr_att_time.`Day_Type` AS Day_Type,
            hr_att_time.`Worked_Day` AS Worked_Day,
            hr_att_time.`Overtime` AS Overtime,
            hr_att_time.`NoPay` AS NoPay,
            hr_att_time.`LeaveType` AS LeaveType,
            hr_att_time.`Late_Arriver` AS Late_Arriver,
            hr_att_time.`Early_Departure` AS Early_Departure
            FROM
            `hr_employees` hr_employees INNER JOIN `hr_att_time` hr_att_time ON hr_employees.`attendance_id` = hr_att_time.`EmployeeID` WHERE ";

            if ($category != '') {
                $query .= "hr_employees.category_id = '" . $category . "' AND ";
            }

            if ($site != '') {
                $query .= "hr_employees.site_id = '" . $site . "' AND ";
            }

            if ($department != '') {
                $query .= "hr_employees.department_id = '" . $department . "' AND ";
            }

            if ($section != '') {
                $query .= "hr_employees.section_id = '" . $section . "' AND ";
            }

            if ($subsection != '') {
                $query .= "hr_employees.subsection_id = '" . $subsection . "' AND ";
            }

            if ($company != '') {
                $query .= "hr_employees.company_id = '" . $company . "' AND ";
            }

            if ($employee != '') {
                $query .= "hr_employees.employee_id = '" . $employee . "' AND ";
            }

            if ($team != '') {
                $query = "SELECT
                hr_employees.`employee_id` AS employee_id,
                hr_employees.`name_withinitial` AS employees_name,
                hr_employees.`attendance_id` AS attendance_id,
                hr_att_time.`InTime` AS att_InTime,
                hr_att_time.`OutTime` AS att_OutTime,
                hr_att_time.`Date` AS att_date,
                hr_att_time.`Day_Type` AS Day_Type,
                hr_att_time.`Worked_Day` AS Worked_Day,
                hr_att_time.`Overtime` AS Overtime,
                hr_att_time.`NoPay` AS NoPay,
                hr_att_time.`LeaveType` AS LeaveType,
                hr_att_time.`Late_Arriver` AS Late_Arriver,
                hr_att_time.`Early_Departure` AS Early_Departure
           FROM
                `hr_employees` hr_employees INNER JOIN `hr_att_time` hr_att_time ON hr_employees.`attendance_id` = hr_att_time.`EmployeeID`
                INNER JOIN `hr_employee_teams` hr_employee_teams ON hr_employees.`employee_id` = hr_employee_teams.`employee_id` WHERE hr_employee_teams.team_id = '" . $team . "' AND ";
            }

            $query = preg_replace('/\W\w+\s*(\W*)$/', '$1', $query);
            $query .= " AND hr_att_time.`Date`  BETWEEN '" . $startDate . "' AND '" . $endDate . "'";

            $result = DB::select($query);
            foreach ($result as $row) {

                $query = "SELECT
                hr_att_shifts.`shift_name` AS shift_name,
                hr_att_shifts.`duration` AS duration,
                hr_att_schedules.`schedule_date_from` AS date_from,
                hr_att_schedules.`in_time` AS in_time,
                hr_att_schedules.`out_time` AS out_time
                FROM
                `hr_employees` hr_employees INNER JOIN `hr_att_schedules` hr_att_schedules ON hr_employees.`employee_id` = hr_att_schedules.`employee_id`
                INNER JOIN `hr_att_shifts` hr_att_shifts ON hr_att_schedules.`shift_id` = hr_att_shifts.`shift_id` WHERE hr_employees.`employee_id` = '" . $row->employee_id . "' AND hr_att_schedules.`schedule_date_from` = '" . $row->att_date . "'";

                $schedule = DB::select($query);
                if (count($schedule) > 0) {

                    $row->shift_start_time = $schedule[0]->in_time;
                    $row->shift_end_time = $schedule[0]->out_time;
                    $row->shift_name = $schedule[0]->shift_name;
                    $row->shift_duration = $schedule[0]->duration;
                } else {
                    $row->shift_start_time = '';
                    $row->shift_end_time = '';
                    $row->shift_name = '';
                }

                $leaveType = AttLeaveType::find($row->LeaveType);
                if ($leaveType) {
                    $row->leave_type = $leaveType->leave_type;
                }

                $d    = new DateTime($row->att_date);
                $row->day = substr($d->format('l'), 0, 1);
            }


            $employees = Employee::all();
            $attendance_report_array = array();
            foreach ($employees as $employee) {
                $attendance_array = array();
                foreach ($result as $attendance) {
                    if ($employee->employee_id == $attendance->employee_id) {
                        array_push($attendance_array, $attendance);
                    }
                }
                if (count($attendance_array) > 0) {
                    array_push($attendance_report_array, ["header" => $employee, "body" => $attendance_array]);
                }
            }
            $responseBody = $this->responseBody(true, "Attendance", "all", $attendance_report_array);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Attendance", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    public function attendanceMissingReport($setting)
    {
        try {
            $setting_aaray =  json_decode($setting);
            $category = $setting_aaray->category;
            $site = $setting_aaray->site;
            $department = $setting_aaray->department;
            $section = $setting_aaray->section;
            $subsection = $setting_aaray->subsection;
            $company = $setting_aaray->company;
            $team = $setting_aaray->team;
            $employee = $setting_aaray->employee;
            $startDate = $setting_aaray->startDate;
            $endDate = $setting_aaray->endDate;

            ini_set('max_execution_time', '0'); // for infinite time of execution

            $query = "SELECT
            hr_employees.`employee_id` AS employee_id,
            hr_employees.`name_withinitial` AS employees_name,
            hr_employees.`attendance_id` AS attendance_id,
            hr_att_time.`InTime` AS att_InTime,
            hr_att_time.`OutTime` AS att_OutTime,
            hr_att_time.`Date` AS att_date,
            hr_att_time.`Day_Type` AS Day_Type,
            hr_att_time.`Worked_Day` AS Worked_Day,
            hr_att_time.`Overtime` AS Overtime,
            hr_att_time.`NoPay` AS NoPay,
            hr_att_time.`LeaveType` AS LeaveType,
            hr_att_time.`Late_Arriver` AS Late_Arriver,
            hr_att_time.`Early_Departure` AS Early_Departure
            FROM
            `hr_employees` hr_employees INNER JOIN `hr_att_time` hr_att_time ON hr_employees.`attendance_id` = hr_att_time.`EmployeeID` WHERE ";

            if ($category != '') {
                $query .= "hr_employees.category_id = '" . $category . "' AND ";
            }

            if ($site != '') {
                $query .= "hr_employees.site_id = '" . $site . "' AND ";
            }

            if ($department != '') {
                $query .= "hr_employees.department_id = '" . $department . "' AND ";
            }

            if ($section != '') {
                $query .= "hr_employees.section_id = '" . $section . "' AND ";
            }

            if ($subsection != '') {
                $query .= "hr_employees.subsection_id = '" . $subsection . "' AND ";
            }

            if ($company != '') {
                $query .= "hr_employees.company_id = '" . $company . "' AND ";
            }

            if ($employee != '') {
                $query .= "hr_employees.employee_id = '" . $employee . "' AND ";
            }

            if ($team != '') {
                $query = "SELECT
                hr_employees.`employee_id` AS employee_id,
                hr_employees.`name_withinitial` AS employees_name,
                hr_employees.`attendance_id` AS attendance_id,
                hr_att_time.`InTime` AS att_InTime,
                hr_att_time.`OutTime` AS att_OutTime,
                hr_att_time.`Date` AS att_date,
                hr_att_time.`Day_Type` AS Day_Type,
                hr_att_time.`Worked_Day` AS Worked_Day,
                hr_att_time.`Overtime` AS Overtime,
                hr_att_time.`NoPay` AS NoPay,
                hr_att_time.`LeaveType` AS LeaveType,
                hr_att_time.`Late_Arriver` AS Late_Arriver,
                hr_att_time.`Early_Departure` AS Early_Departure
           FROM
                `hr_employees` hr_employees INNER JOIN `hr_att_time` hr_att_time ON hr_employees.`attendance_id` = hr_att_time.`EmployeeID`
                INNER JOIN `hr_employee_teams` hr_employee_teams ON hr_employees.`employee_id` = hr_employee_teams.`employee_id` WHERE hr_employee_teams.team_id = '" . $team . "' AND ";
            }

            $query = preg_replace('/\W\w+\s*(\W*)$/', '$1', $query);
            $query .= " AND hr_att_time.`Date`  BETWEEN '" . $startDate . "' AND '" . $endDate . "' AND hr_att_time.`InTime` IS NULL OR hr_att_time.`OutTime` IS NULL ";

            $result = DB::select($query);
            foreach ($result as $row) {

                $query = "SELECT
                hr_att_shifts.`shift_name` AS shift_name,
                hr_att_shifts.`duration` AS duration,
                hr_att_schedules.`schedule_date_from` AS date_from,
                hr_att_schedules.`in_time` AS in_time,
                hr_att_schedules.`out_time` AS out_time
                FROM
                `hr_employees` hr_employees INNER JOIN `hr_att_schedules` hr_att_schedules ON hr_employees.`employee_id` = hr_att_schedules.`employee_id`
                INNER JOIN `hr_att_shifts` hr_att_shifts ON hr_att_schedules.`shift_id` = hr_att_shifts.`shift_id` WHERE hr_employees.`employee_id` = '" . $row->employee_id . "' AND hr_att_schedules.`schedule_date_from` = '" . $row->att_date . "'";

                $schedule = DB::select($query);
                if (count($schedule) > 0) {

                    $row->shift_start_time = $schedule[0]->in_time;
                    $row->shift_end_time = $schedule[0]->out_time;
                    $row->shift_name = $schedule[0]->shift_name;
                } else {
                    $row->shift_start_time = '';
                    $row->shift_end_time = '';
                    $row->shift_name = '';
                }

                $d    = new DateTime($row->att_date);
                $row->day = substr($d->format('l'), 0, 1);
            }


            $employees = Employee::all();
            $attendance_report_array = array();
            foreach ($employees as $employee) {
                $attendance_array = array();
                foreach ($result as $attendance) {
                    if ($employee->employee_id == $attendance->employee_id) {
                        array_push($attendance_array, $attendance);
                    }
                }
                if (count($attendance_array) > 0) {
                    array_push($attendance_report_array, ["header" => $employee, "body" => $attendance_array]);
                }
            }
            $responseBody = $this->responseBody(true, "Attendance", "all", $attendance_report_array);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Attendance", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }




    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
