<?php

namespace Modules\Hr\Http\Controllers;

use DateTime;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Modules\St\Entities\UserEmployee;

class SupervisorApprovalController extends Controller
{
    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    public function index()
    {
        return view('hr::index');
    }

    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create()
    {
        return view('hr::create');
    }

    /**
     * Store a newly created resource in storage.
     * @param Request $request
     * @return Renderable
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Show the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function show($id)
    {
        return view('hr::show');
    }

    /**
     * Show the form for editing the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function edit($id)
    {
        return view('hr::edit');
    }

    /**
     * Update the specified resource in storage.
     * @param Request $request
     * @param int $id
     * @return Renderable
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     * @param int $id
     * @return Renderable
     */
    public function destroy($id)
    {
        //
    }


    public function attendance($uid, $date)
    {
        try {
            $query = "SELECT
                hr_employees.`name_withinitial` AS name_withinitial,
                hr_employees.`employee_id` AS employee_id,
                hr_att_time.`InTime` AS InTime,
                hr_att_time.`OutTime` AS OutTime,
                hr_att_time.`ID` AS att_id,
                hr_att_time.`supervisor_approval` AS approval,
                hr_att_time.`remark` AS remark
           FROM
                `hr_employees` hr_employees INNER JOIN `hr_att_time` hr_att_time ON hr_employees.`attendance_id` = hr_att_time.`EmployeeID` WHERE hr_employees.`supervisor_id` = '" . $uid . "' AND hr_att_time.`Date`  ='" . $date . "'";

            $result = DB::select($query);
            $responseBody = $this->responseBody(true, "Attendance", "all", $result);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Attendance", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    public function approval(Request $request)
    {
        try {
            $data =  json_decode($request->get('data'), true);
            $uid = $request->get('user_id');
            $date = $request->get('date');



            foreach ($data as $d) {
                $id = json_decode($d)[0];
                $approval = json_decode($d)[1];
                $remark = json_decode($d)[2];
                if ($approval == true) {
                    $approval = 1;
                } else if ($approval == false) {
                    $approval = 0;
                }
                if ($remark == '') {
                    $remark = 'null';
                }
                $query = "UPDATE `hr_att_time` SET supervisor_id = '" . $uid . "', remark = '" . $remark . "',supervisor_approval = '" . $approval . "' WHERE ID = '" . $id . "' AND Date = '" . $date . "'";
                DB::update($query);
            }
            $responseBody = $this->responseBody(true, "Attendance", "saved", null);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Attendance", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }




    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
