var events = [];

$(document).ready(function () {
    $('#calendar-demo').fullCalendar({
        header: {
            left: 'prev,next today',
            center: 'title',
            right: 'month,agendaWeek,agendaDay,listMonth'
        },
        editable: true,
        droppable: true,
        drop: function () {
            $(this).remove();

        },
        weekNumbers: true,
        eventLimit: false, // allow "more" link when too many events
        dayClick: function () {
            $('#createEventModal').modal();
        },
        eventClick: function (event, jsEvent, view) {
            var modal = $('#viewEventModal');
            modal.find('.event-icon').html("<i class='fa fa-" + event.icon + "'></i>");
            modal.find('.event-title').html(event.title);
            modal.find('.event-body').html(event.description);
            modal.modal();
        },
    });
});




function addShedule(shift_id, title, start_day, end_day, in_time, out_time) {
    var dt = new Date(end_day);
    var R = (parseInt(shift_id) *  215);
    if (R > 255) R = (R - 255);
    var G = (parseInt(shift_id) * 100);
    if (G > 255) R = (G - 255);
    var B = (parseInt(shift_id) * 50);
    if (B > 255) R = (B - 255);

    events.push({
        title: title,
        start: start_day,
        end: end_day,
        backgroundColor: 'rgb(' + R + ',' + G + ',' + B + ')',
        icon: "building-o",
        description: '<table><tr><td>Start Date : </td><td>' + start_day + '</td></tr><tr><td>End Date : </td><td>' + dt.getFullYear() + '-' + (dt.getMonth() + 1) + '-' + dt.getDate() + '</td></tr><tr><td>In time : </td><td>' + in_time + '</td></tr><tr><td>Out time : </td><td>' + out_time + '</td></tr></table>',
    });

}





function addHoliday(holiday_id, title, start_day, end_day, in_time, out_time) {
    var dt = new Date(end_day);
    /*var R = (parseInt(holiday_id) *  215);
    if (R > 255) R = (R - 255);
    var G = (parseInt(holiday_id) * 100);
    if (G > 255) R = (G - 255);
    var B = (parseInt(holiday_id) * 50);
    if (B > 255) R = (B - 255);*/

    events.push({
        title: title,
        start: start_day,
        end: end_day,
        backgroundColor: 'rgb(255,69,0)',
        icon: "building-o",
        description: '<table><tr><td>Start Date : </td><td>' + start_day + '</td></tr><tr><td>End Date : </td><td>' + dt.getFullYear() + '-' + (dt.getMonth() + 1) + '-' + dt.getDate() + '</td></tr><tr><td>In time : </td><td>' + in_time + '</td></tr><tr><td>Out time : </td><td>' + out_time + '</td></tr></table>',
    });

}


function clearCalander() {
    $('#calendar-demo').fullCalendar('removeEvents');
    events = [];
}


function createCalendar() {
    $('#calendar-demo').fullCalendar('removeEvents');
    $('#calendar-demo').fullCalendar('addEventSource', events);

}