
$(document).ready(function () {
    $('#tblLoan').DataTable({
        "scrollX": true,
        "order": [],
        "columns": [
            { "data": "employee_id" },
            { "data": "name_full" },
            { "data": "amount", className: "amount" },
            { "data": "month" },
            { "data": "year" },
            { "data": "edit", className: "edit" },
            { "data": "view", className: "view" },
            { "data": "delete", className: "delete" },
        ],
        columnDefs: [
            { width: 80, targets: 0 },
            { width: 100, targets: 2 },
            { width: 50, targets: 3 },
            { width: 50, targets: 4 },
            { width: 20, targets: 5 },
            { width: 20, targets: 6 },
            { width: 20, targets: 7 },
        ],
    });
    allLoan();
});


function allLoan() {

    $.ajax({
        type: "GET",
        url: "/hr/debtorLoan/allLoan",
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                appendTableRow(response.data.result);
            }
            //alert(response);
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {
            $('#selcSection').trigger('change');
        }

    });

}





function appendTableRow(result) {

    var data = [];
    for (i = 0; i < result.length; i++) {
        var id = result[i]['id'];
        var employee_id = result[i]['employee_id'];
        var name = result[i]['name'];
        var amount = result[i]['amount'];
        var year = result[i]['year'];
        var month = result[i]['month'];
        var status = result[i]['status'];
        var string_id = "'" + id + "'";


        var disabled = "";
        if (status == 1) {
            disabled = "disabled";
        }
        data.push({
            "employee_id": employee_id,
            "name_full": name,
            "amount": amount.toFixed(2),
            "year": year,
            "month": monthLabel(month),
            "edit": '<button class="btn btn-primary" onclick="edit(' + id + ')" ' + disabled + '><i class="fa fa-pencil-square-o" aria-hidden="true"></i></button>',
            "view": '<button class="btn btn-success" onclick="view(' + id + ')"><i class="fa fa-eye" aria-hidden="true"></i></button>',
            "delete": '<button class="btn btn-danger" onclick="_delete(' + id + ')" ' + disabled + '><i class="fa fa-trash" aria-hidden="true"></i></button>',
        });
    }

    var table = $('#tblLoan').DataTable();
    table.clear();
    table.rows.add(data).draw();
    table.columns('.edit').visible(false);
    table.columns('.view').visible(false);
    table.columns('.delete').visible(false);



    if (edit_permission == 1) {
        table.columns('.edit').visible(true);
    }

    if (view_permission == 1) {
        table.columns('.view').visible(true);
    }

    if (delete_permission == 1) {
        table.columns('.delete').visible(true);
    }

}





function edit(id) {
    location.href = "/hr/debtorLoan?" + id;
}


function view(id) {
    location.href = "/hr/debtorLoan?" + id + "&view";
}



function _delete(id) {

    swal({
        title: "Are you sure?",
        //text: "Once deleted, you will not be able to recover this record!",
        icon: "warning",
        buttons: true,
        dangerMode: true,
    })
        .then((willDelete) => {
            if (willDelete) {
                do_delete(id);
            }
        });
}





function do_delete(id) {

    $.ajax({
        type: 'DELETE',
        url: '/hr/debtorLoan/deleteLoanFromID/' + id,
        data: {
            _token: $('input[name=_token]').val()
        },
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                showSuccessMessage("Loan has been deleted successfully...");
                allLoan();

            } else {
                showErrorMessage();
            }
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }

    });


}





function monthLabel(id) {
    var month = {
        1: "January",
        2: "February",
        3: "March",
        4: "April",
        5: "May",
        6: "June",
        7: "July",
        8: "August",
        9: "September",
        10: "October",
        11: "November",
        12: "December",
    };

    return month[id];
}



/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {
    toastr.success(message);
}


/**
* showWarningMessage
* This function is used to show warning message.
* @param message This is the paramter to require message content
*/
function showWarningMessage(message) {
    toastr.warning(message);
}



/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}
