$(document).ready(function () {

    getRecruitment(1);

});



function getRecruitment(page_id) {

    $.ajax({
        type: "GET",
        url: "/hr/recruitment/allRecruitment",
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {
                var data = [];
                for (i = 0; i < response.data.result.length; i++) {
                    var id = response.data.result[i]['recruitment_id'];
                    var job_role = response.data.result[i]['job_role'];
                    var no_of_vacant = response.data.result[i]['no_of_vacant'];
                    var string_id = "'" + id + "'";
                    data.push({
                        "recruitment_id": id,
                        "job_role": job_role,
                        "no_of_vacant":no_of_vacant,
                        "edit": '<button class="btn btn-primary" onclick="edit(' + string_id + ')"><i class="fa fa-pencil-square-o" aria-hidden="true"></i></button>',
                        "view": '<button class="btn btn-success" onclick="view(' + string_id + ')"><i class="fa fa-eye" aria-hidden="true"></i></button>',
                        "delete": '<button class="btn btn-danger" onclick="_delete(' + string_id + ')"><i class="fa fa-trash" aria-hidden="true"></i></button>'
                    });
                }

                $('#myTable').DataTable({
                    destroy: true,
                    responsive: true,
                    "order": [],
                    "data": data,
                    "columns": [
                        { "data": "recruitment_id" },
                        { "data": "job_role" },
                        {"data": "no_of_vacant"},
                        { "data": "edit" },
                        { "data": "view" },
                        { "data": "delete" },
                    ],
                });


            } else {
                showErrorMessage();
            }
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {

        }

    });

}

function edit(id) {
    location.href = "/hr/recruitment_request?" + id;

}

function view(id) {
    location.href = "/hr/recruitment_request?" + id + "&view";
}


function _delete(id) {
    $.ajax({
        type: 'DELETE',
        url: '/hr/recruitment/' + id,
        data: {
            _token: $('input[name=_token]').val()
        },
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                showSuccessMessage("Recruitment has been deleted successfully...")
                getRecruitment(1);
            } else {
                showErrorMessage();
            }
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }

    });
}

/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {

    toastr.success(message);
}



/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}



