
var shift_id = null;

$(document).ready(function () {

    $('#tblShift').DataTable({
        "scrollX": true,
        "order": [],
        "columns": [
            { "data": "shiftName" },
            { "data": "startTime" },
            { "data": "hours" },
            { "data": "minutes" },
            { "data": "breackHours" },
            { "data": "shortLeaveDuration" },
            { "data": "halfdayTime" },
            { "data": "otAfterMinutes" },
            { "data": "daysCount" },
            { "data": "edit", className: "edit" },
            { "data": "view", className: "view" },
            { "data": "delete", className: "delete" },
            { "data": "status", className: "disable" },
        ],
        columnDefs: [
            { width: 100, targets: 0 },
            { width: 50, targets: 10 },
            { width: 50, targets: 11 },
            { width: 50, targets: 12 },
        ],
    });


    allShift();

    $('#txtDurationMinutes').on('input', function () {
        var mm = $(this).val();
        if (mm >= 60) {
            var hh = $('#txtDurationHours').val();
            console.log(hh);
            var tot = (parseInt(hh) + 1);
            $('#txtDurationHours').val(tot);
            $(this).val(0);
        }
    });

});


function showModal() {
    resetShift();

    $('#shiftAddModal').modal('toggle');
}



function hideModal() {
    $('#shiftAddModal').modal('hide');
}



function resetShift() {
    $('#shiftAddModalTitle').text('Add New Shift');
    $('#frmShift').trigger("reset");
    $('#btnAction').show();
    $('#btnAction').text('Save');
    $('#txtDurationHours').val(0);
    $('#txtDurationMinutes').val(0);
    $('#txtBreackHours').val(0);
    $('#txtShortLeaveDuration').val(0);
}



function actionBtn() {

    var text = $('#btnAction').text();
    if (text == "Save") {
        save();
    } else if (text == "Update") {
        update();
    }
}




$(document).ready(function () {

    $('.clockpicker-example').clockpicker({
        autoclose: true,
        use24hours: true,
    });

});



function edit(id) {
    getShift("Edit", id);
}


function view(id) {

    getShift("View", id);

}


function _delete(id) {
    alert(id);
}




/**
* save
* This function is used to save employee shift.
*/
function save() {

    var form = $('#frmShift').get(0);
    var data = new FormData(form);

    $.ajax({
        type: "POST",
        url: "/hr/shift/store",
        data: data,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            if (response.data.success == true) {
                showSuccessMessage("Employe shift has been saved successfully...");
                hideModal();
                allShift();
            } else {
                showErrorMessage();

            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }

    });
}




function update() {

    $.ajax({
        type: 'PUT',
        url: '/hr/shift/update/' + shift_id,
        data: $('#frmShift').serialize(),
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {
                showSuccessMessage("Shift has been updated successfully...");
                hideModal();
                resetShift();
                allShift();
            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error.message);
            showErrorMessage();
        },
        complete: function () {

        }

    });
}






function _delete(id) {

    $.ajax({
        type: 'DELETE',
        url: '/hr/shift/delete/' + id,
        data: {
            _token: $('input[name=_token]').val()
        },
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                showSuccessMessage("Shift has been deleted successfully...");
                allShift();
            } else {

                var msg = response.data.message;

                if (msg == "assigned") {//assigned settings cannot be disabled
                    showWarningMessage("Shift has been assigned...!");
                    allShift();
                } else if (msg == "error") {
                    showErrorMessage();
                }
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }
    });
}







function disable(event, id) {
    var status = 0;
    if (event.target.checked) {
        status = 1;
    }

    $.ajax({
        type: 'PUT',
        url: '/hr/shift/disable/' + id,
        data: {
            _token: $('input[name=_token]').val(),
            "status": status
        },
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {

                if (status == 0) {
                    showSuccessMessage("Shift has been disabled successfully...");
                } else {
                    showSuccessMessage("Shift has been enabled successfully...");
                }
                allShift();
            } else {
                var msg = response.data.message;
                var id = response.data.result;

                if (msg == "assigned") {//assigned settings cannot be disabled
                    showWarningMessage("Shift has been assigned...!");
                    allShift();
                } else if (msg == "error") {
                    showErrorMessage();
                }
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }

    });
}







function getShift(event, id) {

    $.ajax({
        type: "GET",
        url: '/hr/shift/getShift/' + id,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                showModal();

                var result = response.data.result;
                shift_id = result.shift_id;

                var duration = parseFloat(result.duration);
                var hh = Math.floor(duration);
                var mm = Math.round((duration - hh) * 60.0);

                $('#shiftAddModalTitle').text('Update Shift');
                $('#txtShiftName').val(result.shift_name);
                setSelectedOption('cmbDaysCount', result.days_count);
                $('#txtStartTime').val(result.start_time);
                $('#txtDurationHours').val(hh);
                $('#txtDurationMinutes').val(mm);
                $('#txtBreackHours').val(result.breack_hours);
                $('#txtShortLeaveDuration').val(result.short_leave_duration);
                $('#txtHalfdayTime').val(result.halfday_time);
                $('#txtOtAfterMinutes').val(result.ot_after_minutes);
                $('#btnAction').text('Update');

                if (event == "Edit") {
                    $('#btnAction').show();
                } else if (event == "View") {
                    $('#btnAction').hide();
                }


            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }

    });
}





function allShift() {
    $.ajax({
        type: "GET",
        url: "/hr/shift/allShift",
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {
                var data = [];
                for (i = 0; i < response.data.result.length; i++) {

                    var id = response.data.result[i]['shift_id'];
                    var shiftName = response.data.result[i]['shift_name'];
                    var startTime = response.data.result[i]['start_time'];
                    var duration = response.data.result[i]['duration'];
                    var breackHours = response.data.result[i]['breack_hours'];
                    var shortLeaveDuration = response.data.result[i]['short_leave_duration'];
                    var halfdayTime = response.data.result[i]['halfday_time'];
                    var otAfterMinutes = response.data.result[i]['ot_after_minutes'];
                    var daysCount = response.data.result[i]['days_count'];
                    var status = response.data.result[i]['status'];

                    var hours = Math.floor(duration);
                    var minutes = Math.round((duration - hours) * 60.0);
                    var string_id = "'" + id + "'";
                    var status = "";
                    if (response.data.result[i]['status'] == 1) {
                        status = "checked";
                    }
                    data.push({
                        "shiftName": shiftName,
                        "startTime": startTime,
                        "hours": hours,
                        "minutes": minutes,
                        "breackHours": breackHours,
                        "shortLeaveDuration": shortLeaveDuration,
                        "halfdayTime": halfdayTime,
                        "otAfterMinutes": otAfterMinutes,
                        "daysCount": daysCount,
                        "edit": '<button class="btn btn-primary" onclick="edit(' + string_id + ')"><i class="fa fa-pencil-square-o" aria-hidden="true"></i></button>',
                        "view": '<button class="btn btn-success" onclick="view(' + string_id + ')"><i class="fa fa-eye" aria-hidden="true"></i></button>',
                        "delete": '<button class="btn btn-danger" onclick="_delete(' + string_id + ')"><i class="fa fa-trash" aria-hidden="true"></i></button>',
                        "status": '<label class="switch"><input type="checkbox" id="1" onchange="disable(event,' + string_id + ')" ' + status + '><span class="slider round"></span></label>'
                    });
                }

                var table = $('#tblShift').DataTable();
                table.clear();
                table.rows.add(data).draw();
                table.columns('.edit').visible(false);
                table.columns('.view').visible(false);
                table.columns('.delete').visible(false);
                table.columns('.disable').visible(false);



                if (edit_permission == 1) {
                    table.columns('.edit').visible(true);
                }

                if (view_permission == 1) {
                    table.columns('.view').visible(true);
                }

                if (delete_permission == 1) {
                    table.columns('.delete').visible(true);
                }

                if (disable_permission == 1) {
                    table.columns('.disable').visible(true);
                }



            } else {
                showErrorMessage();
            }
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {

        }

    });
}




function setSelectedOption(id, valueToSelect) {
    let element = document.getElementById(id);
    element.value = valueToSelect;
}



/**
* generateID
* This function is used to generate id
* @param id This is the paramter to require id
*/
function generateID(id) {

    let pattern = {
        1: "000",
        2: "00",
        3: "0",
    };
    var length = Math.ceil(Math.log(id + 1) / Math.LN10);
    return pattern[length] + id;
}




/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {
    toastr.success(message);
}


/**
* showWarningMessage
* This function is used to show warning message.
* @param message This is the paramter to require message content
*/
function showWarningMessage(message) {
    toastr.warning(message);
}



/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}