var spWorkday_id = null;


$(document).ready(function () {

    $('#tblSpecialWorkday').DataTable({
        "scrollX": true,
        "order": [],
        "columns": [
            { "data": "date" },
            { "data": "type" },
            { "data": "edit", className: "edit" },
            { "data": "view", className: "view" },
            { "data": "delete", className: "delete" },
        ],
        columnDefs: [
            { width: 150, targets: 0 },
            { width: 20, targets: 2 },
            { width: 20, targets: 3 },
            { width: 20, targets: 4 },
        ],
    });

    /**
     * datepicker
     * This is jquery foe datepicker .
     */
    $('input[name="date"]').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        autoUpdateInput: false
    }).on('apply.daterangepicker', function (ev, picker) {
        $(this).val(picker.startDate.format('YYYY-MM-DD'));
    });




    $('#btnAction').click(function () {
        var event = $('#btnAction').text();
        if (event == 'Save') {
            save();
        } else if (event == 'Update') {
            update();
        } else if (event == 'Reset') {
            reset();
        }
    });


    allSpWorkDayType();
    allSpWorkday();

});




function allSpWorkDayType() {

    $.ajax({
        type: "GET",
        url: '/hr/spWorkday/allSpWorkdayType',
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {

                var result = response.data.result;
                appendOption(result);

            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }

    });

}





function appendOption(result) {

    $('#cmbSpWorkType').empty();
    for (i = 0; i < result.length; i++) {
        $('#cmbSpWorkType').append('<option value="' + result[i].sp_work_type_id + '">' + result[i].sp_work_type + '</option>')
    }
}






function save() {
    var form = $('#frmSpWorkdays').get(0);
    var data = new FormData(form);

    $.ajax({
        type: "POST",
        url: '/hr/spWorkday',
        data: data,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {

                showSuccessMessage("Special Workday has been saved successfully...");
                allSpWorkday();


            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }

    });
}





function update() {

    if (spWorkday_id != null) {

        $.ajax({
            type: 'PUT',
            url: '/hr/spWorkday/updateSpWorkday/' + spWorkday_id,
            data: $('#frmSpWorkdays').serialize(),
            timeout: 800000,
            beforeSend: function () {

            },
            success: function (response) {
                console.log(response);

                if (response.data.success) {
                    showSuccessMessage("Special Workday has been updated successfully...");
                    spWorkday_id = null;
                    allSpWorkday();
                    reset();
                } else {
                    showErrorMessage();
                }

            },
            error: function (error) {
                console.log(error.message);
                showErrorMessage();
            },
            complete: function () {

            }

        });
    }
}





function edit(id) {
    getSpWorkday(id);
    $('#btnAction').text('Update');
}



function view(id) {
    getSpWorkday(id);
    $('#btnAction').text('Reset');
}



function getSpWorkday(id) {
    $.ajax({
        type: "GET",
        url: '/hr/spWorkday/getSpWorkday/' + id,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {

                var result = response.data.result;
                $('#txtDate').val(result.sp_work_date);
                setSelectedOption('cmbSpWorkType', result.sp_work_type_id);
                setSelectedOption('cmbDayType', result.day_type);
                $('#txtRemark').text(result.remarks);
                spWorkday_id = id;


            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }

    });
}




function allSpWorkday() {
    $.ajax({
        type: "GET",
        url: '/hr/spWorkday/allSpWorkday',
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {

                var result = response.data.result;
                appendTableRow(result);

            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }

    });
}





/**
* loadTable
* This function is used to data set on the tables.
* @param result This is the paramter for table result
*/
function appendTableRow(result) {

    var data = [];
    for (i = 0; i < result.length; i++) {
        var id = result[i]['id'];
        var date = result[i]['sp_work_date'];
        var type = result[i]['sp_work_type'];
        var string_id = "'" + id + "'";


        data.push({
            "date": date,
            "type": type,
            "edit": '<button class="btn btn-primary" onclick="edit(' + string_id + ')"><i class="fa fa-pencil-square-o" aria-hidden="true"></i></button>',
            "view": '<button class="btn btn-success" onclick="view(' + string_id + ')"><i class="fa fa-eye" aria-hidden="true"></i></button>',
            "delete": '<button class="btn btn-danger" onclick="_delete(' + string_id + ')"><i class="fa fa-trash" aria-hidden="true"></i></button>',
        });
    }

    var table = $('#tblSpecialWorkday').DataTable();
    table.clear();
    table.rows.add(data).draw();
    table.columns('.edit').visible(false);
    table.columns('.view').visible(false);
    table.columns('.delete').visible(false);




    if (edit_permission == 1) {
        table.columns('.edit').visible(true);
    }

    if (view_permission == 1) {
        table.columns('.view').visible(true);
    }

    if (delete_permission == 1) {
        table.columns('.delete').visible(true);
    }

}







function _delete(id) {

    $.ajax({
        type: 'DELETE',
        url: '/hr/spWorkday/' + id,
        data: {
            _token: $('input[name=_token]').val()
        },
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                showSuccessMessage("Special Workday has been deleted successfully...")
                allSpWorkday();
            } else {
                showErrorMessage();
            }
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }

    });
}




function reset() {

    $('#frmSpWorkdays').trigger("reset");
    $('#txtRemark').text('');
    $('#btnAction').text('Save');
}



function setSelectedOption(id, valueToSelect) {
    let element = document.getElementById(id);
    element.value = valueToSelect;
}



/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {

    toastr.success(message);
}



/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}


/**
* showWarrningMessage
* This function is used to show warning message.
* @param message This is the paramter to require message content
*/
function showWarningMessage(message) {

    toastr.warning(message);
}