@extends('hr::layouts.app')

@section('head')
<!-- DataTable -->
<link rel="stylesheet" href="{{ url('vendors/dataTable/datatables.min.css') }}" type="text/css">
<link rel="stylesheet" href="{{ url('vendors/clockpicker/bootstrap-clockpicker.min.css') }}" type="text/css">
<link rel="stylesheet" href="{{ url('vendors/datepicker/daterangepicker.css') }}" type="text/css">
<!-- Prism -->
<link rel="stylesheet" href="{{ url('vendors/prism/prism.css') }}" type="text/css">
<!-- AutoComplete -->
<link rel="stylesheet" href="{{ url('vendors/selects/select2.min.css') }}" type="text/css">
<link rel="stylesheet" href="{{ Module::asset('hr:css/hr/attendanceEmployeeScheduleSetting.css') }}" type="text/css">
<script>
    var remove_permission = "{{Auth::user()->can('employee_schedule_remove')}}";
</script>

@endsection

@section('content')

<div class="page-header">
    <div>
        <h3></h3>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="#">Home</a>
                </li>
                <li class="breadcrumb-item">
                    <a href="#">Pages</a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">Form Page</li>
            </ol>
        </nav>
    </div>
</div>

<div class="row">
    <div class="col-md-12">
        <div class="card ">
            <div class="card-body">
                <h6 class="card-title">Attendance Schedule</h6>
                {{ csrf_field() }}
                <div class="row">
                    <div class="col-md-12">
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <i class="fa fa-users text-info" aria-hidden="true"></i>
                                <label>Shift</label>
                                <select class="form-control" id="cmbShift" name="shift" onchange=""></select>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <i class="fa fa-users text-info" aria-hidden="true"></i>
                                <label>Holiday</label>
                                <select class="form-control" id="cmbHoliday" name="holiday" onchange="">
                                    <option value="without_holiday">Without Holiday</option>
                                    <option value="with_holiday">With Holiday</option>
                                </select>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <i class="fa fa-pencil text-info" aria-hidden="true"></i>
                                <label>Site</label>
                                <select class="form-control" id="selcSite_setting" name="selcSite_setting"></select>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-3 mb-3">
                                <i class="fa fa-clock-o text-info" aria-hidden="true"></i>
                                <label>In time</label>
                                <div class="input-group clockpicker-example">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text">
                                            <i class="fa fa-clock-o"></i>
                                        </span>
                                    </div>
                                    <input type="text" class="form-control" value="18:30" id="txtIntime" name="intime">
                                </div>
                            </div>

                            <div class="col-md-3 mb-3">
                                <i class="fa fa-clock-o text-info" aria-hidden="true"></i>
                                <label>Out time</label>
                                <div class="input-group clockpicker-example">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text">
                                            <i class="fa fa-clock-o"></i>
                                        </span>
                                    </div>
                                    <input type="text" class="form-control" value="18:30" id="txtOuttime" name="outtime">
                                </div>
                            </div>

                        </div>



                        <div class="row">
                            <div class="col-md-3 mb-3">
                                <i class="fa fa-calendar text-info" aria-hidden="true"></i>
                                <label>Schedule From</label>
                                <input type="text" class="form-control" name="date" id="txtFromDate" placeholder="YYYY-MM-DD" oninput="loadEmployee_Settings()">
                            </div>

                            <div class="col-md-3 mb-3">
                                <i class="fa fa-calendar text-info" aria-hidden="true"></i>
                                <label>Schedule To</label>
                                <input type="text" class="form-control" name="date" id="txtToDate" placeholder="YYYY-MM-DD" oninput="loadEmployee_Settings()">
                            </div>

                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <i class="fa fa-pencil text-info" aria-hidden="true"></i>
                                <label>Remark</label>
                                <input type="text" class="form-control" id="txtRemark" name="remark">
                            </div>
                        </div>


                        <div class="row">
                            <div class="col-md-12 mb-3">
                                <hr>
                            </div>
                        </div>


                        <div class="row">
                            <div class="col-md-12">
                                <div class="row">
                                    <div class="col-md-6">
                                        <i class="fa fa-users text-info" aria-hidden="true"></i>
                                        <label>Category</label>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="row">
                                            <div class="col-md-6 mb-3">
                                                <select class="form-control" id="selcCategory" name="selcCategory"></select>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="row">
                                                    <div class="col-md-6 mb-3">
                                                        <label class="switch"><input type="checkbox" id="switchCategory"><span class="slider round"></span></label>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>



                        <div class="row">
                            <div class="col-md-12">
                                <div class="row">
                                    <div class="col-md-6">
                                        <i class="fa fa-users text-info" aria-hidden="true"></i>
                                        <label>Site</label>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="row">
                                            <div class="col-md-6 mb-3">
                                                <select class="form-control" id="selcSite" name="selcSite"></select>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="row">
                                                    <div class="col-md-6 mb-3">
                                                        <label class="switch"><input type="checkbox" id="switchSite"><span class="slider round"></span></label>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12">
                                <div class="row">
                                    <div class="col-md-6">
                                        <i class="fa fa-users text-info" aria-hidden="true"></i>
                                        <label>Department</label>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="row">
                                            <div class="col-md-6 mb-3">
                                                <select class="form-control" id="selcDepartment" name="selcDepartment"></select>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="row">
                                                    <div class="col-md-6 mb-3">
                                                        <label class="switch"><input type="checkbox" id="switchDepartment"><span class="slider round"></span></label>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>


                        <div class="row">
                            <div class="col-md-12">
                                <div class="row">
                                    <div class="col-md-6">
                                        <i class="fa fa-users text-info" aria-hidden="true"></i>
                                        <label>Section</label>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="row">
                                            <div class="col-md-6 mb-3">
                                                <select class="form-control" id="selcSection" name="selcSection"></select>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="row">
                                                    <div class="col-md-6 mb-3">
                                                        <label class="switch"><input type="checkbox" id="switchSection"><span class="slider round"></span></label>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>



                        <div class="row">
                            <div class="col-md-12">
                                <div class="row">
                                    <div class="col-md-6">
                                        <i class="fa fa-users text-info" aria-hidden="true"></i>
                                        <label>Subsection</label>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="row">
                                            <div class="col-md-6 mb-3">
                                                <select class="form-control" id="selcSubsection" name="selcSubsection"></select>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="row">
                                                    <div class="col-md-6 mb-3">
                                                        <label class="switch"><input type="checkbox" id="switchSubSection"><span class="slider round"></span></label>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>


                        <div class="row">
                            <div class="col-md-12">
                                <div class="row">
                                    <div class="col-md-6">
                                        <i class="fa fa-users text-info" aria-hidden="true"></i>
                                        <label>Company</label>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="row">
                                            <div class="col-md-6 mb-3">
                                                <select class="form-control" id="selcCompany" name="selcCompany"></select>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="row">
                                                    <div class="col-md-6 mb-3">
                                                        <label class="switch"><input type="checkbox" id="switchCompany"><span class="slider round"></span></label>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>




                        <div class="row">
                            <div class="col-md-12">
                                <div class="row">
                                    <div class="col-md-6">
                                        <i class="fa fa-users text-info" aria-hidden="true"></i>
                                        <label>Team</label>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="row">
                                            <div class="col-md-6 mb-3">
                                                <select class="form-control" id="selcTeam" name="selcTeam"></select>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="row">
                                                    <div class="col-md-6 mb-3">
                                                        <label class="switch"><input type="checkbox" id="switchTeam"><span class="slider round"></span></label>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>





                        <div class="row">
                            <div class="col-md-12">
                                <div class="row">
                                    <div class="col-md-6">
                                        <i class="fa fa-users text-info" aria-hidden="true"></i>
                                        <label>Employee</label>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="row">
                                            <div class="col-md-6 mb-3">
                                                <select type="text" class="form-control select2" id="cmbEmployeeID"></select>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="row">
                                                    <div class="col-md-6 mb-3">
                                                        <label class="switch"><input type="checkbox" id="switchEmployee"><span class="slider round"></span></label>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                @if(Auth::user()->can('employee_schedule_create'))
                                <button type="button" id="btnApply" class="btn btn-primary">Apply</button>
                                @endif
                                @if(Auth::user()->can('employee_schedule_remove'))
                                <button type="button" id="btnRemove" class="btn btn-danger">Remove</button>
                                @endif
                            </div>
                        </div>
                    </div>

                </div>



                <br>
                <div class="row">
                    <div class="col-md-12 seperator">
                        <div class="card bg-primary">
                            <div class="card-header"></div>
                        </div>
                    </div>
                </div>


                <div class="row">
                    <div class="col-md-12">
                        <table id="tblEmployeeSchedule" class="table table-striped table-bordered dataTable dtr-inline collapsed" role="grid" aria-describedby="example1_info">
                            <thead>
                                <tr>
                                    <th class="id">Employee ID</th>
                                    <th>Name</th>
                                    <th>Shift</th>
                                    <th>Date</th>
                                    <th>Intime</th>
                                    <th>OutTime</th>
                                    <th>Remove</th>
                                </tr>
                            </thead>
                            <tbody id="tbody"></tbody>
                        </table>
                    </div>
                </div>


            </div>
        </div>
    </div>
</div>
@endsection

<!-- JQuery -->
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
@section('script')
<!-- DataTable -->
<script src="{{ url('vendors/dataTable/datatables.min.js') }}"></script>
<script src="{{ url('vendors/clockpicker/bootstrap-clockpicker.min.js') }}"></script>
<script src="{{ url('vendors/datepicker/daterangepicker.js') }}"></script>
<!-- AutoComplete -->
<script src="{{ url('vendors/selects/select2.min.js') }}"></script>
<script src="{{ URL::asset('assets/js/svr.js') }}?random=<?php echo uniqid(); ?>"></script>
<script src="{{ Module::asset('hr:js/progress_widget.js') }}?random=<?php echo uniqid(); ?>"></script>
<script src="{{ Module::asset('hr:js/attendanceEmployeeScheduleSetting.js') }}?random=<?php echo uniqid(); ?>"></script>

<!-- Prism -->
<script src="{{ url('vendors/prism/prism.js') }}"></script>
<script src="{{ url('assets/js/notification.js') }}?random=<?php echo uniqid(); ?>"></script>
@endsection