@extends('hr::layouts.app')

@section('head')
<!-- DataTable -->
<link rel="stylesheet" href="{{ url('vendors/dataTable/datatables.min.css') }}" type="text/css">
<link rel="stylesheet" href="{{ url('vendors/datepicker/daterangepicker.css') }}" type="text/css">
<!-- Prism -->
<link rel="stylesheet" href="{{ url('vendors/prism/prism.css') }}" type="text/css">
<!-- AutoComplete -->
<link rel="stylesheet" href="{{ Module::asset('hr:js/autocomplete2/css/autocomplete.min.css') }}" type="text/css">

@endsection

@section('content')

<div class="page-header">
    <div>
        <h3></h3>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="#">Home</a>
                </li>
                <li class="breadcrumb-item">
                    <a href="#">Pages</a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">Form Page</li>
            </ol>
        </nav>
    </div>
</div>

<div class="row">
    <div class="col-md-6">
        <div class="card ">
            <div class="card-body">
                <h6 class="card-title">Attendance Process</h6>

                <div class="row">
                    <div class="col-md-12 mb-3">
                        <i class="fa fa-users text-info" aria-hidden="true"></i>
                        <label>Process</label>
                        <select class="form-control" id="cmbProcessType_RawData">
                            <option value="All">All</option>
                            <option value="Employee">Employee</option>
                        </select>
                    </div>
                </div>

                <div class="row" id="employeeDiv_RawData">
                    <div class="col-md-12 mb-3">
                        <i class="fa fa-id-card text-info" aria-hidden="true"></i>
                        <label>Employee</label>
                        <input type="text" id="txtEmployee_RawData" class="form-control auto-complete">
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-12 mb-3">
                        <i class="fa fa-calendar text-info" aria-hidden="true"></i>
                        <label>From</label>
                        <input type="text" id="txtFromDate_RawData" class="form-control" name="fromDate_RawData">
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-12 mb-3">
                        <i class="fa fa-calendar text-info" aria-hidden="true"></i>
                        <label>To</label>
                        <input type="text" id="txtToDate_RawData" class="form-control" name="toDate_RawData">
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-12 mb-3">
                        <label id="lbl_att_raw_process" for="file">Progress:</label>
                        <progress id="att_raw_process" value="0" max="100" style="min-width:100%;"> 32% </progress>
                    </div>
                    <div class="col-md-12 mb-3" style="text-align: right;">
                        @if(Auth::user()->can('process_raw_data'))
                        <button id="btnProccess_RawData" class="btn btn-primary">Process</button>
                        @endif
                    </div>
                </div>
            </div>
        </div>

    </div>



    <div class="col-md-6">
        <div class="card ">
            <div class="card-body">
                <h6 class="card-title">Attendance Calculation</h6>

                <div class="row">
                    <div class="col-md-12 mb-3">
                        <i class="fa fa-users text-info" aria-hidden="true"></i>
                        <label>Process</label>
                        <select class="form-control" id="cmbProcessType_Calculation">
                            <option value="All">All</option>
                            <option value="Employee">Employee</option>
                        </select>
                    </div>
                </div>

                <div class="row" id="employeeDiv_Calculation">
                    <div class="col-md-12 mb-3">
                        <i class="fa fa-id-card text-info" aria-hidden="true"></i>
                        <label>Employee</label>
                        <input type="text" id="txtEmployee_Calculation" class="form-control auto-complete">
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-12 mb-3">
                        <i class="fa fa-calendar text-info" aria-hidden="true"></i>
                        <label>From</label>
                        <input type="text" id="txtFromDate_Calculation" class="form-control" name="fromDate_Calculation">
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-12 mb-3">
                        <i class="fa fa-calendar text-info" aria-hidden="true"></i>
                        <label>To</label>
                        <input type="text" id="txtToDate_Calculation" class="form-control" name="toDate_Calculation">
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-12 mb-3">
                        <label id="lbl_att_ca_process" for="file">Progress:</label>
                        <progress id="att_cal_process" value="0" max="100" style="min-width:100%;"> 32% </progress>
                    </div>
                    <div class="col-md-12 mb-3" style="text-align: right;">
                        @if(Auth::user()->can('process_calculation'))
                        <button id="btnProccess_Calculation" class="btn btn-primary">Process</button>
                        @endif
                    </div>
                </div>
            </div>

        </div>
    </div>
</div>



<div class="row">
    <div class="col-md-6">
        <div class="card ">
            <div class="card-body">
                <h6 class="card-title">Attendance Post to payroll</h6>

                <div class="row">
                    <div class="col-md-12 mb-3">
                        <i class="fa fa-users text-info" aria-hidden="true"></i>
                        <label>Process</label>
                        <select class="form-control" id="cmbProcessType_PostPayroll">
                            <option value="All">All</option>
                            <option value="Employee">Employee</option>
                        </select>
                    </div>
                </div>

                <div class="row" id="employeeDiv_PostPayroll">
                    <div class="col-md-12 mb-3">
                        <i class="fa fa-id-card text-info" aria-hidden="true"></i>
                        <label>Employee</label>
                        <input type="text" id="txtEmployee_PostPayroll" class="form-control auto-complete">
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-12 mb-3">
                        <i class="fa fa-calendar text-info" aria-hidden="true"></i>
                        <label>From</label>
                        <input type="text" id="txtFromDate_PostPayroll" class="form-control" name="fromDate_PostPayroll">
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-12 mb-3">
                        <i class="fa fa-calendar text-info" aria-hidden="true"></i>
                        <label>To</label>
                        <input type="text" id="txtToDate_PostPayroll" class="form-control" name="toDate_PostPayroll">
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-12 mb-3" style="text-align: right;">
                        @if(Auth::user()->can('post_payroll'))
                        <button id="btnProccess_PostPayroll" class="btn btn-primary" onclick="proccess_PostPayroll()">Process</button>
                        @endif
                    </div>
                </div>
            </div>

        </div>
    </div>



    <div class="col-md-6">
        <div class="card ">
            <div class="card-body">
                <h6 class="card-title">Month End Process</h6>

                <div class="row">
                    <div class="col-md-12 mb-3">
                        <i class="fa fa-users text-info" aria-hidden="true"></i>
                        <label id="lblYear_MonthEnd">Year :</label>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-12 mb-3">
                        <i class="fa fa-users text-info" aria-hidden="true"></i>
                        <label id="lblMonth_MonthEnd">Month :</label>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-12 mb-3" style="text-align: right;">
                        @if(Auth::user()->can('process_month_end'))
                        <button id="btnProccess_MonthEnd" class="btn btn-primary" onclick="proccess_MonthEnd()">Process</button>
                        @endif
                    </div>
                </div>
            </div>

        </div>
    </div>
</div>
<br>
<br>
@endsection

<!-- Javascript -->
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
@section('script')
<!-- DataTable -->
<script src="{{ url('vendors/dataTable/datatables.min.js') }}"></script>
<script src="{{ url('assets/js/examples/datatable.js') }}"></script>
<script src="{{ url('vendors/datepicker/daterangepicker.js') }}"></script>

<!-- AutoComplete -->
<script src="{{ Module::asset('hr:js/autocomplete2/js/autocomplete.min.js') }}?random=<?php echo uniqid(); ?>"></script>
<script src="{{ URL::asset('assets/js/svr.js') }}?random=<?php echo uniqid(); ?>"></script>
<script src="{{ Module::asset('hr:js/attendanceProcess.js') }}?random=<?php echo uniqid(); ?>"></script>
<script src="{{ Module::asset('hr:js/attendanceCalculation.js') }}?random=<?php echo uniqid(); ?>"></script>
<script src="{{ Module::asset('hr:js/attendanceProcessPostPayroll.js') }}?random=<?php echo uniqid(); ?>"></script>
<script src="{{ Module::asset('hr:js/monthendProcess.js') }}?random=<?php echo uniqid(); ?>"></script>


<!-- Prism -->
<script src="{{ url('vendors/prism/prism.js') }}"></script>
<script src="{{ url('assets/js/notification.js') }}?random=<?php echo uniqid(); ?>"></script>
@endsection