@extends('hr::layouts.app')

@section('head')
<!-- DataTable -->
<link rel="stylesheet" href="{{ url('vendors/dataTable/datatables.min.css') }}" type="text/css">
<!-- Prism -->
<link rel="stylesheet" href="{{ url('vendors/prism/prism.css') }}" type="text/css">

<script>
    var user_id = "{{Auth::user()->user_id}}";
    var edit_permission = "{{ Auth::user()->can('hr_leave_edit')}} ";
    var view_permission = "{{ Auth::user()->can('hr_leave_view')}} ";
    var delete_permission = "{{ Auth::user()->can('hr_leave_delete')}} ";
    var confirm_permission = "{{ Auth::user()->can('hr_leave_confirm')}} ";
    var reject_permission = "{{ Auth::user()->can('hr_leave_reject')}} ";
</script>

@endsection

@section('content')

<div class="page-header">
    <div>
        <h3>Form Page</h3>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="#">Home</a>
                </li>
                <li class="breadcrumb-item">
                    <a href="#">Pages</a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">Form Page</li>
            </ol>
        </nav>
    </div>
</div>

<div class="row">
    <div class="col-md-12">
        <div class="card ">
            <div class="card-body">
                <h6 class="card-title">Leave List</h6>
                {{ csrf_field() }}
                <table id="myTable" class="table table-striped table-bordered dataTable dtr-inline collapsed" role="grid" aria-describedby="example1_info">
                    <thead>
                        <tr>
                            <th class="id">Leave ID</th>
                            <th class="id">Employee ID</th>
                            <th>Employee Name</th>
                            <th>from</th>
                            <th>To</th>
                            <th>Edit</th>
                            <th>View</th>
                            <th>Delete</th>
                            <th class="Confirmed">Confirm</th>
                            <th class="Rejected">Reject</th>
                        </tr>
                    </thead>
                    <tbody></tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@endsection

<!-- Javascript -->
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
@section('script')
<!-- DataTable -->
<script src="{{ url('vendors/dataTable/datatables.min.js') }}"></script>
<script src="{{ url('assets/js/examples/datatable.js') }}"></script>
<script src="{{ Module::asset('hr:js/leave_list.js') }}?random=<?php echo uniqid(); ?>"></script>

<!-- Prism -->
<script src="{{ url('vendors/prism/prism.js') }}"></script>
<script src="{{ url('assets/js/notification.js') }}?random=<?php echo uniqid(); ?>"></script>
@endsection