@extends('hr::layouts.app')

@section('head')
<!-- DataTable -->
<link rel="stylesheet" href="{{ url('vendors/dataTable/datatables.min.css') }}" type="text/css">
<link rel="stylesheet" href="{{ url('vendors/datepicker/daterangepicker.css') }}" type="text/css">
<!-- Prism -->
<link rel="stylesheet" href="{{ url('vendors/prism/prism.css') }}" type="text/css">

<style>
    .imgContainer {
        text-align: center;
        height: 215px;
    }

    #videoElement {
        height: 215px;
    }

    #canvas {
        height: 215px;
    }

    #btnTakePhoto {
        margin-top: 10px;
        width: 100%;
        cursor: pointer;
        display: inline-block;
        font-size: 14px;
        font-weight: 400;
        line-height: 1.42857;
        padding: 6px 12px;
        text-align: center;
        vertical-align: middle;
        white-space: nowrap;
    }


    #btnChooseImage {
        margin-top: 5px;
        width: 100%;
        cursor: pointer;
        display: inline-block;
        font-size: 14px;
        font-weight: 400;
        line-height: 1.42857;
        padding: 6px 12px;
        text-align: center;
        vertical-align: middle;
        white-space: nowrap;
    }

    #fileImg {
        visibility: hidden;
    }

    #btnAction {
        cursor: pointer;
        display: inline-block;
        font-size: 14px;
        font-weight: 400;
        line-height: 1.42857;
        padding: 6px 12px;
        text-align: center;
        vertical-align: middle;
        white-space: nowrap;
        width: 100%;
        margin-bottom: 10px;
    }

    #btnClear {
        cursor: pointer;
        display: inline-block;
        font-size: 14px;
        font-weight: 400;
        line-height: 1.42857;
        padding: 6px 12px;
        text-align: center;
        vertical-align: middle;
        white-space: nowrap;
        width: 100%;
        margin-bottom: 10px;
    }

    #tblContainer {
        padding: 20px;
        background-color: #f4f5fd;
    }

    #printTable {
        background-color: white;
        color: black;
        max-width: 500px;
    }

    table.dataTable thead tr {
        color: darkblue;
        background-color: white;
    }

    table.dataTable td {
        padding-top: 0px;
        padding-bottom: 0px;
        text-align: center;
    }

    table.dataTable td img {
        width: 70px;
        height: 60px;
    }

    #btnPrint {
        cursor: pointer;
        display: inline-block;
        font-size: 14px;
        font-weight: 400;
        line-height: 1.42857;
        padding: 6px 12px;
        text-align: center;
        vertical-align: middle;
        white-space: nowrap;
        width: 100%;
        margin-top: 10px;
        margin-bottom: 10px;
    }

    #btnMakeAllAsPrint {
        cursor: pointer;
        display: inline-block;
        font-size: 14px;
        font-weight: 400;
        line-height: 1.42857;
        padding: 6px 12px;
        text-align: center;
        vertical-align: middle;
        white-space: nowrap;
        width: 100%;
        margin-top: 10px;
        margin-bottom: 10px;
    }
</style>

<script>
    var edit_permission = "{{Auth::user()->can('employee_id_card_edit')}}";
    var delete_permission = "{{Auth::user()->can('employee_id_card_delete')}}";
</script>

@endsection

@section('content')

<div class="page-header">
    <div>
        <h3></h3>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="#">Home</a>
                </li>
                <li class="breadcrumb-item">
                    <a href="#">Pages</a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">Form Page</li>
            </ol>
        </nav>
    </div>
</div>

<div class="row">
    <div class="col-md-12">
        <div class="card ">
            <div class="card-body">
                <h6 class="card-title">Print employee ID</h6>



                <form method="POST" id="printIdForm" name="printIdForm">
                    {{ csrf_field() }}
                    <input type="file" id="fileImg" name="fileImg" value="">
                    <div class="row">
                        <div class="col-md-3 mb-3">
                            <div class="imgContainer">
                                <video autoplay="true" id="videoElement" class="img img-thumbnail" poster="/images/webcam.png"></video>
                            </div>
                            <button type="button" class="btn btn-primary" id="btnTakePhoto" name="btnTakePhoto" onclick="openWebCam()">Open Webcam</button>

                        </div>
                        <div class="col-md-3 mb-3">
                            <div class="imgContainer">
                                <canvas id="canvas" class="img img-thumbnail"></canvas>
                            </div>
                            <div class="progress" style="height: 5px;">
                                <div class="progress-bar" role="progressbar" style="width: 0%;" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100" id="progresImg"></div>
                            </div>
                            <input type="file" id="imgFile" hidden>
                            <button type="button" class="btn btn-primary" id="btnChooseImage" name="btnChooseImage" onclick="imageChooser()">Choose Image</button>
                        </div>
                    </div>

                    <br><br>

                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <i class="fa fa-pencil text-info" aria-hidden="true"></i>
                            <label for="txtName">Name With Initials</label>
                            <input type="text" class="form-control" id="txtName" name="txtName">
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <i class="fa fa-pencil text-info" aria-hidden="true"></i>
                            <label for="txtNic">NIC</label>
                            <input type="text" class="form-control" id="txtNic" name="txtNic">
                        </div>
                    </div>


                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <i class="fa fa-pencil text-info" aria-hidden="true"></i>
                            <label for="selcDesignation">Designation</label>
                            <select class="form-control" id="selcDesignation" name="selcDesignation"></select>
                        </div>
                    </div>


                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <i class="fa fa-pencil text-info" aria-hidden="true"></i>
                            <label for="txtEmployeeID">Employee ID</label>
                            <input type="text" class="form-control" id="txtEmployeeID" name="txtEmployeeID">
                        </div>
                    </div>


                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <i class="fa fa-pencil text-info" aria-hidden="true"></i>
                            <label for="txtAttendanceID">Attendance ID</label>
                            <input type="text" class="form-control" id="txtAttendanceID" name="txtAttendanceID">
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <i class="fa fa-calendar text-info" aria-hidden="true"></i>
                            <label for="dteDateOfJoined">Date Of Joined</label>
                            <input type="text" name="dteDateOfJoined" class="form-control" id="dteDateOfJoined" placeholder="YYYY-MM-DD">
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-3 mb-3">
                            <i class="fa fa-calendar text-info" aria-hidden="true"></i>
                            <label for="txtIDCardIssueDate">ID Card Issue Date</label>
                            <input type="text" name="txtIDCardIssueDate" class="form-control" id="txtIDCardIssueDate" placeholder="YYYY-MM-DD">
                        </div>
                        <div class="col-md-3 mb-3">
                            <i class="fa fa-calendar text-info" aria-hidden="true"></i>
                            <label for="txtIDCardExpireDate">ID Card Expire Date</label>
                            <input type="text" name="txtIDCardExpireDate" class="form-control" id="txtIDCardExpireDate" placeholder="YYYY-MM-DD">
                        </div>
                    </div>


                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <i class="fa fa-address-book-o text-info" aria-hidden="true"></i>
                            <label for="txtEmployeeAddress">Address</label>
                            <textarea class="form-control" id="txtEmployeeAddress" name="txtEmployeeAddress"></textarea>
                        </div>
                    </div>

                    <div class="row" hidden>
                        <div class="col-md-6 mb-3">
                            <i class="fa fa-pencil text-info" aria-hidden="true"></i>
                            <label for="txtSubContractor">Sub Contractor</label>
                            <input type="hidden" class="form-control" id="txtSubContractor" value="Unspecified" name="txtSubContractor">
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6 mb-0">

                            <div class="row">
                                <div class="col-md-3"></div>
                                <div class="col-md-3"></div>
                                @if(Auth::user()->can('employee_id_card_create'))
                                <div class="col-md-3">
                                    <button type="button" id="btnClear" name="btnClear" class="btn btn-warning" onclick="resetForm()">Clear</button>
                                </div>
                                <div class="col-md-3">
                                    <button type="button" id="btnAction" name="btnAction" class="btn btn-primary">Save</button>
                                </div>
                                @endif
                            </div>

                        </div>
                    </div>
                </form>

                <hr><br><br>

                <div class="row" id="tblContainer">
                    <div class="col-md-12 mb-3">
                        <table id="printTable" class="table table-striped table-bordered dataTable dtr-inline collapsed" role="grid" aria-describedby="example1_info">
                            <thead>
                                <tr>
                                    <th>Print</th>
                                    <th>Employee ID</th>
                                    <th>Attendance ID</th>
                                    <th>NIC</th>
                                    <th>Name</th>
                                    <th>Address</th>
                                    <th>Date Of Joined</th>
                                    <th>Issuse</th>
                                    <th>Expire</th>
                                    <th>Designation</th>
                                    <th>Photo</th>
                                    <th>Sub Contractor</th>
                                    <th>Edit</th>
                                    <th>Delete</th>
                                </tr>
                            </thead>
                            <tbody></tbody>
                        </table>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-2"></div>
                    <div class="col-md-2"></div>
                    <div class="col-md-2"></div>
                    <div class="col-md-2"></div>
                    <div class="col-md-4">
                        <div class="row">
                            <div class="col-md-5">
                                @if(Auth::user()->can('employee_id_card_print'))
                                <button type="button" class="btn btn-primary" id="btnPrint" onclick="printPreview()">Print</button>
                                @endif
                            </div>
                            <div class="col-md-7">
                                @if(Auth::user()->can('employee_id_card_make_all'))
                                <button type="button" class="btn btn-success" id="btnMakeAllAsPrint" onclick="makedPrint()">Make All As Print</button>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
</div>
@endsection

<!-- Javascript -->
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
@section('script')
<!-- DataTable -->
<script src="{{ url('vendors/dataTable/datatables.min.js') }}"></script>
<script src="{{ url('assets/js/examples/datatable.js') }}"></script>
<script src="{{ url('vendors/datepicker/daterangepicker.js') }}"></script>
<script src="{{ Module::asset('hr:js/print_id.js') }}"></script>

<!-- Prism -->
<script src="{{ url('vendors/prism/prism.js') }}"></script>
@endsection