<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateAttEmployeeLeavesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('hr_att_employee_leaves', function (Blueprint $table) {
            $table->id();
            $table->string('employee_id',25);
            $table->foreign('employee_id')->references('employee_id')->on('hr_employees')->onDelete('cascade');
            $table->foreignId('leave_type_id');
            $table->foreign('leave_type_id')->references('leave_type_id')->on('hr_att_leave_types')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('att_employee_leaves');
    }
}
