<?php

namespace Modules\Hr\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;
class GsDivision extends Model
{
    use HasFactory,LogsActivity;
    protected $table = 'hr_gs_divisions';
    protected $primaryKey = 'gs_division_id';

    protected $fillable = [];
    protected static $logAttributes = [
        'gs_division_id',
        'gs_division',
        'gs_mobile',
        'office_phone',
        'contact_person',
        'status',
    ];
    protected static $logOnlyDirty = true;
    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->log_name = "hr_gs_divisions";
        $activity->description = $eventName;
        $activity->causer_id = Auth::user()->id;
    }
    
    /*protected static function newFactory()
    {
        return \Modules\Hr\Database\factories\GsDivisionFactory::new();
    }*/
}
