<?php

namespace Modules\Hr\Entities;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;
class OtherEarningDeduction extends Model
{
    protected $table = 'hr_other_earning_deduction';
    protected $primaryKey = 'earn_deduct_id'; 
    use HasFactory,LogsActivity;
    protected static $logAttributes = [
        'earn_deduct_id',
        'type',
        'title',
        'item_id',
        'calcualte',
        'formula',
        'epf',
    ];
    protected static $logOnlyDirty = true;
    public function tapActivity(Activity $activity, string $eventName)
    {
        $activity->log_name = "hr_other_earning_deduction";
        $activity->description = $eventName;
        $activity->causer_id = Auth::user()->id;
    }
}
