<?php

namespace Modules\Hr\Http\Controllers;


use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Modules\Hr\Entities\AtdHoliday;
use Modules\Hr\Entities\AtdHolidayType;
use Modules\Hr\Entities\AttSchedule;
use Modules\Hr\Entities\AttShift;
use Modules\Hr\Entities\Company;
use Modules\Hr\Entities\Employee;
use Modules\Hr\Entities\EmployeeCategory;
use Modules\Hr\Entities\EmployeeDepartment;
use Modules\Hr\Entities\EmployeeSection;
use Modules\Hr\Entities\EmployeeSite;
use Modules\Hr\Entities\EmployeeTeam;
use Modules\Hr\Entities\Team;

class AttScheduleController extends Controller
{
    //

    public function allSettings()
    {

        try {
            $shifts = AttShift::all();
            $categories = EmployeeCategory::all();
            $sites = EmployeeSite::all();
            $departments = EmployeeDepartment::all();
            $sections = EmployeeSection::all();
            $companies = Company::all();
            $teams = Team::all();



            $settings = [
                'shifts' => $shifts,
                'categories' => $categories,
                'sites' => $sites,
                'departments' => $departments,
                'sections' => $sections,
                'companies' => $companies,
                'teams' => $teams,
                'employees' => $this->allEmployees(),
            ];

            $responseBody = $this->responseBody(true, "AllSettings", "all", $settings);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "AllSettings", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }


    private function allEmployees()
    {

        $employees = Employee::all();
        $employee_list = [];
        foreach ($employees as $employee) {
            array_push($employee_list, [
                "img" => $employee->photo_parth,
                "id" => $employee->employee_id,
                "value" => $employee->employee_id
            ]);
        }
        return $employee_list;
    }




    public function subsection($section_id)
    {
        try {
            $query = "SELECT
            hr_employee_subsections.`subsection_id` AS subsection_id,
            hr_employee_subsections.`subsection` AS subsection
            FROM
            `hr_employee_sections` hr_employee_sections INNER JOIN `hr_employee_subsections` hr_employee_subsections ON hr_employee_sections.`section_id` = hr_employee_subsections.`section_id` WHERE hr_employee_sections.`section_id` = '" . $section_id . "'";

            $subsection = DB::select($query);
            $responseBody = $this->responseBody(true, "Subsection", "all", $subsection);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Subsection", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }




    public function shiftIntimeOutTime($shift_id)
    {

        try {
            $shift = AttShift::find($shift_id);
            $intime = $shift->start_time;
            $H = explode(":", $intime)[0];
            $M = explode(":", $intime)[1];
            $S = explode(":", $intime)[2];
            $duration = $shift->duration;

            $outtime = $this->getOutTime($H, $M, $S, $duration);

            $responseBody = $this->responseBody(true, "Shift time", "Intime_Outtime", ["intime" => $intime, "outtime" => $outtime]);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Shift time", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    public function getOutTime($H, $M, $S, $duration)
    {

        $hours = $H + ($M + ($S / 60.0)) / 60.0;
        $endTime =  ($hours + $duration);
        if ($endTime >= 24.0) {
            $endTime -= 24.0;
        }
        $hh = floor($endTime);
        $endTime = ($endTime - $hh) * 60;
        $mm = floor($endTime);
        $endTime = ($endTime - $mm) * 60;
        $ss = floor($endTime);

        if (strlen($hh) == 1) {
            $hh = '0' . $hh;
        }
        if (strlen($mm) == 1) {
            $mm = '0' . $mm;
        }
        if (strlen($ss) == 1) {
            $ss = '0' . $ss;
        }

        return $hh . ':' . $mm . ':' . $ss;
    }



    public function scheduleCategory($shift_id, $site_id, $category_id, $start_date, $end_date)
    {
        try {
            $query = "SELECT DISTINCT
            hr_att_schedules.`schedule_id` AS schedule_id,
            hr_att_schedules.`employee_id` AS employee_id,
            hr_att_shifts.`shift_name` AS shift_name,
            hr_att_shifts.`shift_id` AS shift_id,
            hr_att_schedules.`schedule_date_from` AS schedule_date_from,
            hr_att_schedules.`in_time` AS in_time,
            hr_att_schedules.`out_time` AS out_time,
            hr_employees.`name_withinitial` AS name_withinitial
       FROM
            `hr_att_schedules` hr_att_schedules INNER JOIN `hr_att_shifts` hr_att_shifts ON hr_att_schedules.`shift_id` = hr_att_shifts.`shift_id`
            INNER JOIN `hr_employees` hr_employees ON hr_att_schedules.`employee_id` = hr_employees.`employee_id`  WHERE hr_employees.`category_id` = '" . $category_id . "' AND hr_employees.`site_id` = '" . $site_id . "' AND hr_att_shifts.`shift_id` = '" . $shift_id . "' AND hr_att_schedules.`schedule_date_from` BETWEEN '" . $start_date . "' AND '" . $end_date . "'";
            $result = DB::select($query);

            $responseBody = $this->responseBody(true, "Employee Category", "all", $result);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Employee Category", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }




    public function scheduleSite($shift_id, $site_id, $start_date, $end_date)
    {
        try {
            $query = "SELECT DISTINCT
            hr_att_schedules.`schedule_id` AS schedule_id,
            hr_att_schedules.`employee_id` AS employee_id,
            hr_att_shifts.`shift_name` AS shift_name,
            hr_att_shifts.`shift_id` AS shift_id,
            hr_att_schedules.`schedule_date_from` AS schedule_date_from,
            hr_att_schedules.`in_time` AS in_time,
            hr_att_schedules.`out_time` AS out_time,
            hr_employees.`name_withinitial` AS name_withinitial
       FROM
            `hr_att_schedules` hr_att_schedules INNER JOIN `hr_att_shifts` hr_att_shifts ON hr_att_schedules.`shift_id` = hr_att_shifts.`shift_id`
            INNER JOIN `hr_employees` hr_employees ON hr_att_schedules.`employee_id` = hr_employees.`employee_id`  WHERE hr_employees.`site_id` = '" . $site_id . "' AND hr_att_shifts.`shift_id` = '" . $shift_id . "' AND hr_att_schedules.`schedule_date_from` BETWEEN '" . $start_date . "' AND '" . $end_date . "'";
            $result = DB::select($query);

            $responseBody = $this->responseBody(true, "Employee Site", "all", $result);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Employee Site", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }




    public function scheduleDepartment($shift_id, $site_id, $department_id, $start_date, $end_date)
    {
        try {
            $query = "SELECT DISTINCT
            hr_att_schedules.`schedule_id` AS schedule_id,
            hr_att_schedules.`employee_id` AS employee_id,
            hr_att_shifts.`shift_name` AS shift_name,
            hr_att_shifts.`shift_id` AS shift_id,
            hr_att_schedules.`schedule_date_from` AS schedule_date_from,
            hr_att_schedules.`in_time` AS in_time,
            hr_att_schedules.`out_time` AS out_time,
            hr_employees.`name_withinitial` AS name_withinitial
       FROM
            `hr_att_schedules` hr_att_schedules INNER JOIN `hr_att_shifts` hr_att_shifts ON hr_att_schedules.`shift_id` = hr_att_shifts.`shift_id`
            INNER JOIN `hr_employees` hr_employees ON hr_att_schedules.`employee_id` = hr_employees.`employee_id`  WHERE hr_employees.`department_id` = '" . $department_id . "' AND hr_att_shifts.`shift_id` = '" . $shift_id . "' AND hr_employees.`site_id` = '" . $site_id . "' AND hr_att_schedules.`schedule_date_from` BETWEEN '" . $start_date . "' AND '" . $end_date . "'";
            $result = DB::select($query);

            $responseBody = $this->responseBody(true, "Employee Department", "all", $result);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Employee Department", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }




    public function scheduleSection($shift_id, $site_id, $section_id, $start_date, $end_date)
    {
        try {
            $query = "SELECT DISTINCT
            hr_att_schedules.`schedule_id` AS schedule_id,
            hr_att_schedules.`employee_id` AS employee_id,
            hr_att_shifts.`shift_name` AS shift_name,
            hr_att_shifts.`shift_id` AS shift_id,
            hr_att_schedules.`schedule_date_from` AS schedule_date_from,
            hr_att_schedules.`in_time` AS in_time,
            hr_att_schedules.`out_time` AS out_time,
            hr_employees.`name_withinitial` AS name_withinitial
       FROM
            `hr_att_schedules` hr_att_schedules INNER JOIN `hr_att_shifts` hr_att_shifts ON hr_att_schedules.`shift_id` = hr_att_shifts.`shift_id`
            INNER JOIN `hr_employees` hr_employees ON hr_att_schedules.`employee_id` = hr_employees.`employee_id`  WHERE hr_employees.`section_id` = '" . $section_id . "' AND hr_employees.`site_id` = '" . $site_id . "' AND hr_att_shifts.`shift_id` = '" . $shift_id . "' AND hr_att_schedules.`schedule_date_from` BETWEEN '" . $start_date . "' AND '" . $end_date . "'";
            $result = DB::select($query);

            $responseBody = $this->responseBody(true, "Employee Section", "all", $result);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Employee Section", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }




    public function scheduleSubsection($shift_id, $site_id, $subsection_id, $start_date, $end_date)
    {
        try {
            $query = "SELECT DISTINCT
            hr_att_schedules.`schedule_id` AS schedule_id,
            hr_att_schedules.`employee_id` AS employee_id,
            hr_att_shifts.`shift_name` AS shift_name,
            hr_att_shifts.`shift_id` AS shift_id,
            hr_att_schedules.`schedule_date_from` AS schedule_date_from,
            hr_att_schedules.`in_time` AS in_time,
            hr_att_schedules.`out_time` AS out_time,
            hr_employees.`name_withinitial` AS name_withinitial
       FROM
            `hr_att_schedules` hr_att_schedules INNER JOIN `hr_att_shifts` hr_att_shifts ON hr_att_schedules.`shift_id` = hr_att_shifts.`shift_id`
            INNER JOIN `hr_employees` hr_employees ON hr_att_schedules.`employee_id` = hr_employees.`employee_id`  WHERE hr_employees.`subsection_id` = '" . $subsection_id . "' AND hr_att_shifts.`shift_id` = '" . $shift_id . "' AND hr_employees.`site_id` = '" . $site_id . "' AND hr_att_schedules.`schedule_date_from` BETWEEN '" . $start_date . "' AND '" . $end_date . "'";
            $result = DB::select($query);

            $responseBody = $this->responseBody(true, "Employee Subection", "all", $result);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Employee Subection", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }




    public function scheduleCompany($shift_id, $site_id, $company_id, $start_date, $end_date)
    {
        try {
            $query = "SELECT DISTINCT
            hr_att_schedules.`schedule_id` AS schedule_id,
            hr_att_schedules.`employee_id` AS employee_id,
            hr_att_shifts.`shift_name` AS shift_name,
            hr_att_shifts.`shift_id` AS shift_id,
            hr_att_schedules.`schedule_date_from` AS schedule_date_from,
            hr_att_schedules.`in_time` AS in_time,
            hr_att_schedules.`out_time` AS out_time,
            hr_employees.`name_withinitial` AS name_withinitial
       FROM
            `hr_att_schedules` hr_att_schedules INNER JOIN `hr_att_shifts` hr_att_shifts ON hr_att_schedules.`shift_id` = hr_att_shifts.`shift_id`
            INNER JOIN `hr_employees` hr_employees ON hr_att_schedules.`employee_id` = hr_employees.`employee_id`  WHERE hr_employees.`company_id` = '" . $company_id . "' AND hr_att_shifts.`shift_id` = '" . $shift_id . "' AND hr_employees.`site_id` = '" . $site_id . "' AND hr_att_schedules.`schedule_date_from` BETWEEN '" . $start_date . "' AND '" . $end_date . "'";
            $result = DB::select($query);

            $responseBody = $this->responseBody(true, "Employee Company", "all", $result);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Employee Company", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }




    public function scheduleTeam($shift_id, $site_id, $team_id, $start_date, $end_date)
    {

        try {
            $query = "SELECT DISTINCT
            hr_att_schedules.`schedule_id` AS schedule_id,
            hr_att_schedules.`employee_id` AS employee_id,
            hr_att_shifts.`shift_name` AS shift_name,
            hr_att_shifts.`shift_id` AS shift_id,
            hr_att_schedules.`schedule_date_from` AS schedule_date_from,
            hr_att_schedules.`in_time` AS in_time,
            hr_att_schedules.`out_time` AS out_time,
            hr_employee_teams.`team_id` AS team_id,
            hr_teams.`team_name` AS team_name
       FROM
            `hr_teams` hr_teams INNER JOIN `hr_employee_teams` hr_employee_teams ON hr_teams.`team_id` = hr_employee_teams.`team_id`
            INNER JOIN `hr_att_schedules` hr_att_schedules ON hr_employee_teams.`employee_id` = hr_att_schedules.`employee_id`
            INNER JOIN `hr_att_shifts` hr_att_shifts ON hr_att_schedules.`shift_id` = hr_att_shifts.`shift_id` 
            INNER JOIN `hr_employees` hr_employees ON hr_att_schedules.`employee_id` = hr_employees.`employee_id` 
            WHERE hr_teams.`team_id` = '" . $team_id . "' AND hr_att_shifts.`shift_id` = '" . $shift_id . "' AND hr_employees.`site_id` = '" . $site_id . "' AND hr_att_schedules.`schedule_date_from` BETWEEN '" . $start_date . "' AND '" . $end_date . "'";
            $result = DB::select($query);

            foreach ($result as $row) {
                $employee = Employee::find($row->employee_id);
                $row->name_withinitial = $employee->name_withinitial;
            }

            $responseBody = $this->responseBody(true, "Employee Team", "all", $result);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Employee Team", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }




    public function scheduleEmployee($shift_id, $site_id, $employee_id, $start_date, $end_date)
    {
        try {
            $query = "SELECT DISTINCT
            hr_att_schedules.`schedule_id` AS schedule_id,
            hr_att_schedules.`employee_id` AS employee_id,
            hr_att_shifts.`shift_name` AS shift_name,
            hr_att_shifts.`shift_id` AS shift_id,
            hr_att_schedules.`schedule_date_from` AS schedule_date_from,
            hr_att_schedules.`in_time` AS in_time,
            hr_att_schedules.`out_time` AS out_time,
            hr_employees.`name_withinitial` AS name_withinitial
       FROM
            `hr_att_schedules` hr_att_schedules INNER JOIN `hr_att_shifts` hr_att_shifts ON hr_att_schedules.`shift_id` = hr_att_shifts.`shift_id`
            INNER JOIN `hr_employees` hr_employees ON hr_att_schedules.`employee_id` = hr_employees.`employee_id`  WHERE hr_employees.`employee_id` = '" . $employee_id . "' AND hr_att_shifts.`shift_id` = '" . $shift_id . "' AND hr_employees.`site_id` = '" . $site_id . "' AND hr_att_schedules.`schedule_date_from` BETWEEN '" . $start_date . "' AND '" . $end_date . "'";
            $result = DB::select($query);

            $responseBody = $this->responseBody(true, "Employee Company", "all", $result);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Employee Company", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }




    public function removeSchedule($id)
    {
        try {
            $schedule = AttSchedule::find($id);
            if ($schedule) {
                DB::table('hr_att_time')->where('EmployeeID', $schedule->employee_id)->where('Date', $schedule->schedule_date_from)->delete();
                $schedule->delete();
            }
            $responseBody = $this->responseBody(true, "Schedule", "deleted", NULL);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Schedule", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }




    public function removeAllSchedule(Request $request)
    {

        try {
            $setting = $this->getEmployeeFromSettings($request->get('setting_array'), $request->get('select_option'));
            $shift_id = $request->get('shift_id');
            $start_date = $request->get('start_date');
            $end_date = $request->get('end_date');
            if (count($setting) > 0) {
                foreach ($setting as $employee) {
                    $roster = AttSchedule::where([['employee_id', '=', $employee->employee_id], ['shift_id', '=', $shift_id]])->whereBetween('schedule_date_from', [$start_date, $end_date])->get();
                    foreach ($roster as $rs) {
                        DB::table('hr_att_time')->where('EmployeeID', $rs->employee_id)->where('Date', $rs->schedule_date_from)->delete();
                        $rs->delete();
                    }
                }
            }

            $responseBody = $this->responseBody(true, "Employee Category", "remove", $setting);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Employee", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }










    public function applySchedule(Request $request)
    {


        try {
            ini_set('max_execution_time', '0'); // for infinite time of execution 

            $shift_id = $request->get('shift_id');
            $holiday = $request->get('holiday');
            $site = $request->get('site');
            $shift = AttShift::find($shift_id);

            $intime = $shift->start_time;
            $H = explode(":", $intime)[0];
            $M = explode(":", $intime)[1];
            $S = explode(":", $intime)[2];
            $time_day1 = $this->getLocalMeanDate_from_Time($H, $M, $S);

            $duration = $shift->duration;
            $DH = floor($duration);
            $DM = floor(($duration - $DH) * 60.0);
            $DS = floor(((($duration - $DH) * 60.0) - $DM) * 60.0);
            $time_day2 = $this->getLocalMeanDate_from_Time($DH, $DM, $DS);


            $fromDate = $request->get('start_date');
            $year = explode("-", $fromDate)[0];
            $month = explode("-", $fromDate)[1];
            $day = explode("-", $fromDate)[2];
            $from_jde = juliantojd($month, $day, $year); //$this->getJulianDay($year, $month, $day);

            $out_jdt = ($from_jde + ($time_day1 + $time_day2));
            $shift_out_date = explode("/", jdtojulian($out_jdt))[2] . "-" . explode("/", jdtojulian($out_jdt))[0] . "-" . explode("/", jdtojulian($out_jdt))[1]; //$this->getLocalDate($out_jdt)['fullDate'];
            $out_time = $this->getLocalMeanTime($out_jdt)['fullTime'];


            $toDate = $request->get('end_date');
            $year_to = explode("-", $toDate)[0];
            $month_to = explode("-", $toDate)[1];
            $day_to = explode("-", $toDate)[2];
            $to_jde = juliantojd($month_to, $day_to, $year_to); //$this->getJulianDay($year_to, $month_to, $day_to);

            $remark = $request->get('remark');
            if ($remark == null) {
                $remark = "";
            }


            $setting = $this->getEmployeeFromSettings($request->get('setting_array'), $request->get('select_option'));

            $day_count =  ($to_jde - $from_jde);



            if (count($setting) > 0) {
                foreach ($setting as $employee) {
                    if ($employee->site_id == $site) {
                        if ($day_count == 0) {
                            $date = explode("/", jdtojulian($from_jde))[2] . "-" . explode("/", jdtojulian($from_jde))[0] . "-" . explode("/", jdtojulian($from_jde))[1]; //$this->getLocalDate($from_jde)['fullDate'];
                            $isDuplicate = $this->isDuplicateSchedule($employee->employee_id, $date);
                            $isHoliday = false;
                            if ($holiday == 'without_holiday') {
                                $isHoliday = $this->isHoliday($date);
                            } else if ($holiday == 'with_holiday') {
                                $isHoliday = false;
                            }

                            $isCoveringday = $this->isCoveringday($date, $site);
                            if ($isCoveringday) {
                                $isHoliday = false;
                            }




                            if (!$isDuplicate && !$isHoliday) {
                                $schedule = new AttSchedule();
                                $schedule->employee_id = $employee->employee_id;
                                $schedule->shift_id = $shift->shift_id;
                                $schedule->schedule_date_from = $date;
                                $schedule->in_time = $date . ' ' . $intime;
                                $schedule->out_time = $shift_out_date . ' ' . $out_time;
                                $schedule->remark = $remark;
                                $schedule->status = 1;
                                $schedule->save();

                                $this->createRoster($schedule);
                            }
                        } else if ($day_count > 0) {

                            for ($i = 0; $i <= $day_count; $i++) {
                                $date = explode("/", jdtojulian(($from_jde + $i)))[2] . "-" . explode("/", jdtojulian(($from_jde + $i)))[0] . "-" . explode("/", jdtojulian(($from_jde + $i)))[1]; //$this->getLocalDate(($from_jde + $i))['fullDate'];
                                $isDuplicate = $this->isDuplicateSchedule($employee->employee_id, $date);
                                $isHoliday = false;
                                if ($holiday == 'without_holiday') {
                                    $isHoliday = $this->isHoliday($date);
                                } else if ($holiday == 'with_holiday') {
                                    $isHoliday = false;
                                }

                                $isCoveringday = $this->isCoveringday($date, $site);
                                if ($isCoveringday) {
                                    $isHoliday = false;
                                }

                                $out_jdt = (($from_jde + $i) + ($time_day1 + $time_day2));
                                $shift_out_date = explode("/", jdtojulian($out_jdt))[2] . "-" . explode("/", jdtojulian($out_jdt))[0] . "-" . explode("/", jdtojulian($out_jdt))[1]; //$this->getLocalDate($out_jdt)['fullDate'];

                                if (!$isDuplicate && !$isHoliday) {
                                    $schedule = new AttSchedule();
                                    $schedule->employee_id = $employee->employee_id;
                                    $schedule->shift_id = $shift->shift_id;
                                    $schedule->schedule_date_from = $date;
                                    $schedule->in_time = $date . ' ' . $intime;
                                    $schedule->out_time = $shift_out_date . ' ' . $out_time;
                                    $schedule->remark = $remark;
                                    $schedule->status = 1;
                                    $schedule->save();
                                    $this->createRoster($schedule);
                                }
                            }
                        }
                    }
                }
            }

            $responseBody = $this->responseBody(true, "Employee Schedule", "all", $setting);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Employee Schedule", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }




    private function getEmployeeFromSettings($setting_aaray, $select_option)
    {


        $settings =  json_decode($setting_aaray);
        $category_id = $settings->category;
        $site_id = $settings->site;
        $department_id = $settings->department;
        $section_id = $settings->section;
        $subsection_id = $settings->sub_section;
        $company_id = $settings->company;
        $team_id = $settings->team;
        $employee_id = $settings->employee;


        $select =  json_decode($select_option);
        $category = $select->category;
        $site = $select->site;
        $department = $select->department;
        $section = $select->section;
        $subsection = $select->sub_section;
        $company = $select->company;
        $team = $select->team;
        $employee = $select->employee;

        $query = "SELECT hr_employees.*FROM hr_employees LEFT JOIN `hr_employee_teams` hr_employee_teams 
        ON hr_employees.`employee_id` = hr_employee_teams.`employee_id` WHERE ";
        //$query = preg_replace('/\W\w+\s*(\W*)$/', '$1', $query);

        if ($category == 'true') {
            $query .= "hr_employees.category_id = '" . $category_id . "' AND ";
        }

        if ($site == 'true') {
            $query .= "hr_employees.site_id = '" . $site_id . "' AND ";
        }

        if ($department == 'true') {
            $query .= "hr_employees.department_id = '" . $department_id . "' AND ";
        }

        if ($section == 'true') {
            $query .= "hr_employees.section_id = '" . $section_id . "' AND ";
        }

        if ($subsection == 'true') {
            $query .= "hr_employees.subsection_id = '" . $subsection_id . "' AND ";
        }

        if ($company == 'true') {
            $query .= "hr_employees.company_id = '" . $company_id . "' AND ";
        }

        if ($team == 'true') {
            $query .= "hr_employee_teams.team_id = '" . $team_id . "' AND ";
        }

        if ($employee == 'true') {
            $query .= "hr_employees.employee_id = '" . $employee_id . "' AND ";
        }
        $query .= "hr_employees.employeestatus_id != '4'";
        //$query = preg_replace('/\W\w+\s*(\W*)$/', '$1', $query);
        return DB::select($query);
    }




    public function getLocalMeanDate_from_Time($H, $M, $S)
    {

        $Hours = $H + ($M + ($S / 60.0)) / 60.0;
        $Days = $Hours / 24.0;

        return $Days;
    }





    public function getJulianDay($year, $month, $day)
    {

        $jd = 0.0;
        $gregorian = true;
        if ($year < 1582) {
            $gregorian = false;
        } else if ($year == 1582) {
            if (($month < 10) || (($month == 10) && ($day < 15))) {
                $gregorian = false;
            }
        }

        $y = 0.0;
        $m = 0.0;
        if ($month > 2) {
            $y = $year;
            $m = $month;
        } else {
            $y = $year - 1;
            $m = $month + 12;
        }

        $a = floor($y / 100);
        $b = 0.0;

        if ($gregorian) {
            $b = 2 - $a + floor($a / 4);
        } else {
            $b = 0.0;
        }
        $jd = floor(365.25 * ($y + 4716)) + floor(30.6001 * ($m + 1)) + $day + $b - 1524.5;

        return $jd;
    }




    public function getLocalDate($julianDay)
    {


        $jd0 = $julianDay + 0.5;
        $z = floor($jd0);
        $f = $jd0 - $z;

        $a = 0.0;
        $alp = 0.0;
        if ($z < 2299161) {
            $a = $z;
        } else {
            $alp = floor(($z - 1867216.25) / 36524.25);
            $a = $z + 1.0 + $alp - floor($alp / 4.0);
        }

        $b = $a + 1524;
        $c = floor(($b - 122.1) / 365.25);
        $d = floor(365.25 * $c);
        $e = floor(($b - $d) / 30.6001);

        $dayt = $b - $d - floor(30.6001 * $e) + $f;

        $mon = 0;
        if ($e < 13.5) {
            $mon = $e - 1;
        } else {
            $mon = $e - 13;
        }

        $yr = 0;
        if ($mon > 2.5) {
            $yr = $c - 4716;
        } else {
            $yr = $c - 4715;
        }

        $year = (int) floor($yr);
        $month = (int) floor($mon);
        if (strlen($month) == 1)
            $month = '0' . $month;
        $day = (int) floor($dayt);
        if (strlen($day) == 1)
            $day = '0' . $day;


        return ["year" => $year, "month" => $month, "day" => $day, "fullDate" => $year . '-' . $month . '-' . $day];
    }

    public function getLocalMeanTime($julianDayTime)
    {



        $localDate = $this->getLocalDate($julianDayTime);
        $julianDay = floor($julianDayTime); //$this->getJulianDay($localDate['year'], $localDate['month'], $localDate['day']);

        $time = ($julianDayTime - $julianDay) * 24.0;

        $H = (int) floor($time);
        $M = (int) floor(($time - $H) * 60.0);
        $S = floor(((($time - $H) * 60.0) - $M) * 60.0);

        return ["h" => $H, "m" => $M, "s" => $S, "fullTime" => $H . ":" . $M . ":" . $S];
    }





    function isDuplicateSchedule($employee_id, $date)
    {

        $schedule = AttSchedule::where('employee_id', '=', $employee_id)->where('schedule_date_from', '=', $date)->first();
        if ($schedule) {
            return true;
        }
        return false;
    }






    function isHoliday($date)
    {

        $holiday = AtdHoliday::where('holyday_date', '=', $date)->first();
        if ($holiday) {
            return true;
        }
        return false;
    }



    function isCoveringday($date, $site)
    {

        $result = DB::table('hr_atd_holiday_types')
            ->select('holyday_type')
            ->join('hr_atd_holidays', 'hr_atd_holidays.holyday_type_id', '=', 'hr_atd_holiday_types.holyday_type_id')
            ->where('hr_atd_holidays.holyday_date', $date)->where('hr_atd_holidays.site_id', $site)->first();

        if ($result) {
            $holiday = $result->holyday_type;
            if ($holiday == 'Covering Day') {
                return true;
            }
            return false;
        }
        return false;
    }



    public function loadEmployeeFromSite($site_id)
    {

        try {
            $employees = Employee::where('site_id', '=', $site_id)->get();
            $employee_list = [];
            foreach ($employees as $employee) {
                array_push($employee_list, [
                    "img" => $employee->photo_parth,
                    "id" => $employee->employee_id,
                    "value" => $employee->employee_id
                ]);
            }
            $responseBody = $this->responseBody(true, "AttScheduleController", "loadEmployeeFromSite", $employee_list);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Employee", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }





    public function loadScheduleFromSettings($shift_id, $main_site_id, $setting_aaray, $select_option, $start_date, $end_date)
    {
        try {
            $settings =  json_decode($setting_aaray);
            $category_id = $settings->category;
            $site_id = $settings->site;
            $department_id = $settings->department;
            $section_id = $settings->section;
            $subsection_id = $settings->sub_section;
            $company_id = $settings->company;
            $team_id = $settings->team;
            $employee_id = $settings->employee;


            $select =  json_decode($select_option);
            $category = $select->category;
            $site = $select->site;
            $department = $select->department;
            $section = $select->section;
            $subsection = $select->sub_section;
            $company = $select->company;
            $team = $select->team;
            $employee = $select->employee;

            $query = "SELECT DISTINCT
            hr_att_schedules.`schedule_id` AS schedule_id,
            hr_att_schedules.`employee_id` AS employee_id,
            hr_att_shifts.`shift_name` AS shift_name,
            hr_att_shifts.`shift_id` AS shift_id,
            hr_att_schedules.`schedule_date_from` AS schedule_date_from,
            hr_att_schedules.`in_time` AS in_time,
            hr_att_schedules.`out_time` AS out_time,
            hr_employees.`name_withinitial` AS name_withinitial
            FROM
            `hr_att_schedules` hr_att_schedules INNER JOIN `hr_att_shifts` hr_att_shifts ON hr_att_schedules.`shift_id` = hr_att_shifts.`shift_id`
            INNER JOIN `hr_employees` hr_employees ON hr_att_schedules.`employee_id` = hr_employees.`employee_id`
		    LEFT JOIN `hr_employee_teams` hr_employee_teams ON hr_employees.`employee_id` = hr_employee_teams.`employee_id` WHERE ";
            //$query = preg_replace('/\W\w+\s*(\W*)$/', '$1', $query);

            if ($category == 'true') {
                $query .= "hr_employees.category_id = '" . $category_id . "' AND ";
            }

            if ($site == 'true') {
                $query .= "hr_employees.site_id = '" . $site_id . "' AND ";
            }

            if ($department == 'true') {
                $query .= "hr_employees.department_id = '" . $department_id . "' AND ";
            }

            if ($section == 'true') {
                $query .= "hr_employees.section_id = '" . $section_id . "' AND ";
            }

            if ($subsection == 'true') {
                $query .= "hr_employees.subsection_id = '" . $subsection_id . "' AND ";
            }

            if ($company == 'true') {
                $query .= "hr_employees.company_id = '" . $company_id . "' AND ";
            }

            if ($team == 'true') {
                $query .= "hr_employee_teams.team_id = '" . $team_id . "' AND ";
            }

            if ($employee == 'true') {
                $query .= "hr_employees.employee_id = '" . $employee_id . "' AND ";
            }
            //$query = preg_replace('/\W\w+\s*(\W*)$/', '$1', $query);
            $query .= "hr_att_shifts.`shift_id` = '" . $shift_id . "' AND hr_employees.`site_id` = '" . $main_site_id . "' AND hr_att_schedules.`schedule_date_from` BETWEEN '" . $start_date . "' AND '" . $end_date . "'";
            $result = DB::select($query);

            $responseBody = $this->responseBody(true, "Employee Category", "all", $result);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Employee Category", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }



    private function createRoster($schedule)
    {

        $employee_id = $schedule->employee_id;
        $shift_id = $schedule->shift_id;
        $date = $schedule->schedule_date_from;
        $in_time = $schedule->in_time;
        $out_time = $schedule->out_time;

        DB::table('hr_att_time')->where('EmployeeID', $employee_id)->where('Date', $date)->delete();




        DB::table('hr_att_time')->insert([
            'EmployeeID' => $employee_id,
            'schedule_intime' => $in_time,
            'schedule_outtime' => $out_time,
            'ShiftNo' => $shift_id,
            'In_Status' => 0,
            'Out_Status' => 0,
            'Proccess' => 0,
            'Allowance' => 0,
            'Mini' => 0,
            'Date' => $date

        ]);
    }


    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
