<?php

namespace Modules\Hr\Http\Controllers;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Modules\Hr\Entities\Bank;
use Modules\Hr\Entities\BankBranch;
use Modules\Hr\Entities\Company;
use Modules\Hr\Entities\Employee;
use Modules\Hr\Entities\EmployeeCategory;
use Modules\Hr\Entities\EmployeeCivilstatus;
use Modules\Hr\Entities\EmployeeDepartment;
use Modules\Hr\Entities\EmployeeDesignation;
use Modules\Hr\Entities\EmployeeSection;
use Modules\Hr\Entities\EmployeeSite;
use Modules\Hr\Entities\EmployeeStatus;
use Modules\Hr\Entities\EmployeeSubsection;
use Modules\Hr\Entities\EmployeeType;
use Modules\Hr\Entities\GsDivision;
use Modules\Hr\Entities\LogActivityEmployee;
use Modules\Hr\Entities\MohDivision;
use Modules\Hr\Entities\Police;
use Modules\Hr\Entities\Town;

class EmployeeActivityController extends Controller
{
    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    public function index()
    {
        return view('hr::index');
    }

    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create()
    {
        return view('hr::create');
    }

    /**
     * Store a newly created resource in storage.
     * @param Request $request
     * @return Renderable
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Show the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function show($id)
    {
        return view('hr::show');
    }

    /**
     * Show the form for editing the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function edit($id)
    {
        return view('hr::edit');
    }

    /**
     * Update the specified resource in storage.
     * @param Request $request
     * @param int $id
     * @return Renderable
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     * @param int $id
     * @return Renderable
     */
    public function destroy($id)
    {
        //
    }



    public function employees()
    {
        try {
            $employees = Employee::all();

            $collection = [];
            for ($i = 0; $i < count($employees); $i++) {
                array_push($collection, ["img" => $employees[$i]['photo_parth'], "id" => $employees[$i]['employee_id'], "value" => $employees[$i]['name_withinitial']]);
            }
            $responseBody = $this->responseBody(true, "EmployeeActivityController", "Autocomplete", $collection);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "EmployeeActivityController", "Autocomplete", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    public function search($id, $date_from, $date_to)
    {
        try {
            $query = "SELECT hr_employees.employee_id,hr_employees.name_withinitial,hr_log_activity_employees.created_at,hr_log_activity_employees.rand_id FROM hr_log_activity_employees
            INNER JOIN hr_employees ON hr_log_activity_employees.value_id = hr_employees.employee_id WHERE hr_log_activity_employees.value_id = '" . $id . "' AND DATE(hr_log_activity_employees.created_at) BETWEEN '" . $date_from . "' AND '" . $date_to . "' GROUP BY rand_id";
            $result = DB::select($query);
            $responseBody = $this->responseBody(true, "EmployeeActivityController", "All", $result);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "EmployeeActivityController", "All", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }


    public function employeeRecordHistory($id)
    {
        try {
            $query = "SELECT * FROM hr_log_activity_employees WHERE hr_log_activity_employees.rand_id = '" . $id . "'";

            $result = DB::select($query);
            foreach ($result as $record) {
                if ($record->user_id == 1) {
                    $record->updated_by = 'Admin';
                } else {
                    $record->updated_by = Employee::find($record->user_id)->name_withinitial;
                }

                if ($record->field_name == 'Town') {
                    $record->old_value = Town::find($record->old_value)->town;
                    $record->new_value = Town::find($record->new_value)->town;
                }

                if ($record->field_name == 'Gender') {
                    if ($record->old_value == 1) {
                        $record->old_value = 'Male';
                    } else {
                        $record->old_value = 'Female';
                    }

                    if ($record->new_value == 1) {
                        $record->new_value = 'Male';
                    } else {
                        $record->new_value = 'Female';
                    }
                }

                if ($record->field_name == 'CivilStatus') {
                    $record->old_value = EmployeeCivilstatus::find($record->old_value)->civilstatus;
                    $record->new_value = EmployeeCivilstatus::find($record->new_value)->civilstatus;
                }

                if ($record->field_name == 'Designation') {
                    $record->old_value = EmployeeDesignation::find($record->old_value)->designation;
                    $record->new_value = EmployeeDesignation::find($record->new_value)->designation;
                }


                if ($record->field_name == 'Bank') {
                    $record->old_value = Bank::find($record->old_value)->bank;
                    $record->new_value = Bank::find($record->new_value)->bank;
                }

                if ($record->field_name == 'Bank Branch') {
                    $record->old_value = BankBranch::find($record->old_value)->bankbranch;
                    $record->new_value = BankBranch::find($record->new_value)->bankbranch;
                }

                if ($record->field_name == 'Employee Type') {
                    $record->old_value = EmployeeType::find($record->old_value)->employeetype;
                    $record->new_value = EmployeeType::find($record->new_value)->employeetype;
                }

                if ($record->field_name == 'Employee Status') {
                    $record->old_value = EmployeeStatus::find($record->old_value)->employeestatus;
                    $record->new_value = EmployeeStatus::find($record->new_value)->employeestatus;
                }

                if ($record->field_name == 'Category') {
                    $record->old_value = EmployeeCategory::find($record->old_value)->category;
                    $record->new_value = EmployeeCategory::find($record->new_value)->category;
                }

                if ($record->field_name == 'Site') {
                    $record->old_value = EmployeeSite::find($record->old_value)->site;
                    $record->new_value = EmployeeSite::find($record->new_value)->site;
                }

                if ($record->field_name == 'Department') {
                    $record->old_value = EmployeeDepartment::find($record->old_value)->department;
                    $record->new_value = EmployeeDepartment::find($record->new_value)->department;
                }

                if ($record->field_name == 'Section') {
                    $record->old_value = EmployeeSection::find($record->old_value)->section;
                    $record->new_value = EmployeeSection::find($record->new_value)->section;
                }

                if ($record->field_name == 'Subsection') {
                    $record->old_value = EmployeeSubsection::find($record->old_value)->subsection;
                    $record->new_value = EmployeeSubsection::find($record->new_value)->subsection;
                }

                if ($record->field_name == 'Company') {
                    $record->old_value = Company::find($record->old_value)->company;
                    $record->new_value = Company::find($record->new_value)->company;
                }

                if ($record->field_name == 'MOH Division') {
                    $record->old_value = MohDivision::find($record->old_value)->moh_division;
                    $record->new_value = MohDivision::find($record->new_value)->moh_division;
                }

                if ($record->field_name == 'Police Station') {
                    $record->old_value = Police::find($record->old_value)->police_station;
                    $record->new_value = Police::find($record->new_value)->police_station;
                }

                if ($record->field_name == 'GS Division') {
                    $record->old_value = GsDivision::find($record->old_value)->gs_division;
                    $record->new_value = GsDivision::find($record->new_value)->gs_division;
                }

                

            }
            $responseBody = $this->responseBody(true, "EmployeeActivityController", "History", $result);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "EmployeeActivityController", "History", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }




    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
