<?php

namespace Modules\Hr\Http\Controllers;


use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Modules\Hr\Entities\AttSchedule;
use Modules\Hr\Entities\Employee;
use Modules\Hr\Entities\EmployeeTeam;
use Modules\Hr\Entities\Team;

class EmployeeTeamController extends Controller
{
    //



    public function getAllEmployee()
    {

        $query = "SELECT 
        hr_employees.`employee_id` AS employee_id,
        hr_employees.`name_withinitial` AS name_withinitial,
        hr_employee_categories.`category` AS category,
        hr_employee_sites.`site` AS site,
        hr_employee_departments.`department` AS department,
        hr_employee_sections.`section` AS section,
        hr_employee_subsections.`subsection` AS subsection
        from hr_employees
        LEFT JOIN hr_employee_categories ON hr_employees.category_id = hr_employee_categories.category_id
        LEFT JOIN hr_employee_sites ON hr_employees.site_id = hr_employee_sites.site_id
        LEFT JOIN hr_employee_departments ON hr_employees.department_id = hr_employee_departments.department_id
        LEFT JOIN hr_employee_sections ON hr_employees.section_id = hr_employee_sections.section_id
        LEFT JOIN hr_employee_subsections ON hr_employees.subsection_id = hr_employee_subsections.subsection_id
        LEFT JOIN hr_employee_teams on hr_employees.employee_id = hr_employee_teams.employee_id WHERE hr_employees.employeestatus_id != '4' AND  ISNULL(hr_employee_teams.employee_id)  ";

        try {
            $employees = DB::select($query);
            $responseBody = $this->responseBody(true, "EmployeeTeam", "all", $employees);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "EmployeeTeam", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }




    public function allTeam()
    {
        try {
            $teams = Team::all();
            $responseBody = $this->responseBody(true, "Team", "all", $teams);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Team", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }




    public function setTeam(Request $request)
    {

        try {
            $team_employee_id = $this->getTeamEmployee($request->get('team_id'));
            $team = new EmployeeTeam();
            $team->team_id = $request->get('team_id');
            $team->employee_id = $request->get('employee_id');
            $save = $team->save();
            if ($save) {
                $this->setRoster($request->get('employee_id'), $team_employee_id);
                $responseBody = $this->responseBody(true, "Team", "saved", null);
            } else {
                $responseBody = $this->responseBody(false, "Team", "saved", $save);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Team", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }





    public function getTeamMember($id)
    {
        try {
            $query = "SELECT
	hr_teams.`team_name` AS team_name,
	hr_teams.`leader_id` AS leader_id,
	hr_employee_teams.`employee_id` AS employee_id,
	hr_employee_teams.`employee_team_id` AS employee_team_id
        FROM
	`hr_teams` hr_teams
        INNER JOIN `hr_employee_teams` hr_employee_teams ON hr_teams.`team_id` = hr_employee_teams.`team_id`
        INNER JOIN hr_employees ON hr_employee_teams.employee_id = hr_employees.employee_id
        WHERE hr_employee_teams.`team_id` = '" . $id . "' AND hr_employees.employeestatus_id != '4'";

            $team_members = DB::select($query);
            for ($i = 0; $i < count($team_members); $i++) {
                $emp_id = $team_members[$i]->employee_id;
                $employee = Employee::find($emp_id);
                if ($employee) {
                    $team_members[$i]->name_withinitial = $employee->name_withinitial;
                } else {
                    $team_members[$i]->name_withinitial = "";
                }

                $lead_id = $team_members[$i]->leader_id;
                $leader = Employee::find($lead_id);
                $team_members[$i]->leader = $leader->name_withinitial;
            }
            $responseBody = $this->responseBody(true, "EmployeeTeam", "all", $team_members);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "EmployeeTeam", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }




    public function isAssignedMmber($id)
    {
        try {
            $bool = false;
            $result = EmployeeTeam::where('employee_id', '=', $id)->get();
            if (count($result) > 0) {
                $bool = true;
            }
            $responseBody = $this->responseBody(true, "EmployeeTeam", "isAssignedMmber", $bool);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "EmployeeTeam", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }





    public function remove($id)
    {
        try {
            $team = EmployeeTeam::find($id);
            $delete = $team->delete();
            if ($delete) {
                $responseBody = $this->responseBody(true, "EmployeeTeam", "deleted", null);
            } else {
                $responseBody = $this->responseBody(false, "EmployeeTeam", "not deleted", $delete);
            }
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "EmployeeTeam", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }


    private function getTeamEmployee($team_id)
    {



        /*$query = "SELECT 
	het.employee_id
	FROM hr_employee_teams het
	INNER JOIN hr_att_schedules has ON het.employee_id = has.employee_id 
	WHERE has.schedule_date_from BETWEEN DATE_FORMAT(CURDATE(), '%Y-%m-01') AND LAST_DAY(CURDATE()) AND het.team_id = '" . $team_id . "' ORDER BY het.employee_team_id ASC LIMIT 1";*/

        $query = "SELECT 
het.employee_id
FROM hr_employee_teams het
INNER JOIN hr_att_schedules has ON het.employee_id = has.employee_id 
WHERE has.schedule_date_from BETWEEN '" . $this->getPayrollDateFrom() . "' AND '" . $this->getPayrollDateTo() . "' AND het.team_id = '" . $team_id . "' ORDER BY het.employee_team_id ASC LIMIT 1";

        $result = DB::select($query);

        $employee_id = NULL;
        if ($result) {
            $employee_id = $result[0]->employee_id;
        }
        return $employee_id;
    }


    private function setRoster($employee_id, $team_employee_id)
    {

        /*$query = "SELECT DISTINCT
        '" . $employee_id . "' AS employee_id,
        s.shift_id,
        s.schedule_date_from,
        s.in_time,
        s.out_time,
        s.status
        FROM hr_att_schedules s
        WHERE 
        s.schedule_date_from >= DATE_FORMAT(CURDATE(), '%Y-%m-01') AND
        s.schedule_date_from <= LAST_DAY(CURDATE())
        AND s.employee_id = '" . $team_employee_id . "'
        ORDER BY s.schedule_date_from ASC";*/


        $query = "SELECT DISTINCT
        '" . $employee_id . "' AS employee_id,
        s.shift_id,
        s.schedule_date_from,
        s.in_time,
        s.out_time,
        s.status
        FROM hr_att_schedules s
        WHERE 
        s.schedule_date_from >= '" . $this->getPayrollDateFrom() . "' AND
        s.schedule_date_from <= '" . $this->getPayrollDateTo() . "'
        AND s.employee_id = '" . $team_employee_id . "'
        ORDER BY s.schedule_date_from ASC";

 
        $result = DB::select($query);

        foreach ($result as $schedule) {

            $this->applySchedule($employee_id, $schedule->shift_id, $schedule->in_time, $schedule->out_time, $schedule->schedule_date_from);
            $this->createRoster($schedule);
        }
    }


    private function createRoster($schedule)
    {

        $employee_id = $schedule->employee_id;
        $shift_id = $schedule->shift_id;
        $date = $schedule->schedule_date_from;
        $in_time = $schedule->in_time;
        $out_time = $schedule->out_time;

        DB::table('hr_att_time')->where('EmployeeID', $employee_id)->where('Date', $date)->delete();




        DB::table('hr_att_time')->insert([
            'EmployeeID' => $employee_id,
            'schedule_intime' => $in_time,
            'schedule_outtime' => $out_time,
            'ShiftNo' => $shift_id,
            'In_Status' => 0,
            'Out_Status' => 0,
            'Proccess' => 0,
            'Allowance' => 0,
            'Mini' => 0,
            'Date' => $date

        ]);
    }




    private function applySchedule($employee_id, $shift, $intime, $outtime, $schedule_date_from)
    {

        try {
            $schedule = new AttSchedule();
            $schedule->employee_id = $employee_id;
            $schedule->shift_id = $shift;
            $schedule->schedule_date_from = $schedule_date_from;
            $schedule->in_time = $intime;
            $schedule->out_time = $outtime;
            $schedule->remark = "";
            $schedule->status = true;
            $schedule->save();


            $responseBody = $this->responseBody(true, "Shift", "updated", null);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Shift", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }


    public function getPayrollDateFrom()
    {

        $result =  DB::select('SELECT * FROM global_settings LIMIT 1');

        $date = '0000-00-00';
        $year = $result[0]->current_payroll_year;
        $month = (int)$result[0]->current_payroll_month;
        $digits = strlen((string)$month);
        if ($digits == 1) {
            $month = '0' . $month;
        }
        $date = $year . "-" . $month . "-01";


        return $date;
    }

    public function getPayrollDateTo()
    {

        $result =  DB::select('SELECT * FROM global_settings LIMIT 1');
        $last_date = DB::select("SELECT DAY(LAST_DAY(CURDATE())) AS last_day")[0]->last_day;

        $date = '0000-00-00';
        $year = $result[0]->current_payroll_year;
        $month = (int)$result[0]->current_payroll_month;
        $digits = strlen((string)$month);
        if ($digits == 1) {
            $month = '0' . $month;
        }
        $date = $year . "-" . $month ."-". $last_date;


        return $date;
    }




    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
