<?php

namespace Modules\Hr\Http\Controllers;


use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Modules\Hr\Entities\AtdHoliday;
use Modules\Hr\Entities\AttSchedule;
use Modules\Hr\Entities\AttShift;
use Modules\Hr\Entities\Team;

class EmployeeTeamScheduleController extends Controller
{
    //
    public function allTeam()
    {
        try {
            $teams = Team::all();
            $responseBody = $this->responseBody(true, "Team", "all", $teams);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Team", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    public function allTeamMembers($id)
    {

        $query = "SELECT
        hr_employees.`employee_id` AS employee_id,
        hr_employees.`name_withinitial` AS name_withinitial,
        hr_employee_categories.`category` AS category,
        hr_employee_sites.`site` AS site,
        hr_employee_departments.`department` AS department,
        hr_employee_sections.`section` AS section,
        hr_employee_subsections.`subsection` AS subsection
   FROM
        `hr_employee_categories` hr_employee_categories INNER JOIN `hr_employees` hr_employees ON hr_employee_categories.`category_id` = hr_employees.`category_id`
        INNER JOIN `hr_employee_sites` hr_employee_sites ON hr_employees.`site_id` = hr_employee_sites.`site_id`
        INNER JOIN `hr_employee_departments` hr_employee_departments ON hr_employees.`department_id` = hr_employee_departments.`department_id`
        INNER JOIN `hr_employee_sections` hr_employee_sections ON hr_employees.`section_id` = hr_employee_sections.`section_id`
        INNER JOIN `hr_employee_subsections` hr_employee_subsections ON hr_employees.`subsection_id` = hr_employee_subsections.`subsection_id`
        INNER JOIN `hr_employee_teams` hr_employee_teams ON hr_employees.`employee_id` = hr_employee_teams.`employee_id`
        AND hr_employee_sections.`section_id` = hr_employee_subsections.`section_id` WHERE hr_employee_teams.`team_id` = '" . $id . "'";

        try {
            $employees = DB::select($query);
            $responseBody = $this->responseBody(true, "EmployeeTeamSchedule", "all", $employees);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "EmployeeTeamSchedule", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }








    public function getAllEmployee(Request $request, $id)
    {
        $date = $request->get('date');

        $query = "SELECT
        hr_employees.`employee_id` AS employee_id,
        hr_employees.`name_withinitial` AS name_withinitial,
        hr_employee_categories.`category` AS category,
        hr_employee_sites.`site` AS site,
        hr_employee_departments.`department` AS department,
        hr_employee_sections.`section` AS section,
        hr_employee_subsections.`subsection` AS subsection
   FROM
        `hr_employee_categories` hr_employee_categories INNER JOIN `hr_employees` hr_employees ON hr_employee_categories.`category_id` = hr_employees.`category_id`
        INNER JOIN `hr_employee_sites` hr_employee_sites ON hr_employees.`site_id` = hr_employee_sites.`site_id`
        INNER JOIN `hr_employee_departments` hr_employee_departments ON hr_employees.`department_id` = hr_employee_departments.`department_id`
        INNER JOIN `hr_employee_sections` hr_employee_sections ON hr_employees.`section_id` = hr_employee_sections.`section_id`
        INNER JOIN `hr_employee_subsections` hr_employee_subsections ON hr_employees.`subsection_id` = hr_employee_subsections.`subsection_id`
        INNER JOIN `hr_employee_teams` hr_employee_teams ON hr_employees.`employee_id` = hr_employee_teams.`employee_id`
        AND hr_employee_sections.`section_id` = hr_employee_subsections.`section_id` WHERE hr_employee_teams.`team_id` = '" . $id . "'";

        try {
            $employee = DB::select($query);
            $array = [];
            for ($i = 0; $i < count($employee); $i++) {
                $employee_id = $employee[$i]->employee_id;
                $bool = $this->is_schedule($employee_id, $date);
                if (!$bool) {
                    array_push($array, $employee[$i]);
                }
            }
            $responseBody = $this->responseBody(true, "Employee Supervisor", "all", $array);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Employee", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }







    public function allShift()
    {

        try {
            $shift = $this->shift();

            $responseBody = $this->responseBody(true, "AllShift", "all", $shift);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "AllShift", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }




    public function shift()
    {

        try {
            $shift = AttShift::all();
            $collection = [];
            for ($i = 0; $i < count($shift); $i++) {
                array_push($collection, ["id" => $shift[$i]['shift_id'], "value" => $shift[$i]['shift_name']]);
            }
            return $collection;
        } catch (\Exception $exception) {
            return $exception;
        }
    }






    public function getAllEmployeeSchedule($id)
    {

        $date = date('Y-m-d');
        $query = "SELECT
        hr_employees.`employee_id` AS employee_id,
        hr_employees.`name_withinitial` AS name_withinitial,
        hr_att_shifts.`shift_name` AS shift_name,
        hr_att_shifts.`shift_id` AS shift_id,
        hr_att_schedules.`schedule_id` AS schedule_id,
        hr_att_schedules.`schedule_date_from` AS schedule_date_from,
        hr_att_schedules.`in_time` AS in_time,
        hr_att_schedules.`out_time` AS out_time
   FROM
        `hr_employees` hr_employees INNER JOIN `hr_att_schedules` hr_att_schedules ON hr_employees.`employee_id` = hr_att_schedules.`employee_id`
        INNER JOIN `hr_att_shifts` hr_att_shifts ON hr_att_schedules.`shift_id` = hr_att_shifts.`shift_id`
        INNER JOIN `hr_employee_teams` hr_employee_teams ON hr_employees.`employee_id` = hr_employee_teams.`employee_id` WHERE hr_employee_teams.`team_id` = '" . $id . "' AND hr_att_schedules.`schedule_date_from` = '" . $date . "'";

        try {
            $employee = DB::select($query);
            $responseBody = $this->responseBody(true, "EmployeeTeamSchedule", "all", $employee);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "EmployeeTeamSchedule", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }





    public function applyShift(Request $request)
    {


        try {
            $shift = $request->get('shift');
            $intime = $request->get('intime');
            $outtime = $request->get('outtime');
            $fromDate = $request->get('fromDate');
            $toDate = $request->get('toDate');
            $remark = $request->get('remark');
            $employee_id = $request->get('employee');


            $count = (strtotime($toDate) - strtotime($fromDate));
            $dayCount = ($count / (60 * 60 * 24));

            $date = $fromDate;

            for ($i = 0; $i <= $dayCount; $i++) {
                $isDuplicate = $this->isDuplicateSchedule($employee_id, $date);
                $isHoliday = $this->isHoliday($date);
                if (!$isDuplicate && !$isHoliday) {
                    $schedule = new AttSchedule();
                    $schedule->employee_id = $employee_id;
                    $schedule->shift_id = $shift;
                    $schedule->schedule_date_from = $date;
                    $schedule->in_time = $intime;
                    $schedule->out_time = $outtime;
                    $schedule->remark = $remark;
                    $schedule->status = true;
                    $schedule->save();
                }
                $nextDate = strtotime("1 day", strtotime($date));
                $date = date("Y-m-d", $nextDate);
            }

            $responseBody = $this->responseBody(true, "Shift", "saved", null);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Shift", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }





    function isDuplicateSchedule($employee_id, $date)
    {

        $schedule = AttSchedule::where('employee_id', '=', $employee_id)->where('schedule_date_from', '=', $date)->first();
        if ($schedule) {
            return true;
        }
        return false;
    }



    private function is_schedule($employee_id, $date)
    {
        $query = "SELECT
        hr_employees.`employee_id` AS hr_employees_employee_id FROM
        `hr_employees` hr_employees INNER JOIN `hr_att_schedules` hr_att_schedules ON hr_employees.`employee_id` = hr_att_schedules.`employee_id` WHERE hr_employees.`employee_id` = '" . $employee_id . "' AND hr_att_schedules.`schedule_date_from` = '" . $date . "'";

        $employee = DB::select($query);
        if (count($employee) > 0) {
            return true;
        }
        return false;
    }





    function isHoliday($date)
    {

        $holiday = AtdHoliday::where('holyday_date', '=', $date)->first();
        if ($holiday) {
            return true;
        }
        return false;
    }





    public function getEmployeeShift(Request $request, $id)
    {
        try {
            $shift = AttSchedule::where('employee_id', '=', $id)->where('schedule_date_from', '=', $request->get('date'))->first();
            $responseBody = $this->responseBody(true, "Shift", "shift", $shift);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Shift", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }




    public function removeShift($id)
    {

        try {
            $schedule =  AttSchedule::find($id);
            if ($schedule) {
                $schedule->delete();
            }
            $responseBody = $this->responseBody(true, "Shift", "remove", null);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Shift", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }








    public function updateShift(Request $request, $id)
    {


        try {
            $shift = $request->get('shift');
            $intime = $request->get('intime');
            $outtime = $request->get('outtime');
            $fromDate = $request->get('fromDate');
            $remark = $request->get('remark');
            //$toDate = $request->get('toDate');
            $employee_id = $request->get('employee');


            $schedule = AttSchedule::find($id);
            $schedule->employee_id = $employee_id;
            $schedule->shift_id = $shift;
            $schedule->schedule_date_from = $fromDate;
            $schedule->in_time = $intime;
            $schedule->out_time = $outtime;
            $schedule->remark = $remark;
            $schedule->status = true;
            $schedule->save();


            $responseBody = $this->responseBody(true, "Shift", "updated", null);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Shift", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }




    public function serverDate()
    {
        return date('Y-m-d');
    }



    public function getTeamSchedule($id)
    {

        try {
            $query = "SELECT DISTINCT
            hr_att_shifts.`shift_name` AS shift_name,
            hr_att_schedules.`shift_id` AS shift_id,
            hr_att_schedules.`schedule_date_from` AS schedule_date_from
       FROM
            `hr_att_shifts` hr_att_shifts INNER JOIN `hr_att_schedules` hr_att_schedules ON hr_att_shifts.`shift_id` = hr_att_schedules.`shift_id`
            INNER JOIN `hr_employees` hr_employees ON hr_att_schedules.`employee_id` = hr_employees.`employee_id`
            INNER JOIN `hr_employee_teams` hr_employee_teams ON hr_employees.`employee_id` = hr_employee_teams.`employee_id` WHERE hr_employee_teams.`team_id` = '" . $id . "'";

            $employees = DB::select($query);
            $responseBody = $this->responseBody(true, "TeamSchedul", "all", $employees);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "TeamSchedul", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }



    public function getTeamScheduleDateRange(Request $request, $id)
    {

        try {
            $start = $request->get('start');
            $end = $request->get('end');

            $employees = DB::select("SELECT DISTINCT
            hr_att_shifts.`shift_name` AS shift_name,
            hr_att_schedules.`shift_id` AS shift_id,
            hr_att_schedules.`schedule_date_from` AS schedule_date_from
       FROM
            `hr_att_shifts` hr_att_shifts INNER JOIN `hr_att_schedules` hr_att_schedules ON hr_att_shifts.`shift_id` = hr_att_schedules.`shift_id`
            INNER JOIN `hr_employees` hr_employees ON hr_att_schedules.`employee_id` = hr_employees.`employee_id`
            INNER JOIN `hr_employee_teams` hr_employee_teams ON hr_employees.`employee_id` = hr_employee_teams.`employee_id` where hr_employee_teams.`team_id` = '" . $id . "' AND hr_att_schedules.`schedule_date_from` BETWEEN '" . $start . "' AND '" . $end . "' ORDER BY schedule_date_from");
            $responseBody = $this->responseBody(true, "TeamSchedul", "all", $employees);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "TeamSchedul", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }





    public function getEmplyeeHolidays()
    {

        try {
            $holidays = DB::select("SELECT
            hr_atd_holiday_types.`holyday_type_id` AS holyday_type_id,
            hr_atd_holidays.`holyday_date` AS holyday_date,
            hr_atd_holiday_types.`holyday_type` AS holyday_type
       FROM
            `hr_atd_holiday_types` hr_atd_holiday_types INNER JOIN `hr_atd_holidays` hr_atd_holidays ON hr_atd_holiday_types.`holyday_type_id` = hr_atd_holidays.`holyday_type_id`");
            $responseBody = $this->responseBody(true, "Holidays", "all", $holidays);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "Holidays", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }

    


    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
